﻿using log4net;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.WMCUP.Module
{
    public static class JsonHelper
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog Log = LogManager.GetLogger(typeof(JsonHelper));
        /// <summary>
        /// 根据POST方法请求获取
        /// </summary>
        /// <param name="url"></param>
        /// <param name="dic"></param>
        /// <returns></returns>
        public static string Post(string url, Dictionary<string, string> dic, string key)
        {
            string result = "";
            try
            {
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
                req.Method = "POST";
                req.ContentType = "application/x-www-form-urlencoded";
                req.Headers.Add("App-Authorization", key);
                StringBuilder builder = new StringBuilder();
                int i = 0;
                foreach (var item in dic)
                {
                    if (i > 0)
                        builder.Append("&");
                    builder.AppendFormat("{0}={1}", item.Key, item.Value);
                    i++;
                }
                byte[] data = Encoding.UTF8.GetBytes(builder.ToString());
                using (Stream reqStream = req.GetRequestStream())
                {
                    reqStream.Write(data, 0, data.Length);
                    reqStream.Close();
                }
                //获取相应内容
                HttpWebResponse resp = (HttpWebResponse)req.GetResponse();
                Stream stream = resp.GetResponseStream();
                using (StreamReader reader = new StreamReader(stream, Encoding.UTF8))
                {
                    result = reader.ReadToEnd();
                }

            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
            return result;
        }


        /// <summary>
        /// 根据Get方法获取
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>

        public static string GetResult(string url)
        {
            string data = "";

            try
            {
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
                req.Headers["Accept-Encoding"] = "gzip,deflate";
                req.AutomaticDecompression = DecompressionMethods.GZip;
                HttpWebResponse resp = (HttpWebResponse)req.GetResponse();
                Stream stream = resp.GetResponseStream();
                //获取内容
                using (StreamReader reader = new StreamReader(stream, Encoding.UTF8))
                {
                    data = reader.ReadToEnd();
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }

            return data;
        }
    }
}
