﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.HtmlControls;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    public class FComparePlayerViewModel : ViewModelBase
    {
        private static ILog Log = LogManager.GetLogger(typeof(FComparePlayerViewModel));

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();


        //private static PlayerCompareViewModel _createInstance = null;

        public static List<FComparePlayerViewModel> PlayerCompareViewModelInstance = new List<FComparePlayerViewModel>();


        public string homeTeamId;

        public string visitTeamId;

        public string homeNationTeam;

        public string awayNationTeam;

        public string matchId;

        public FComparePlayerViewModel()
        {
            BtnCommand = new VCommand(BtnCmd);

            //选择主队图片
            BtmChooseHomeImage = new VCommand(ChooseHoemImage);

            //选择客队图片
            BtmChooseAwayImage = new VCommand(ChooseAwayImage);
  
            matchStatsIds = new ObservableCollection<int>()
            {
                3,
                4,
                5,
                6
            };

            PromptCommand = new VCommand(this.PromptCmd);
            //ScheduleID = DateHeaderViewModel.ScheduleID;
            //Matchtypeid = DateHeaderViewModel.Matchtypeid;

            homeTeamId = DateHeaderViewModel.HomeTeamId;
            visitTeamId = DateHeaderViewModel.VisitTeamId;
            homeNationTeam = DateHeaderViewModel.HomeNationName;
            awayNationTeam = DateHeaderViewModel.VisitingNationName;
            matchId = DateHeaderViewModel.MatchId;  

            HName = DateHeaderViewModel.HomeTeamName;
            AName = DateHeaderViewModel.VisitingTeamName;

            SetTeamData();
        }




        /// <summary>
        /// 技术统计项
        /// </summary>
        private int matchStatsId = 6;

        public int MatchStatsId
        {
            get { return matchStatsId; }

            set
            {

                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));


                if (matchStatsId == 3)
                {

                    IsCheckVisible3 = Visibility.Hidden;
                    HScoreVisible3 = Visibility.Hidden;
                    HSeasonScoreVisible3 = Visibility.Hidden;
                    TechStatsVisible3 = Visibility.Hidden;
                    AScoreVisible3 = Visibility.Hidden;
                    ASeasonScoreVisible3 = Visibility.Hidden;


                    IsCheckVisible4 = Visibility.Hidden;
                    HScoreVisible4 = Visibility.Hidden;
                    HSeasonScoreVisible4 = Visibility.Hidden;
                    TechStatsVisible4 = Visibility.Hidden;
                    AScoreVisible4 = Visibility.Hidden;
                    ASeasonScoreVisible4 = Visibility.Hidden;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                }


                if (matchStatsId == 4)
                {

                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;



                    IsCheckVisible4 = Visibility.Hidden;
                    HScoreVisible4 = Visibility.Hidden;
                    HSeasonScoreVisible4 = Visibility.Hidden;
                    TechStatsVisible4 = Visibility.Hidden;
                    AScoreVisible4 = Visibility.Hidden;
                    ASeasonScoreVisible4 = Visibility.Hidden;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                    //IsCheckVisible6 = Visibility.Hidden;
                    //HScoreVisible6 = Visibility.Hidden;
                    //HSeasonScoreVisible6 = Visibility.Hidden;
                    //TechStatsVisible6 = Visibility.Hidden;
                    //AScoreVisible6 = Visibility.Hidden;
                    //ASeasonScoreVisible6 = Visibility.Hidden;


                }
                else if (matchStatsId == 5)
                {

                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;

                    IsCheckVisible4 = Visibility.Visible;
                    HScoreVisible4 = Visibility.Visible;
                    HSeasonScoreVisible4 = Visibility.Visible;
                    TechStatsVisible4 = Visibility.Visible;
                    AScoreVisible4 = Visibility.Visible;
                    ASeasonScoreVisible4 = Visibility.Visible;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                    //IsCheckVisible6 = Visibility.Hidden;
                    //HScoreVisible6 = Visibility.Hidden;
                    //HSeasonScoreVisible6 = Visibility.Hidden;
                    //TechStatsVisible6 = Visibility.Hidden;
                    //AScoreVisible6 = Visibility.Hidden;
                    //ASeasonScoreVisible6 = Visibility.Hidden;

                }
                else if (matchStatsId == 6)
                {


                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;


                    IsCheckVisible4 = Visibility.Visible;
                    HScoreVisible4 = Visibility.Visible;
                    HSeasonScoreVisible4 = Visibility.Visible;
                    TechStatsVisible4 = Visibility.Visible;
                    AScoreVisible4 = Visibility.Visible;
                    ASeasonScoreVisible4 = Visibility.Visible;




                    IsCheckVisible5 = Visibility.Visible;
                    HScoreVisible5 = Visibility.Visible;
                    HSeasonScoreVisible5 = Visibility.Visible;
                    TechStatsVisible5 = Visibility.Visible;
                    AScoreVisible5 = Visibility.Visible;
                    ASeasonScoreVisible5 = Visibility.Visible;

                    //IsCheckVisible6 = Visibility.Visible;
                    //HScoreVisible6 = Visibility.Visible;
                    //HSeasonScoreVisible6 = Visibility.Visible;
                    //TechStatsVisible6 = Visibility.Visible;
                    //AScoreVisible6 = Visibility.Visible;
                    //ASeasonScoreVisible6 = Visibility.Visible;
                }

                NewSetHData(0);
                NewSetAData(0);

            }
        }


        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }


        private ObservableCollection<string> hPlayers;

        /// <summary>
        /// 主队球员信息
        /// </summary>
        public ObservableCollection<string> HPlayers
        {
            get { return hPlayers; }

            set { hPlayers = value; this.RaisePropertyChanged(nameof(HPlayers)); }
        }

        private ObservableCollection<string> aPlayers;

        /// <summary>
        /// 客队球员信息
        /// </summary>
        public ObservableCollection<string> APlayers
        {
            get { return aPlayers; }
            set { aPlayers = value; this.RaisePropertyChanged(nameof(APlayers)); }
        }


        /// <summary>
        /// 主队球员图片
        /// </summary>
        private ImageSource hPlayerLogo;

        public ImageSource HPlayerLogo
        {
            get { return hPlayerLogo; }
            set { hPlayerLogo = value; this.RaisePropertyChanged(nameof(HPlayerLogo)); }
        }


        /// <summary>
        /// 按钮刷新
        /// </summary>
        public VCommand BtnCommand { get; set; }

        private void BtnCmd()
        {
            NewSetHData(0);

            NewSetAData(0);

            //SetTeamData();
        }



        // string baesePath = AppDomain.CurrentDomain.BaseDirectory;

        private string aPlayer;

        public string APlayer
        {
            get { return aPlayer; }
            set
            {
                aPlayer = value;
                this.RaisePropertyChanged(nameof(APlayer));

                if (APlayer == null) return;


                //}

                string playPath = string.Format("{0}\\{1}\\{2}.png", AppSetup_InitLiteDB.HttpUrlConfigEntity.PlayersLogo, awayNationTeam, APlayer);
                if (File.Exists(playPath))
                {
                    APlayerLogo = new BitmapImage(new Uri(playPath));
                }
                else
                {
                    APlayerLogo = null;
                }

                AwayImage = aPlayer;

                if (APlayerData.ContainsKey(APlayer))
                {
                    ANums = APlayerData[APlayer].Item2;
                }
                NewSetAData(0);
            }
        }

        /// <summary>
        /// 客队球员图片
        /// </summary>
        private ImageSource aPlayerLogo;
        public ImageSource APlayerLogo
        {
            get { return aPlayerLogo; }
            set { aPlayerLogo = value; this.RaisePropertyChanged(nameof(APlayerLogo)); }
        }


        private string hPlayer;

        public string HPlayer
        {
            get { return hPlayer; }
            set
            {
                hPlayer = value;
                this.RaisePropertyChanged(nameof(HPlayer));
                if (HPlayer == null) return;
                //if (HName == "北京控股666")
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                //    {
                //        HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                //    }

                //}
                //else
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HName)))
                //    {
                //        HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HName)));
                //    }

                //}

                string playPath = string.Format("{0}\\{1}\\{2}.png", AppSetup_InitLiteDB.HttpUrlConfigEntity.PlayersLogo, homeNationTeam, hPlayer);

                if (File.Exists(playPath))
                {
                    HPlayerLogo = new BitmapImage(new Uri(playPath));
                }
                else
                {
                    HPlayerLogo = null;
                }


                HomeImage = hPlayer;

                if (HPlayerData.ContainsKey(HPlayer))
                {
                    HNums = HPlayerData[HPlayer].Item2;

                    //  HNums = HPlayerData[HPlayer].Item2;
                }
                NewSetHData(0);
            }
        }

        private string hName;

        public string HName
        {
            get { return hName; }
            set
            {
                hName = value;
                this.RaisePropertyChanged(nameof(HName));


            }
        }


        private string aName;

        public string AName
        {
            get { return aName; }
            set { aName = value; this.RaisePropertyChanged(nameof(AName)); }
        }


        private string hNums;

        public string HNums
        {
            get { return hNums; }

            set { hNums = value; this.RaisePropertyChanged(nameof(HNums)); }
        }


        private string aNums;

        public string ANums
        {
            get { return aNums; }

            set { aNums = value; this.RaisePropertyChanged(nameof(ANums)); }
        }

        private string title = "数据对比";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }



        /// <summary>
        /// 主队球员信息全部
        /// </summary>
        // public TeamStats teamHomeStats = new TeamStats();

        public SingleTeamPlayers homeTeamPlayer = new SingleTeamPlayers();

        /// <summary>
        /// 客队队伍统计得分
        /// </summary>
        //public TeamStats teamVisitStats = new TeamStats();


        // 客队球员信息全部
        public SingleTeamPlayers visitTeamPlayer = new SingleTeamPlayers();



        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "单球员数据统计：" + PluginConstant.Operate_Message);
            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
   
           
            if (homeTeamPlayer != null)
            {
                string teamSeasonLastDate = $"单球员统计接口更新时间:{homeTeamPlayer.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }


            if (visitTeamPlayer != null)
            {
                string teamSeasonLastDate = $"单球员统计接口更新时间:{visitTeamPlayer.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }

            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }




        #endregion


        #region 选择图片



        private string homeImage;

        public string HomeImage
        {
            get { return homeImage; }
            set { homeImage = value; this.RaisePropertyChanged(nameof(HomeImage)); }
        }


        /// <summary>
        /// 选择主队图片
        /// </summary>
        public VCommand BtmChooseHomeImage { get; set; }


        private void ChooseHoemImage()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Filter = "Image|*.png;";//*.jpg;*.jpeg;*.bmp;
            ofd.Multiselect = false;
            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            HPlayerLogo = new BitmapImage(new Uri((ofd.FileName)));
            //this.PlayerName = ofd.FileName.Replace(@"\", @"\\");

            //string name = System.IO.Path.GetFileName(ofd.FileName);
            HomeImage = Path.GetFileNameWithoutExtension(ofd.FileName);
        }



        /// <summary>
        /// 客队中图片
        /// </summary>

        private string awayImage;

        public string AwayImage
        {
            get { return awayImage; }
            set { awayImage = value; this.RaisePropertyChanged(nameof(AwayImage)); }
        }


        /// <summary>
        /// 选择客队图片
        /// </summary>
        public VCommand BtmChooseAwayImage { get; set; }

        private void ChooseAwayImage()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Filter = "Image|*.png;";//*.jpg;*.jpeg;*.bmp;
            ofd.Multiselect = false;
            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            APlayerLogo = new BitmapImage(new Uri((ofd.FileName)));
            //this.PlayerName = ofd.FileName.Replace(@"\", @"\\");

            //string name = System.IO.Path.GetFileName(ofd.FileName);
            AwayImage = Path.GetFileNameWithoutExtension(ofd.FileName);
        }

        #endregion




        public Dictionary<string, string> VisitScoreDictionary = new Dictionary<string, string>();


        //private void SetVisitHomeDictionary()
        //{

        //    VisitScoreDictionary.Clear();
        //    if (teamVisitStats == null || teamVisitStats.teamStat == null) return;
        //    foreach (var teamSeasonData in teamVisitStats.teamStat.FirstOrDefault().statistics)
        //    {
        //        if (!VisitScoreDictionary.ContainsKey(teamSeasonData.name))
        //        {
        //            VisitScoreDictionary.Add(teamSeasonData.name, teamSeasonData.value);
        //        }

        //    }
        //}



        public Dictionary<string, string> HomeScoreDictionary = new Dictionary<string, string>();




        public PageModel page = null;

        static ObservableCollection<string> listTechStats = new ObservableCollection<string>() { "进球","助攻", "射门", "传球成功", "传球正确率", "关键传球", "拦截" };//"罚球",




        public Dictionary<string, Tuple<string, string>> HPlayerData = new Dictionary<string, Tuple<string, string>>();

        public Dictionary<string, Tuple<string, string>> APlayerData = new Dictionary<string, Tuple<string, string>>();

        public async void SetTeamData()
        {
            if (HPlayers != null) HPlayers.Clear();
            if (APlayers != null) APlayers.Clear();

            HPlayerData.Clear();
            APlayerData.Clear();


            Log.Info("开始获取主队球员信息");

            homeTeamPlayer = await JsonModel.PostTeamPlayerData_Path(homeTeamId,matchId ,"");
            if (homeTeamPlayer == null) return;

            Log.Info("结束获取主队球员信息");


            foreach (var hPlayer in homeTeamPlayer.matchTeamPlayers)
            {
                if (!HPlayerData.ContainsKey(hPlayer.figureName) && !string.IsNullOrEmpty(hPlayer.figureName))
                {
                    HPlayerData.Add(hPlayer.figureName, new Tuple<string, string>(hPlayer.figureId, hPlayer.playerNum));
                }
            }

            Log.Info("开始获取客队球员信息");

            visitTeamPlayer = await JsonModel.PostTeamPlayerData_Path(visitTeamId, matchId,"");
            if (visitTeamPlayer == null) return;

            Log.Info("开始结束客队球员信息");

            foreach (var aPlayer in visitTeamPlayer.matchTeamPlayers)
            {
                if (!APlayerData.ContainsKey(aPlayer.figureName) && !string.IsNullOrEmpty(aPlayer.figureName))
                {
                    APlayerData.Add(aPlayer.figureName, new Tuple<string, string>(aPlayer.figureId, aPlayer.playerNum));
                }
            }


            HPlayers = new ObservableCollection<string>();

            APlayers = new ObservableCollection<string>();

            HPlayers = HPlayerData.Keys.ToObservableCollection();

            APlayers = APlayerData.Keys.ToObservableCollection();

            //SetPlayerStatic();

            NewSetHData(0);

            NewSetAData(0);
        }



        public string CombineTeamComData()
        {
            try
            {
                string data = "";

                //if (matchStatsId != 0)
                //{
                //    data += matchStatsId.ToString().Replace(" ", "") + "*";
                //}
                //else
                //{
                //    data += "7*";
                //}
                data += title.ToString().Replace(" ", "") + "&";

                if (!string.IsNullOrEmpty(homeNationTeam))
                {
                    data += homeNationTeam.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                //if (!string.IsNullOrEmpty(HName))
                //{
                //    data += HName.Replace(" ", "") + "#";
                //}
                //else
                //{
                //    data += "" + "#";
                //}

                //if (!string.IsNullOrEmpty(ANums))
                //{
                //    data += ANums.Replace(" ", "") + "#";
                //}
                //else
                //{
                //    data += "" + "#";
                //}


                if (!string.IsNullOrEmpty(HPlayer))
                {
                    data += HPlayer.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                if (!string.IsNullOrEmpty(HomeImage))
                {
                    data += HomeImage.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }




                if (!string.IsNullOrEmpty(awayNationTeam))
                {
                    data += awayNationTeam.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                if (!string.IsNullOrEmpty(APlayer))
                {
                    data += APlayer.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                if (!string.IsNullOrEmpty(AwayImage))
                {
                    data += AwayImage.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }

                if (matchStatsId == 6)
                {

                    if (!string.IsNullOrEmpty(HomeScore))
                    {
                        data += HomeScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第二项


                    if (!string.IsNullOrEmpty(HomeScore1))
                    {
                        data += HomeScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项


                    if (!string.IsNullOrEmpty(HomeScore2))
                    {
                        data += HomeScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第四项


                    if (!string.IsNullOrEmpty(HomeScore3))
                    {
                        data += HomeScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第五项

                    if (!string.IsNullOrEmpty(HomeScore4))
                    {
                        data += HomeScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }




                    data += selectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore4))
                    {
                        data += AwayScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第六项

                    if (!string.IsNullOrEmpty(HomeScore5))
                    {
                        data += HomeScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats5.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore5))
                    {
                        data += AwayScore5.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                }
                else if (matchStatsId == 5)
                {
                    //第一项

                    if (!string.IsNullOrEmpty(HomeScore))
                    {
                        data += HomeScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    if (!string.IsNullOrEmpty(HomeScore1))
                    {
                        data += HomeScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第三项


                    if (!string.IsNullOrEmpty(HomeScore2))
                    {
                        data += HomeScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第四项


                    if (!string.IsNullOrEmpty(HomeScore3))
                    {
                        data += HomeScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第五项

                    if (!string.IsNullOrEmpty(HomeScore4))
                    {
                        data += HomeScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    data += selectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore4))
                    {
                        data += AwayScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }

                }

                else if (matchStatsId == 4)
                {
                    //第一项

                    if (!string.IsNullOrEmpty(HomeScore))
                    {
                        data += HomeScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    if (!string.IsNullOrEmpty(HomeScore1))
                    {
                        data += HomeScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第三项


                    if (!string.IsNullOrEmpty(HomeScore2))
                    {
                        data += HomeScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第四项


                    if (!string.IsNullOrEmpty(HomeScore3))
                    {
                        data += HomeScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                }
                else if (matchStatsId == 3)
                {
                    //第一项

                    if (!string.IsNullOrEmpty(HomeScore))
                    {
                        data += HomeScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    if (!string.IsNullOrEmpty(HomeScore1))
                    {
                        data += HomeScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项


                    if (!string.IsNullOrEmpty(HomeScore2))
                    {
                        data += HomeScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                }

                Log.Info("发送脚本命令====>："+data);

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }



        /// <summary>
        /// 设置主场数据
        /// </summary>
        /// <param name="index"></param>

        public async void NewSetHData(int index)
        {


            // 主队技术统计得分
            string HfigureId = "";

            if (HPlayer == null) return;
            if (HPlayerData.ContainsKey(HPlayer))
            {

                HfigureId = HPlayerData[HPlayer].Item1;
            }

            if (!string.IsNullOrEmpty(HfigureId))
            {

                HomeScoreDictionary.Clear();
                var singlePlayers = await JsonModel.PostSinglePlayerData_Path(HfigureId);

                if (singlePlayers == null || singlePlayers.playerStat == null) return;

                //homeNationTeam = singlePlayers.playerStat.nationName;

                foreach (var player in singlePlayers.playerStat.statistics)
                {
                    if (!HomeScoreDictionary.ContainsKey(player.name))
                    {
                        HomeScoreDictionary.Add(player.name, player.value);
                    }
                }
            }


            if (HomeScoreDictionary.Count == 0) return;

            if (index == 1)
            {
                //第一项

                if (SelectTechStats!=null&& HomeScoreDictionary.ContainsKey(SelectTechStats))
                {
                    HomeScore = HomeScoreDictionary[SelectTechStats];
                }
                else
                {
                    HomeScore = "0";
                }

            }
            else if (index == 2)
            {


                //第二项

                if (SelectTechStats1!=null&&HomeScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    HomeScore1 = HomeScoreDictionary[SelectTechStats1];
                }
                else
                {
                    HomeScore1 = "0";
                }


            }
            else if (index == 3)
            {
                //第三项

                if (SelectTechStats2!=null&&HomeScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    HomeScore2 = HomeScoreDictionary[SelectTechStats2];
                }
                else
                {
                    HomeScore2 = "0";
                }


            }
            else if (index == 4)
            {
                //第四项

                if (SelectTechStats3 != null &&HomeScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    HomeScore3 = HomeScoreDictionary[SelectTechStats3];
                }
                else
                {
                    HomeScore3 = "0";
                }


            }
            else if (index == 5)
            {

                //第五项

                if (SelectTechStats4 != null &&HomeScoreDictionary.ContainsKey(SelectTechStats4))
                {
                    HomeScore4 = HomeScoreDictionary[SelectTechStats4];
                }
                else
                {
                    HomeScore4 = "0";
                }


            }
            else if (index == 6)
            {

                //第六项

                if (SelectTechStats5 != null && HomeScoreDictionary.ContainsKey(SelectTechStats5))
                {
                    HomeScore5 = HomeScoreDictionary[SelectTechStats5];
                }
                else
                {
                    HomeScore5 = "0";
                }


            }

            else
            {


                //第一项

                if (SelectTechStats != null && HomeScoreDictionary.ContainsKey(SelectTechStats))
                {
                    HomeScore = HomeScoreDictionary[SelectTechStats];
                }
                else
                {
                    HomeScore = "0";
                }



                //第二项

                if (SelectTechStats1 != null && HomeScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    HomeScore1 = HomeScoreDictionary[SelectTechStats1];
                }
                else
                {
                    HomeScore1 = "0";
                }



                //第三项

                if (SelectTechStats2 != null && HomeScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    HomeScore2 = HomeScoreDictionary[SelectTechStats2];
                }
                else
                {
                    HomeScore2 = "0";
                }



                //第四项

                if (SelectTechStats3 != null && HomeScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    HomeScore3 = HomeScoreDictionary[SelectTechStats3];
                }
                else
                {
                    HomeScore3 = "0";
                }



                //第五项

                if (SelectTechStats4 != null && HomeScoreDictionary.ContainsKey(SelectTechStats4))
                {
                    HomeScore4 = HomeScoreDictionary[SelectTechStats4];
                }
                else
                {
                    HomeScore4 = "0";
                }



                //第六项

                if (SelectTechStats5 != null && HomeScoreDictionary.ContainsKey(SelectTechStats5))
                {
                    HomeScore5 = HomeScoreDictionary[SelectTechStats5];
                }
                else
                {
                    HomeScore5 = "0";
                }

            }


        }



        /// <summary>
        /// 设置客场信息
        /// </summary>
        /// <param name="teamStatsViewModel"></param>
        public async void NewSetAData(int index)
        {


            //客队技术统计
            string AfigureId = "";

            if (APlayer == null) return;
            if (APlayerData.ContainsKey(APlayer))
            {
                // ANums = APlayerData[APlayer].Item2;
                AfigureId = APlayerData[APlayer].Item1;
            }



            if (!string.IsNullOrEmpty(AfigureId))
            {

                VisitScoreDictionary.Clear();

                var singlePlayers = await JsonModel.PostSinglePlayerData_Path(AfigureId);

                if (singlePlayers == null || singlePlayers.playerStat == null) return;

                //homeNationTeam = singlePlayers.playerStat.nationName;

                foreach (var player in singlePlayers.playerStat.statistics)
                {
                    if (!VisitScoreDictionary.ContainsKey(player.name))
                    {
                        VisitScoreDictionary.Add(player.name, player.value);
                    }
                }
            }


            if (VisitScoreDictionary.Count == 0) return;

            if (index == 1)
            {
                //第一项
                if (SelectTechStats!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats))
                {
                    AwayScore = VisitScoreDictionary[SelectTechStats];
                }
                else
                {
                    AwayScore = "0";
                }


            }
            else if (index == 2)
            {
                //第二项
                if (SelectTechStats1!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    AwayScore1 = VisitScoreDictionary[SelectTechStats1];
                }
                else
                {
                    AwayScore1 = "0";
                }


            }
            else if (index == 3)
            {

                //第三项
                if (SelectTechStats2!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    AwayScore2 = VisitScoreDictionary[SelectTechStats2];
                }
                else
                {
                    AwayScore2 = "0";
                }



            }
            else if (index == 4)
            {
                //第四项
                if (SelectTechStats3!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    AwayScore3 = VisitScoreDictionary[SelectTechStats3];
                }
                else
                {
                    AwayScore3 = "0";
                }



            }

            else if (index == 5)
            {
                //第五项
                if (SelectTechStats4!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats4))
                {
                    AwayScore4 = VisitScoreDictionary[SelectTechStats4];
                }
                else
                {
                    AwayScore4 = "0";
                }



            }
            else if (index == 6)
            {


                //第六项
                if (SelectTechStats5!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats5))
                {
                    //VisitScoreDictionary  VisitTeamCompareOptionDictionary
                    AwayScore5 = VisitScoreDictionary[SelectTechStats5];
                }
                else
                {
                    AwayScore5 = "0";
                }


            }

            else
            {

                //第一项
                if (SelectTechStats!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats))
                {
                    AwayScore = VisitScoreDictionary[SelectTechStats];
                }
                else
                {
                    AwayScore = "0";
                }


                //第二项
                if (SelectTechStats1!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    AwayScore1 = VisitScoreDictionary[SelectTechStats1];
                }
                else
                {
                    AwayScore1 = "0";
                }



                //第三项
                if (SelectTechStats2!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    AwayScore2 = VisitScoreDictionary[SelectTechStats2];
                }
                else
                {
                    AwayScore2 = "0";
                }



                //第四项
                if (SelectTechStats3!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    AwayScore3 = VisitScoreDictionary[SelectTechStats3];
                }
                else
                {
                    AwayScore3 = "0";
                }



                //第五项
                if (SelectTechStats4!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats4))
                {
                    AwayScore4 = VisitScoreDictionary[SelectTechStats4];
                }
                else
                {
                    AwayScore4 = "0";
                }



                //第六项
                if (SelectTechStats5!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats5))
                {
                    AwayScore5 = VisitScoreDictionary[SelectTechStats5];
                }
                else
                {
                    AwayScore5 = "0";
                }






            }
        }



        #region 第一项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight;

        public bool IsHeight
        {
            get { return isHeight; }
            set { isHeight = value; this.RaisePropertyChanged(nameof(IsHeight)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible;
        public Visibility IsCheckVisible
        {
            get { return isCheckVisible; }
            set { isCheckVisible = value; this.RaisePropertyChanged(nameof(IsCheckVisible)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore;

        public string HomeScore
        {
            get { return homeScore; }
            set { homeScore = value; this.RaisePropertyChanged(nameof(HomeScore)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible;

        public Visibility HScoreVisible
        {
            get { return hScoreVisible; }
            set { hScoreVisible = value; this.RaisePropertyChanged(nameof(hScoreVisible)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore;

        public string HSeasonScore
        {
            get { return hSeasonScore; }
            set { hSeasonScore = value; this.RaisePropertyChanged(nameof(HSeasonScore)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible;
        public Visibility HSeasonScoreVisible
        {
            get { return hSeasonScoreVisible; }
            set { hSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats = listTechStats;

        public ObservableCollection<string> TechStats
        {
            get { return techStats; }
            set { techStats = value; this.RaisePropertyChanged(nameof(TechStats)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats = "进球";

        public string SelectTechStats
        {
            get { return selectTechStats; }
            set
            {
                selectTechStats = value;
                this.RaisePropertyChanged(nameof(SelectTechStats));

                NewSetHData(1);
                NewSetAData(1);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible;


        public Visibility TechStatsVisible
        {
            get { return techStatsVisible; }
            set { techStatsVisible = value; this.RaisePropertyChanged(nameof(TechStatsVisible)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore;

        public string AwayScore
        {
            get { return awayScore; }
            set { awayScore = value; this.RaisePropertyChanged(nameof(AwayScore)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible;

        public Visibility AScoreVisible
        {
            get { return aScoreVisible; }

            set { aScoreVisible = value; this.RaisePropertyChanged(nameof(AScoreVisible)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore;

        public string ASeasonScore
        {
            get { return aSeasonScore; }

            set { aSeasonScore = value; this.RaisePropertyChanged(nameof(ASeasonScore)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible;

        public Visibility ASeasonScoreVisible
        {
            get { return aSeasonScoreVisible; }
            set { aSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible)); }
        }

        #endregion


        #region 第二项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight1;

        public bool IsHeight1
        {
            get { return isHeight1; }
            set { isHeight1 = value; this.RaisePropertyChanged(nameof(IsHeight1)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible1;
        public Visibility IsCheckVisible1
        {
            get { return isCheckVisible1; }
            set { isCheckVisible1 = value; this.RaisePropertyChanged(nameof(IsCheckVisible1)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore1;

        public string HomeScore1
        {
            get { return homeScore1; }
            set { homeScore1 = value; this.RaisePropertyChanged(nameof(HomeScore1)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible1;

        public Visibility HScoreVisible1
        {
            get { return hScoreVisible1; }
            set { hScoreVisible1 = value; this.RaisePropertyChanged(nameof(hScoreVisible1)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore1;

        public string HSeasonScore1
        {
            get { return hSeasonScore1; }
            set { hSeasonScore1 = value; this.RaisePropertyChanged(nameof(HSeasonScore1)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible1;
        public Visibility HSeasonScoreVisible1
        {
            get { return hSeasonScoreVisible1; }
            set { hSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible1)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats1 = listTechStats;

        public ObservableCollection<string> TechStats1
        {
            get { return techStats1; }
            set { techStats1 = value; this.RaisePropertyChanged(nameof(TechStats1)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats1 = "助攻"; //射门

        public string SelectTechStats1
        {
            get { return selectTechStats1; }
            set
            {
                selectTechStats1 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats1));

                NewSetHData(2);
                NewSetAData(2);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible1;


        public Visibility TechStatsVisible1
        {
            get { return techStatsVisible1; }
            set { techStatsVisible1 = value; this.RaisePropertyChanged(nameof(TechStatsVisible1)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore1;

        public string AwayScore1
        {
            get { return awayScore1; }
            set { awayScore1 = value; this.RaisePropertyChanged(nameof(AwayScore1)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible1;

        public Visibility AScoreVisible1
        {
            get { return aScoreVisible1; }

            set { aScoreVisible1 = value; this.RaisePropertyChanged(nameof(AScoreVisible1)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore1;

        public string ASeasonScore1
        {
            get { return aSeasonScore1; }

            set { aSeasonScore1 = value; this.RaisePropertyChanged(nameof(ASeasonScore1)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible1;

        public Visibility ASeasonScoreVisible1
        {
            get { return aSeasonScoreVisible1; }
            set { aSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible1)); }
        }

        #endregion


        #region 第三项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight2;

        public bool IsHeight2
        {
            get { return isHeight2; }
            set { isHeight2 = value; this.RaisePropertyChanged(nameof(IsHeight2)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible2;
        public Visibility IsCheckVisible2
        {
            get { return isCheckVisible2; }
            set { isCheckVisible2 = value; this.RaisePropertyChanged(nameof(IsCheckVisible2)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore2;

        public string HomeScore2
        {
            get { return homeScore2; }
            set { homeScore2 = value; this.RaisePropertyChanged(nameof(HomeScore2)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible2;

        public Visibility HScoreVisible2
        {
            get { return hScoreVisible2; }
            set { hScoreVisible2 = value; this.RaisePropertyChanged(nameof(hScoreVisible2)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore2;

        public string HSeasonScore2
        {
            get { return hSeasonScore2; }
            set { hSeasonScore2 = value; this.RaisePropertyChanged(nameof(HSeasonScore2)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible2;
        public Visibility HSeasonScoreVisible2
        {
            get { return hSeasonScoreVisible2; }
            set { hSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible2)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats2 = listTechStats;

        public ObservableCollection<string> TechStats2
        {
            get { return techStats2; }
            set { techStats2 = value; this.RaisePropertyChanged(nameof(TechStats2)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats2 = "射门"; //射门

        public string SelectTechStats2
        {
            get { return selectTechStats2; }
            set
            {
                selectTechStats2 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats2));

                NewSetHData(3);
                NewSetAData(3);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible2;


        public Visibility TechStatsVisible2
        {
            get { return techStatsVisible2; }
            set { techStatsVisible2 = value; this.RaisePropertyChanged(nameof(TechStatsVisible2)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore2;

        public string AwayScore2
        {
            get { return awayScore2; }
            set { awayScore2 = value; this.RaisePropertyChanged(nameof(AwayScore2)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible2;

        public Visibility AScoreVisible2
        {
            get { return aScoreVisible2; }

            set { aScoreVisible2 = value; this.RaisePropertyChanged(nameof(AScoreVisible2)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore2;

        public string ASeasonScore2
        {
            get { return aSeasonScore2; }

            set { aSeasonScore2 = value; this.RaisePropertyChanged(nameof(ASeasonScore2)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible2;

        public Visibility ASeasonScoreVisible2
        {
            get { return aSeasonScoreVisible2; }
            set { aSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible2)); }
        }

        #endregion


        #region 第四项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight3;

        public bool IsHeight3
        {
            get { return isHeight3; }
            set { isHeight3 = value; this.RaisePropertyChanged(nameof(IsHeight3)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible3;
        public Visibility IsCheckVisible3
        {
            get { return isCheckVisible3; }
            set { isCheckVisible3 = value; this.RaisePropertyChanged(nameof(IsCheckVisible3)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore3;

        public string HomeScore3
        {
            get { return homeScore3; }
            set { homeScore3 = value; this.RaisePropertyChanged(nameof(HomeScore3)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible3;

        public Visibility HScoreVisible3
        {
            get { return hScoreVisible3; }
            set { hScoreVisible3 = value; this.RaisePropertyChanged(nameof(hScoreVisible3)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore3;

        public string HSeasonScore3
        {
            get { return hSeasonScore3; }
            set { hSeasonScore3 = value; this.RaisePropertyChanged(nameof(HSeasonScore3)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible3;
        public Visibility HSeasonScoreVisible3
        {
            get { return hSeasonScoreVisible3; }
            set { hSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible3)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats3 = listTechStats;

        public ObservableCollection<string> TechStats3
        {
            get { return techStats3; }
            set { techStats3 = value; this.RaisePropertyChanged(nameof(TechStats3)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats3 = "传球成功";

        public string SelectTechStats3
        {
            get { return selectTechStats3; }
            set
            {
                selectTechStats3 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats3));

                NewSetHData(4);
                NewSetAData(4);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible3;


        public Visibility TechStatsVisible3
        {
            get { return techStatsVisible3; }
            set { techStatsVisible3 = value; this.RaisePropertyChanged(nameof(TechStatsVisible3)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore3;

        public string AwayScore3
        {
            get { return awayScore3; }
            set { awayScore3 = value; this.RaisePropertyChanged(nameof(AwayScore3)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible3;

        public Visibility AScoreVisible3
        {
            get { return aScoreVisible3; }

            set { aScoreVisible3 = value; this.RaisePropertyChanged(nameof(AScoreVisible3)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore3;

        public string ASeasonScore3
        {
            get { return aSeasonScore3; }

            set { aSeasonScore3 = value; this.RaisePropertyChanged(nameof(ASeasonScore3)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible3;

        public Visibility ASeasonScoreVisible3
        {
            get { return aSeasonScoreVisible3; }
            set { aSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible3)); }
        }

        #endregion


        #region 第五项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight4;

        public bool IsHeight4
        {
            get { return isHeight4; }
            set { isHeight4 = value; this.RaisePropertyChanged(nameof(IsHeight4)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible4;
        public Visibility IsCheckVisible4
        {
            get { return isCheckVisible4; }
            set { isCheckVisible4 = value; this.RaisePropertyChanged(nameof(IsCheckVisible4)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore4;

        public string HomeScore4
        {
            get { return homeScore4; }
            set { homeScore4 = value; this.RaisePropertyChanged(nameof(HomeScore4)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible4;

        public Visibility HScoreVisible4
        {
            get { return hScoreVisible4; }
            set { hScoreVisible4 = value; this.RaisePropertyChanged(nameof(hScoreVisible4)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore4;

        public string HSeasonScore4
        {
            get { return hSeasonScore4; }
            set { hSeasonScore4 = value; this.RaisePropertyChanged(nameof(HSeasonScore4)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible4;
        public Visibility HSeasonScoreVisible4
        {
            get { return hSeasonScoreVisible4; }
            set { hSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible4)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats4 = listTechStats;

        public ObservableCollection<string> TechStats4
        {
            get { return techStats4; }
            set { techStats4 = value; this.RaisePropertyChanged(nameof(TechStats4)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats4 = "传球正确率";

        public string SelectTechStats4
        {
            get { return selectTechStats4; }
            set
            {
                selectTechStats4 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats4));

                NewSetHData(5);
                NewSetAData(5);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible4;


        public Visibility TechStatsVisible4
        {
            get { return techStatsVisible4; }
            set { techStatsVisible4 = value; this.RaisePropertyChanged(nameof(TechStatsVisible4)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore4;

        public string AwayScore4
        {
            get { return awayScore4; }
            set { awayScore4 = value; this.RaisePropertyChanged(nameof(AwayScore4)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible4;

        public Visibility AScoreVisible4
        {
            get { return aScoreVisible4; }

            set { aScoreVisible4 = value; this.RaisePropertyChanged(nameof(AScoreVisible4)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore4;

        public string ASeasonScore4
        {
            get { return aSeasonScore4; }

            set { aSeasonScore4 = value; this.RaisePropertyChanged(nameof(ASeasonScore4)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible4;

        public Visibility ASeasonScoreVisible4
        {
            get { return aSeasonScoreVisible4; }
            set { aSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible4)); }
        }

        #endregion


        #region 第六项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight5;

        public bool IsHeight5
        {
            get { return isHeight5; }
            set { isHeight5 = value; this.RaisePropertyChanged(nameof(IsHeight5)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible5;
        public Visibility IsCheckVisible5
        {
            get { return isCheckVisible5; }
            set { isCheckVisible5 = value; this.RaisePropertyChanged(nameof(IsCheckVisible5)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore5;

        public string HomeScore5
        {
            get { return homeScore5; }
            set { homeScore5 = value; this.RaisePropertyChanged(nameof(HomeScore5)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible5;

        public Visibility HScoreVisible5
        {
            get { return hScoreVisible5; }
            set { hScoreVisible5 = value; this.RaisePropertyChanged(nameof(hScoreVisible5)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore5;

        public string HSeasonScore5
        {
            get { return hSeasonScore5; }
            set { hSeasonScore5 = value; this.RaisePropertyChanged(nameof(HSeasonScore5)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible5;
        public Visibility HSeasonScoreVisible5
        {
            get { return hSeasonScoreVisible5; }
            set { hSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible5)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats5 = listTechStats;

        public ObservableCollection<string> TechStats5
        {
            get { return techStats5; }
            set { techStats5 = value; this.RaisePropertyChanged(nameof(TechStats5)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats5 = "关键传球";

        public string SelectTechStats5
        {
            get { return selectTechStats5; }
            set
            {
                selectTechStats5 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats5));

                NewSetHData(6);
                NewSetAData(6);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible5;


        public Visibility TechStatsVisible5
        {
            get { return techStatsVisible5; }
            set { techStatsVisible5 = value; this.RaisePropertyChanged(nameof(TechStatsVisible5)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore5;

        public string AwayScore5
        {
            get { return awayScore5; }
            set { awayScore5 = value; this.RaisePropertyChanged(nameof(AwayScore5)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible5;

        public Visibility AScoreVisible5
        {
            get { return aScoreVisible5; }

            set { aScoreVisible5 = value; this.RaisePropertyChanged(nameof(AScoreVisible5)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore5;

        public string ASeasonScore5
        {
            get { return aSeasonScore5; }

            set { aSeasonScore5 = value; this.RaisePropertyChanged(nameof(ASeasonScore5)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible5;

        public Visibility ASeasonScoreVisible5
        {
            get { return aSeasonScoreVisible5; }
            set { aSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible5)); }
        }

        #endregion



    }
}
