﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// FDayMatchView.xaml 的交互逻辑
    /// </summary>
    public partial class FDayMatchView : UserControl, IPluginView
    {

        public FDayMatchViewModel vm = new FDayMatchViewModel();

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FDayMatchView));

        public FDayMatchView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, vm);

            FDayMatchViewModel.FDayMatchViewModelInstance = vm;

        }


        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        /// <summary>
        /// 上版
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakIn(ConnModel conns)
        {
            //DayMatchViewModel vm = thi DayMatchViewModel
            //ApplicationDomainEx.PreviewConn.EndpointManager.Send("");

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);
            if (conns.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }


        }

        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeContinue(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_CONTINUE);
            if (conns.IsConnected && vm.MatchData != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        /// <summary>
        /// 下版子
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeOut(ConnModel conns)
        {

        }

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeUpdate(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);
            if (conns.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        /// <summary>
        /// 预览上版子
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);
            if (conn.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        /// <summary>
        /// 预览继续
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewContinue(ConnModel conn)
        {

        }

        /// <summary>
        /// 预览下版
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }

        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;
        /// <summary>
        /// 注册服务
        /// </summary>
        IPackageTaskService service;





        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);
            if (conn.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }



    }
}
