﻿using DevExpress.Xpf.Grid.GroupRowLayout;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Xml;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    public class FFormationViewModel : ViewModelBase
    {


        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FDayMatchViewModel));

        /// <summary>
        /// 对象实例开发
        /// </summary>
        public static FFormationViewModel FFormationViewModelInstance = new FFormationViewModel();

        public FFormationViewModel()
        {
            CleanData();

            BtnCommand = new VCommand(BtnCmd);

            PromptCommand = new VCommand(this.PromptCmd);


            homeTeamId = DateHeaderViewModel.HomeTeamId;
            visitTeamId = DateHeaderViewModel.VisitTeamId;
            homeNationTeam = DateHeaderViewModel.HomeNationName;
            awayNationTeam = DateHeaderViewModel.VisitingNationName;

            matchId = DateHeaderViewModel.MatchId;

            TeamItems = new ObservableCollection<string>();

            if (!string.IsNullOrEmpty(DateHeaderViewModel.HomeTeamName) && !string.IsNullOrEmpty(DateHeaderViewModel.VisitingTeamName))
            {
                TeamItems.Add(DateHeaderViewModel.HomeTeamName);
                TeamItems.Add(DateHeaderViewModel.VisitingTeamName);
                SelectedIndex = 0;
            }
            SetTeamData();
        }


        /// <summary>
        /// 阵型的选择
        /// </summary>

        private ObservableCollection<string> forMationItems= new ObservableCollection<string>() { "4-4-2", "4-2-3-1", "3-5-2" };

        public ObservableCollection<string> ForMationItems
        {
            get { return forMationItems; }
            set
            {
                forMationItems = value; this.RaisePropertyChanged(nameof(forMationItems));
            }
        }



        private string teamName;

        public string TeamName
        {
            get { return teamName; }
            set { teamName = value; this.RaisePropertyChanged(nameof(TeamName)); }
        }


        /// <summary>
        /// 选中的阵型
        /// </summary>
        private string selectForMationItem= "4-4-2";

        public string SelectForMationItem
        {
            get { return selectForMationItem; }
            set { selectForMationItem = value;this.RaisePropertyChanged(nameof(SelectForMationItem)); }
        }



        /// <summary>
        /// 队伍信息绑定
        /// </summary>
        private ObservableCollection<string> teamItems;

        public ObservableCollection<string> TeamItems
        {
            get { return teamItems; }
            set { teamItems = value; this.RaisePropertyChanged(nameof(TeamItems)); }
        }


        private string selectTeamItem;

        public string SelectTeamItem
        {
            get { return selectTeamItem; }
            set
            {
                selectTeamItem = value;

                TeamName = selectTeamItem;
                this.RaisePropertyChanged(nameof(SelectTeamItem));

            }
        }



        public string homeTeamId { get; set; }
        public string visitTeamId { get; set; }

        public string TeamId { get; set; }

        public string homeNationTeam;

        public string awayNationTeam;

        public string matchId { get; set; }

        public PageModel page = null;

        public VCommand BtnCommand { get; set; }

        public VCommand PromptCommand { get; set; }


        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();

        public SingleTeamPlayers Players = new SingleTeamPlayers();

        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯首发：" + PluginConstant.Operate_Message);
            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
    
            if (Players != null)
            {
                string teamSeasonLastDate = $"主队女足首发接口更新时间:{Players.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }


            if (Players != null)
            {
                string teamSeasonLastDate = $"客队女足首发接口更新时间:{Players.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }

            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

        }


        public void BtnCmd()
        {

           this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足首发：" + PluginConstant.Operate_Message);
           SetTeamData();

        }

        public async void SetTeamData()
        {
            CleanData();
            Players = await JsonModel.PostTeamPlayerData_Path(TeamId, matchId, "1");

            if (Players == null|| Players.matchTeamPlayers==null) return;

            foreach(var player in Players.matchTeamPlayers)
            {
                if (this.GetType().GetProperty(string.Format("{0}Name", player.position)) != null)
                {
                    this.GetType().GetProperty(string.Format("{0}Name", player.position)).SetValue(this, player.figureName);
                }
                if(this.GetType().GetProperty(string.Format("{0}Logo", player.position))!=null)
                {
                    this.GetType().GetProperty(string.Format("{0}Logo", player.position)).SetValue(this, player.figureName);
                }

                if (this.GetType().GetProperty(string.Format("{0}Num", player.position)) != null)
                {
                    this.GetType().GetProperty(string.Format("{0}Num", player.position)).SetValue(this, player.playerNum);
                }
            }

        }


        /// <summary>
        /// 阵型标志
        /// </summary>
        private string formation;

        public string Formation
        {
            get { return formation; }
            set { formation = value; this.RaisePropertyChanged(nameof(Formation)); }
        }



        public string nationTeam = "";


        /// <summary>
        /// 球队选中的数据
        /// </summary>
        private int selectedIndex;

        /// <summary>
        /// 0 是主队 1 是客队
        /// </summary>

        public int SelectedIndex
        {
            get { return selectedIndex; }
            set
            {
                selectedIndex = value;

                this.RaisePropertyChanged(nameof(SelectedIndex));

                if (selectedIndex == 0)
                {
                    nationTeam = homeNationTeam;
                    TeamId = homeTeamId;
                }
                else if (selectedIndex == 1)
                {
                    nationTeam = awayNationTeam;
                    TeamId = visitTeamId;
                }
            }
        }



        #region 第一行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string k1Name= "k1Name";

        public string K1Name
        {
            get { return k1Name; }
            set { k1Name = value;this.RaisePropertyChanged(nameof(K1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string k1Logo= "k1Logo";

        public string K1Logo
        {
            get { return k1Logo; }
            set { k1Logo = value; this.RaisePropertyChanged(nameof(K1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string k1Num= "k1Num";

        public string K1Num
        {
            get { return k1Num; }
            set { k1Num = value;this.RaisePropertyChanged(nameof(K1Num)); }
        }




        private string k2Name= "k2Name";

        public string K2Name
        {
            get { return k2Name; }
            set { k2Name = value; this.RaisePropertyChanged(nameof(K2Name)); }
        }


        private string k2Logo= "k2Logo";

        public string K2Logo
        {
            get { return k2Logo; }
            set { k2Logo = value; this.RaisePropertyChanged(nameof(K2Logo)); }
        }


        private string k2Num= "k2Num";

        public string K2Num
        {
            get { return k2Num; }
            set { k2Num = value; this.RaisePropertyChanged(nameof(K2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string k3Name= "k3Name";

        public string K3Name
        {
            get { return k3Name; }
            set { k3Name = value; this.RaisePropertyChanged(nameof(K3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string k3Logo= "k3Logo";

        public string K3Logo
        {
            get { return k3Logo; }
            set { k3Logo = value; this.RaisePropertyChanged(nameof(K3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string k3Num= "k3Num";

        public string K3Num
        {
            get { return k3Num; }
            set { k3Num = value; this.RaisePropertyChanged(nameof(K3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string k4Name= "k4Name";

        public string K4Name
        {
            get { return k4Name; }
            set { k4Name = value; this.RaisePropertyChanged(nameof(K4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string k4Logo= "k4Logo";

        public string K4Logo
        {
            get { return k4Logo; }
            set { k4Logo = value; this.RaisePropertyChanged(nameof(K4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string k4Num= "k4Num";

        public string K4Num
        {
            get { return k4Num; }
            set { k4Num = value; this.RaisePropertyChanged(nameof(K4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string k5Name= "k5Name";

        public string K5Name
        {
            get { return k5Name; }
            set { k5Name = value; this.RaisePropertyChanged(nameof(K5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string k5Logo= "k5Logo";

        public string K5Logo
        {
            get { return k5Logo; }
            set { k5Logo = value; this.RaisePropertyChanged(nameof(K5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string k5Num= "k5Num";

        public string K5Num
        {
            get { return k5Num; }
            set { k5Num = value; this.RaisePropertyChanged(nameof(K5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string k6Name= "k6Name";

        public string K6Name
        {
            get { return k6Name; }
            set { k6Name = value; this.RaisePropertyChanged(nameof(K6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string k6Logo= "k6Logo";

        public string K6Logo
        {
            get { return k6Logo; }
            set { k6Logo = value; this.RaisePropertyChanged(nameof(K6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string k6Num= "k6Num";

        public string K6Num
        {
            get { return k6Num; }
            set { k6Num = value; this.RaisePropertyChanged(nameof(K6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string k7Name= "k7Name";

        public string K7Name
        {
            get { return k7Name; }
            set { k7Name = value; this.RaisePropertyChanged(nameof(K7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string k7Logo= "k7Logo";

        public string K7Logo
        {
            get { return k7Logo; }
            set { k7Logo = value; this.RaisePropertyChanged(nameof(K7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string k7Num= "k7Num";

        public string K7Num
        {
            get { return k7Num; }
            set { k7Num = value; this.RaisePropertyChanged(nameof(K7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string k8Name= "k8Name";

        public string K8Name
        {
            get { return k8Name; }
            set { k8Name = value; this.RaisePropertyChanged(nameof(K8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string k8Logo= "k8Logo";

        public string K8Logo
        {
            get { return k8Logo; }
            set { k8Logo = value; this.RaisePropertyChanged(nameof(K8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string k8Num= "k8Num";

        public string K8Num
        {
            get { return k8Num; }
            set { k8Num = value; this.RaisePropertyChanged(nameof(K8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string k9Name= "k9Name";

        public string K9Name
        {
            get { return k9Name; }
            set { k9Name = value; this.RaisePropertyChanged(nameof(K9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string k9Logo= "k9Logo";

        public string K9Logo
        {
            get { return k9Logo; }
            set { k9Logo = value; this.RaisePropertyChanged(nameof(K9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string k9Num= "k9Num";

        public string K9Num
        {
            get { return k9Num; }
            set { k9Num = value; this.RaisePropertyChanged(nameof(K9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string k10Name= "k10Name";

        public string K10Name
        {
            get { return k10Name; }
            set { k10Name = value; this.RaisePropertyChanged(nameof(K9Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string k10Logo= "k10Logo";
        
        public string K10Logo
        {
            get { return k10Logo; }
            set { k10Logo = value; this.RaisePropertyChanged(nameof(K10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string k10Num= "k10Num";

        public string K10Num
        {
            get { return k10Num; }
            set { k10Num = value; this.RaisePropertyChanged(nameof(K10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string k11Name= "K11Name";

        public string K11Name
        {
            get { return k11Name; }
            set { k11Name = value; this.RaisePropertyChanged(nameof(K9Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string k11Logo= "k11Logo";

        public string K11Logo
        {
            get { return k11Logo; }
            set { k11Logo = value; this.RaisePropertyChanged(nameof(K11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string k11Num= "k11Num";

        public string K11Num
        {
            get { return k11Num; }
            set { k11Num = value; this.RaisePropertyChanged(nameof(K11Num)); }
        }



        #endregion

        #region 第二行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string j1Name= "j1Name";

        public string J1Name
        {
            get { return j1Name; }
            set { j1Name = value; this.RaisePropertyChanged(nameof(J1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string j1Logo= "j1Logo";

        public string J1Logo
        {
            get { return j1Logo; }
            set { j1Logo = value; this.RaisePropertyChanged(nameof(J1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string j1Num= "j1Num";

        public string J1Num
        {
            get { return j1Num; }
            set { j1Num = value; this.RaisePropertyChanged(nameof(J1Num)); }
        }




        private string j2Name= "j2Name";

        public string J2Name
        {
            get { return j2Name; }
            set { j2Name = value; this.RaisePropertyChanged(nameof(J2Name)); }
        }


        private string j2Logo= "j2Logo";

        public string J2Logo
        {
            get { return j2Logo; }
            set { j2Logo = value; this.RaisePropertyChanged(nameof(J2Logo)); }
        }


        private string j2Num= "j2Num";

        public string J2Num
        {
            get { return j2Num; }
            set { j2Num = value; this.RaisePropertyChanged(nameof(J2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string j3Name= "j3Name";

        public string J3Name
        {
            get { return j3Name; }
            set { j3Name = value; this.RaisePropertyChanged(nameof(J3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string j3Logo= "j3Logo";

        public string J3Logo
        {
            get { return j3Logo; }
            set { j3Logo = value; this.RaisePropertyChanged(nameof(J3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string j3Num= "j3Num";

        public string J3Num
        {
            get { return j3Num; }
            set { j3Num = value; this.RaisePropertyChanged(nameof(J3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string j4Name= "j4Name";

        public string J4Name
        {
            get { return j4Name; }
            set { j4Name = value; this.RaisePropertyChanged(nameof(J4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string j4Logo= "j4Logo";

        public string J4Logo
        {
            get { return j4Logo; }
            set { j4Logo = value; this.RaisePropertyChanged(nameof(J4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string j4Num= "j4Num";

        public string J4Num
        {
            get { return j4Num; }
            set { j4Num = value; this.RaisePropertyChanged(nameof(J4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string j5Name= "j5Name";

        public string J5Name
        {
            get { return j5Name; }
            set { j5Name = value; this.RaisePropertyChanged(nameof(J5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string j5Logo= "j5Logo";

        public string J5Logo
        {
            get { return j5Logo; }
            set { j5Logo = value; this.RaisePropertyChanged(nameof(J5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string j5Num= "j5Num";

        public string J5Num
        {
            get { return j5Num; }
            set { j5Num = value; this.RaisePropertyChanged(nameof(J5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string j6Name= "j6Name";

        public string J6Name
        {
            get { return j6Name; }
            set { j6Name = value; this.RaisePropertyChanged(nameof(J6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string j6Logo= "j6Logo";

        public string J6Logo
        {
            get { return j6Logo; }
            set { j6Logo = value; this.RaisePropertyChanged(nameof(J6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string j6Num= "j6Num";

        public string J6Num
        {
            get { return j6Num; }
            set { j6Num = value; this.RaisePropertyChanged(nameof(J6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string j7Name= "j7Name";

        public string J7Name
        {
            get { return j7Name; }
            set { j7Name = value; this.RaisePropertyChanged(nameof(K7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string j7Logo= "j7Logo";

        public string J7Logo
        {
            get { return j7Logo; }
            set { j7Logo = value; this.RaisePropertyChanged(nameof(J7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string j7Num= "j7Num";

        public string J7Num
        {
            get { return j7Num; }
            set { j7Num = value; this.RaisePropertyChanged(nameof(J7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string j8Name= "j8Name";

        public string J8Name
        {
            get { return j8Name; }
            set { j8Name = value; this.RaisePropertyChanged(nameof(J8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string j8Logo= "j8Logo";

        public string J8Logo
        {
            get { return j8Logo; }
            set { j8Logo = value; this.RaisePropertyChanged(nameof(J8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string j8Num= "j8Num";

        public string J8Num
        {
            get { return j8Num; }
            set { j8Num = value; this.RaisePropertyChanged(nameof(J8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string j9Name= "j9Name";

        public string J9Name
        {
            get { return j9Name; }
            set { j9Name = value; this.RaisePropertyChanged(nameof(J9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string j9Logo= "j9Logo";

        public string J9Logo
        {
            get { return j9Logo; }
            set { j9Logo = value; this.RaisePropertyChanged(nameof(J9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string j9Num= "j9Num";

        public string J9Num
        {
            get { return j9Num; }
            set { j9Num = value; this.RaisePropertyChanged(nameof(J9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string j10Name= "j10Name";

        public string J10Name
        {
            get { return j10Name; }
            set { j10Name = value; this.RaisePropertyChanged(nameof(J10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string j10Logo= "j10Logo";

        public string J10Logo
        {
            get { return j10Logo; }
            set { j10Logo = value; this.RaisePropertyChanged(nameof(J10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string j10Num= "j10Num";

        public string J10Num
        {
            get { return j10Num; }
            set { j10Num = value; this.RaisePropertyChanged(nameof(J10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string j11Name= "j11Name";

        public string J11Name
        {
            get { return j11Name; }
            set { j11Name = value; this.RaisePropertyChanged(nameof(J11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string j11Logo= "j11Logo";

        public string J11Logo
        {
            get { return j11Logo; }
            set { j11Logo = value; this.RaisePropertyChanged(nameof(J11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string j11Num= "j11Num";

        public string J11Num
        {
            get { return j11Num; }
            set { j11Num = value; this.RaisePropertyChanged(nameof(J11Num)); }
        }



        #endregion

        #region 第三行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string i1Name= "i1Name";

        public string I1Name
        {
            get { return i1Name; }
            set { i1Name = value; this.RaisePropertyChanged(nameof(I1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string i1Logo= "i1Logo";

        public string I1Logo
        {
            get { return i1Logo; }
            set { i1Logo = value; this.RaisePropertyChanged(nameof(I1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string i1Num= "i1Num";

        public string I1Num
        {
            get { return i1Num; }
            set { i1Num = value; this.RaisePropertyChanged(nameof(I1Num)); }
        }




        private string i2Name= "i2Name";

        public string I2Name
        {
            get { return i2Name; }
            set { i2Name = value; this.RaisePropertyChanged(nameof(I2Name)); }
        }


        private string i2Logo= "i2Logo";

        public string I2Logo
        {
            get { return i2Logo; }
            set { i2Logo = value; this.RaisePropertyChanged(nameof(I2Logo)); }
        }


        private string i2Num= "i2Num";

        public string I2Num
        {
            get { return i2Num; }
            set { i2Num = value; this.RaisePropertyChanged(nameof(I2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string i3Name= "i3Name";

        public string I3Name
        {
            get { return i3Name; }
            set { i3Name = value; this.RaisePropertyChanged(nameof(I3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string i3Logo= "i3Logo";

        public string I3Logo
        {
            get { return i3Logo; }
            set { i3Logo = value; this.RaisePropertyChanged(nameof(I3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string i3Num= "i3Num";

        public string I3Num
        {
            get { return i3Num; }
            set { i3Num = value; this.RaisePropertyChanged(nameof(I3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string i4Name= "i4Name";

        public string I4Name
        {
            get { return i4Name; }
            set { i4Name = value; this.RaisePropertyChanged(nameof(I4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string i4Logo= "i4Logo";

        public string I4Logo
        {
            get { return i4Logo; }
            set { i4Logo = value; this.RaisePropertyChanged(nameof(I4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string i4Num= "i4Num";

        public string I4Num
        {
            get { return i4Num; }
            set { i4Num = value; this.RaisePropertyChanged(nameof(I4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string i5Name= "i5Name";

        public string I5Name
        {
            get { return i5Name; }
            set { i5Name = value; this.RaisePropertyChanged(nameof(I5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string i5Logo= "i5Logo";

        public string I5Logo
        {
            get { return i5Logo; }
            set { i5Logo = value; this.RaisePropertyChanged(nameof(I5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string i5Num= "i5Num";

        public string I5Num
        {
            get { return i5Num; }
            set { i5Num = value; this.RaisePropertyChanged(nameof(I5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string i6Name= "i6Name";

        public string I6Name
        {
            get { return i6Name; }
            set { i6Name = value; this.RaisePropertyChanged(nameof(I6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string i6Logo= "i6Logo";

        public string I6Logo
        {
            get { return i6Logo; }
            set { i6Logo = value; this.RaisePropertyChanged(nameof(I6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string i6Num= "i6Num";

        public string I6Num
        {
            get { return i6Num; }
            set { i6Num = value; this.RaisePropertyChanged(nameof(I6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string i7Name= "i7Name";

        public string I7Name
        {
            get { return i7Name; }
            set { i7Name = value; this.RaisePropertyChanged(nameof(I7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string i7Logo= "i7Logo";

        public string I7Logo
        {
            get { return i7Logo; }
            set { i7Logo = value; this.RaisePropertyChanged(nameof(I7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string i7Num= "i7Num";

        public string I7Num
        {
            get { return i7Num; }
            set { i7Num = value; this.RaisePropertyChanged(nameof(I7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string i8Name= "i8Name";

        public string I8Name
        {
            get { return i8Name; }
            set { i8Name = value; this.RaisePropertyChanged(nameof(I8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string i8Logo= "i8Logo";

        public string I8Logo
        {
            get { return i8Logo; }
            set { i8Logo = value; this.RaisePropertyChanged(nameof(I8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string i8Num= "i8Num";

        public string I8Num
        {
            get { return i8Num; }
            set { i8Num = value; this.RaisePropertyChanged(nameof(I8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string i9Name= "i9Name";

        public string I9Name
        {
            get { return i9Name; }
            set { i9Name = value; this.RaisePropertyChanged(nameof(I9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string i9Logo= "i9Logo";

        public string I9Logo
        {
            get { return i9Logo; }
            set { i9Logo = value; this.RaisePropertyChanged(nameof(I9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string i9Num= "i9Num";

        public string I9Num
        {
            get { return i9Num; }
            set { i9Num = value; this.RaisePropertyChanged(nameof(I9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string i10Name= "i10Name";

        public string I10Name
        {
            get { return i10Name; }
            set { i10Name = value; this.RaisePropertyChanged(nameof(I10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string i10Logo= "i10Logo";

        public string I10Logo
        {
            get { return i10Logo; }
            set { i10Logo = value; this.RaisePropertyChanged(nameof(I10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string i10Num= "i10Num";

        public string I10Num
        {
            get { return i10Num; }
            set { i10Num = value; this.RaisePropertyChanged(nameof(I10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string i11Name= "i11Name";

        public string I11Name
        {
            get { return i11Name; }
            set { i11Name = value; this.RaisePropertyChanged(nameof(I11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string i11Logo= "i11Logo";

        public string I11Logo
        {
            get { return i11Logo; }
            set { i11Logo = value; this.RaisePropertyChanged(nameof(I11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string i11Num= "i11Num";

        public string I11Num
        {
            get { return i11Num; }
            set { i11Num = value; this.RaisePropertyChanged(nameof(I11Num)); }
        }



        #endregion

        #region 第四行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string h1Name= "h1Name";

        public string H1Name
        {
            get { return h1Name; }
            set { h1Name = value; this.RaisePropertyChanged(nameof(H1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string h1Logo= "h1Logo";

        public string H1Logo
        {
            get { return h1Logo; }
            set { h1Logo = value; this.RaisePropertyChanged(nameof(H1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string h1Num= "h1Num";

        public string H1Num
        {
            get { return h1Num; }
            set { h1Num = value; this.RaisePropertyChanged(nameof(H1Num)); }
        }




        private string h2Name= "h2Name";

        public string H2Name
        {
            get { return h2Name; }
            set { h2Name = value; this.RaisePropertyChanged(nameof(H2Name)); }
        }


        private string h2Logo= "h2Logo";

        public string H2Logo
        {
            get { return h2Logo; }
            set { h2Logo = value; this.RaisePropertyChanged(nameof(H2Logo)); }
        }


        private string h2Num= "h2Num";

        public string H2Num
        {
            get { return h2Num; }
            set { h2Num = value; this.RaisePropertyChanged(nameof(H2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string h3Name= "h3Name";

        public string H3Name
        {
            get { return h3Name; }
            set { h3Name = value; this.RaisePropertyChanged(nameof(H3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string h3Logo= "h3Logo";

        public string H3Logo
        {
            get { return h3Logo; }
            set { h3Logo = value; this.RaisePropertyChanged(nameof(H3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string h3Num= "h3Num";

        public string H3Num
        {
            get { return h3Num; }
            set { h3Num = value; this.RaisePropertyChanged(nameof(H3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string h4Name= "h4Name";

        public string H4Name
        {
            get { return h4Name; }
            set { h4Name = value; this.RaisePropertyChanged(nameof(H4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string h4Logo= "h4Logo";

        public string H4Logo
        {
            get { return h4Logo; }
            set { h4Logo = value; this.RaisePropertyChanged(nameof(H4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string h4Num= "h4Num";

        public string H4Num
        {
            get { return h4Num; }
            set { h4Num = value; this.RaisePropertyChanged(nameof(H4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string h5Name= "h5Name";

        public string H5Name
        {
            get { return h5Name; }
            set { h5Name = value; this.RaisePropertyChanged(nameof(H5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string h5Logo= "h5Logo";

        public string H5Logo
        {
            get { return h5Logo; }
            set { h5Logo = value; this.RaisePropertyChanged(nameof(H5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string h5Num= "h5Num";

        public string H5Num
        {
            get { return h5Num; }
            set { h5Num = value; this.RaisePropertyChanged(nameof(H5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string h6Name= "h6Name";

        public string H6Name
        {
            get { return h6Name; }
            set { h6Name = value; this.RaisePropertyChanged(nameof(H6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string h6Logo= "h6Logo";

        public string H6Logo
        {
            get { return h6Logo; }
            set { h6Logo = value; this.RaisePropertyChanged(nameof(H6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string h6Num= "h6Num";

        public string H6Num
        {
            get { return h6Num; }
            set { h6Num = value; this.RaisePropertyChanged(nameof(H6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string h7Name= "h7Name";

        public string H7Name
        {
            get { return h7Name; }
            set { h7Name = value; this.RaisePropertyChanged(nameof(H7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string h7Logo= "h7Logo";

        public string H7Logo
        {
            get { return h7Logo; }
            set { h7Logo = value; this.RaisePropertyChanged(nameof(H7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string h7Num= "h7Num";

        public string H7Num
        {
            get { return h7Num; }
            set { h7Num = value; this.RaisePropertyChanged(nameof(H7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string h8Name= "h8Name";

        public string H8Name
        {
            get { return h8Name; }
            set { h8Name = value; this.RaisePropertyChanged(nameof(H8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string h8Logo= "h8Logo";
        
        public string H8Logo
        {
            get { return h8Logo; }
            set { h8Logo = value; this.RaisePropertyChanged(nameof(H8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string h8Num= "h8Num";

        public string H8Num
        {
            get { return h8Num; }
            set { h8Num = value; this.RaisePropertyChanged(nameof(H8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string h9Name= "h9Name";

        public string H9Name
        {
            get { return h9Name; }
            set { h9Name = value; this.RaisePropertyChanged(nameof(H9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string h9Logo= "h9Logo";

        public string H9Logo
        {
            get { return h9Logo; }
            set { h9Logo = value; this.RaisePropertyChanged(nameof(H9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string h9Num= "h9Num";

        public string H9Num
        {
            get { return h9Num; }
            set { h9Num = value; this.RaisePropertyChanged(nameof(H9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string h10Name= "h10Name";

        public string H10Name
        {
            get { return h10Name; }
            set { h10Name = value; this.RaisePropertyChanged(nameof(H10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string h10Logo= "h10Logo";

        public string H10Logo
        {
            get { return h10Logo; }
            set { h10Logo = value; this.RaisePropertyChanged(nameof(H10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string h10Num= "h10Num";

        public string H10Num
        {
            get { return h10Num; }
            set { h10Num = value; this.RaisePropertyChanged(nameof(H10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string h11Name= "h11Name";

        public string H11Name
        {
            get { return h11Name; }
            set { h11Name = value; this.RaisePropertyChanged(nameof(H11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string h11Logo= "h11Logo";

        public string H11Logo
        {
            get { return h11Logo; }
            set { h11Logo = value; this.RaisePropertyChanged(nameof(H11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string h11Num= "h11Num";

        public string H11Num
        {
            get { return h11Num; }
            set { h11Num = value; this.RaisePropertyChanged(nameof(H11Num)); }
        }



        #endregion

        #region 第五行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string g1Name= "g1Name";

        public string G1Name
        {
            get { return g1Name; }
            set { g1Name = value; this.RaisePropertyChanged(nameof(G1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string g1Logo= "g1Logo";

        public string G1Logo
        {
            get { return g1Logo; }
            set { g1Logo = value; this.RaisePropertyChanged(nameof(G1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string g1Num= "g1Num";

        public string G1Num
        {
            get { return g1Num; }
            set { g1Num = value; this.RaisePropertyChanged(nameof(G1Num)); }
        }




        private string g2Name= "g2Name";

        public string G2Name
        {
            get { return g2Name; }
            set { g2Name = value; this.RaisePropertyChanged(nameof(G2Name)); }
        }


        private string g2Logo= "g2Logo";

        public string G2Logo
        {
            get { return g2Logo; }
            set { g2Logo = value; this.RaisePropertyChanged(nameof(G2Logo)); }
        }


        private string g2Num= "g2Num";

        public string G2Num
        {
            get { return g2Num; }
            set { g2Num = value; this.RaisePropertyChanged(nameof(G2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string g3Name= "g3Name";

        public string G3Name
        {
            get { return g3Name; }
            set { g3Name = value; this.RaisePropertyChanged(nameof(G3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string g3Logo= "g3Logo";

        public string G3Logo
        {
            get { return g3Logo; }
            set { g3Logo = value; this.RaisePropertyChanged(nameof(G3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string g3Num= "g3Num";

        public string G3Num
        {
            get { return g3Num; }
            set { g3Num = value; this.RaisePropertyChanged(nameof(G3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string g4Name= "g4Name";

        public string G4Name
        {
            get { return g4Name; }
            set { g4Name = value; this.RaisePropertyChanged(nameof(G4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string g4Logo= "g4Logo";

        public string G4Logo
        {
            get { return g4Logo; }
            set { g4Logo = value; this.RaisePropertyChanged(nameof(G4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string g4Num= "g4Num";

        public string G4Num
        {
            get { return g4Num; }
            set { g4Num = value; this.RaisePropertyChanged(nameof(G4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string g5Name= "g5Name";

        public string G5Name
        {
            get { return g5Name; }
            set { g5Name = value; this.RaisePropertyChanged(nameof(G5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string g5Logo= "g5Logo";

        public string G5Logo
        {
            get { return g5Logo; }
            set { g5Logo = value; this.RaisePropertyChanged(nameof(G5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string g5Num= "g5Num";

        public string G5Num
        {
            get { return g5Num; }
            set { g5Num = value; this.RaisePropertyChanged(nameof(G5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string g6Name= "g6Name";

        public string G6Name
        {
            get { return g6Name; }
            set { g6Name = value; this.RaisePropertyChanged(nameof(G6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string g6Logo= "g6Logo";

        public string G6Logo
        {
            get { return g6Logo; }
            set { g6Logo = value; this.RaisePropertyChanged(nameof(G6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string g6Num= "g6Num";

        public string G6Num
        {
            get { return g6Num; }
            set { g6Num = value; this.RaisePropertyChanged(nameof(G6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string g7Name= "g7Name";

        public string G7Name
        {
            get { return g7Name; }
            set { g7Name = value; this.RaisePropertyChanged(nameof(G7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string g7Logo= "g7Logo";

        public string G7Logo
        {
            get { return g7Logo; }
            set { g7Logo = value; this.RaisePropertyChanged(nameof(G7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string g7Num= "g7Num";

        public string G7Num
        {
            get { return g7Num; }
            set { g7Num = value; this.RaisePropertyChanged(nameof(G7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string g8Name= "g8Name";

        public string G8Name
        {
            get { return g8Name; }
            set { g8Name = value; this.RaisePropertyChanged(nameof(G8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string g8Logo= "g8Logo";

        public string G8Logo
        {
            get { return g8Logo; }
            set { g8Logo = value; this.RaisePropertyChanged(nameof(G8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string g8Num= "g8Num";

        public string G8Num
        {
            get { return g8Num; }
            set { g8Num = value; this.RaisePropertyChanged(nameof(G8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string g9Name= "g9Name";

        public string G9Name
        {
            get { return g9Name; }
            set { g9Name = value; this.RaisePropertyChanged(nameof(G9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string g9Logo= "g9Logo";

        public string G9Logo
        {
            get { return g9Logo; }
            set { g9Logo = value; this.RaisePropertyChanged(nameof(G9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string g9Num= "g9Num";

        public string G9Num
        {
            get { return g9Num; }
            set { g9Num = value; this.RaisePropertyChanged(nameof(G9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string g10Name= "g10Name";

        public string G10Name
        {
            get { return g10Name; }
            set { g10Name = value; this.RaisePropertyChanged(nameof(G10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string g10Logo= "g10Logo";

        public string G10Logo
        {
            get { return g10Logo; }
            set { g10Logo = value; this.RaisePropertyChanged(nameof(G10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string g10Num= "g10Num";

        public string G10Num
        {
            get { return g10Num; }
            set { g10Num = value; this.RaisePropertyChanged(nameof(G10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string g11Name= "g11Name";

        public string G11Name
        {
            get { return g11Name; }
            set { g11Name = value; this.RaisePropertyChanged(nameof(G11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string g11Logo= "g11Logo";

        public string G11Logo
        {
            get { return g11Logo; }
            set { g11Logo = value; this.RaisePropertyChanged(nameof(G11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string g11Num= "g11Num";

        public string G11Num
        {
            get { return g11Num; }
            set { g11Num = value; this.RaisePropertyChanged(nameof(G11Num)); }
        }



        #endregion

        #region 第六行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string f1Name= "f1Name";

        public string F1Name
        {
            get { return f1Name; }
            set { f1Name = value; this.RaisePropertyChanged(nameof(F1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string f1Logo= "f1Logo";

        public string F1Logo
        {
            get { return f1Logo; }
            set { f1Logo = value; this.RaisePropertyChanged(nameof(F1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string f1Num= "f1Num";

        public string F1Num
        {
            get { return f1Num; }
            set { f1Num = value; this.RaisePropertyChanged(nameof(F1Num)); }
        }




        private string f2Name= "f2Name";

        public string F2Name
        {
            get { return f2Name; }
            set { f2Name = value; this.RaisePropertyChanged(nameof(F2Name)); }
        }


        private string f2Logo= "f2Logo";

        public string F2Logo
        {
            get { return f2Logo; }
            set { f2Logo = value; this.RaisePropertyChanged(nameof(F2Logo)); }
        }


        private string f2Num= "f2Num";

        public string F2Num
        {
            get { return f2Num; }
            set { f2Num = value; this.RaisePropertyChanged(nameof(F2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string f3Name= "f3Name";

        public string F3Name
        {
            get { return f3Name; }
            set { f3Name = value; this.RaisePropertyChanged(nameof(F3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string f3Logo= "f3Logo";

        public string F3Logo
        {
            get { return f3Logo; }
            set { f3Logo = value; this.RaisePropertyChanged(nameof(F3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string f3Num= "f3Num";

        public string F3Num
        {
            get { return f3Num; }
            set { f3Num = value; this.RaisePropertyChanged(nameof(F3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string f4Name= "f4Name";

        public string F4Name
        {
            get { return f4Name; }
            set { f4Name = value; this.RaisePropertyChanged(nameof(F4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string f4Logo= "f4Logo";

        public string F4Logo
        {
            get { return f4Logo; }
            set { f4Logo = value; this.RaisePropertyChanged(nameof(F4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string f4Num= "f4Num";

        public string F4Num
        {
            get { return f4Num; }
            set { f4Num = value; this.RaisePropertyChanged(nameof(F4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string f5Name= "f5Name";

        public string F5Name
        {
            get { return f5Name; }
            set { f5Name = value; this.RaisePropertyChanged(nameof(F5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string f5Logo= "f5Logo";

        public string F5Logo
        {
            get { return f5Logo; }
            set { f5Logo = value; this.RaisePropertyChanged(nameof(F5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string f5Num= "f5Num";

        public string F5Num
        {
            get { return f5Num; }
            set { f5Num = value; this.RaisePropertyChanged(nameof(F5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string f6Name= "f6Name";

        public string F6Name
        {
            get { return f6Name; }
            set { f6Name = value; this.RaisePropertyChanged(nameof(F6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string f6Logo= "f6Logo";

        public string F6Logo
        {
            get { return f6Logo; }
            set { f6Logo = value; this.RaisePropertyChanged(nameof(F6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string f6Num= "f6Num";

        public string F6Num
        {
            get { return f6Num; }
            set { f6Num = value; this.RaisePropertyChanged(nameof(F6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string f7Name= "f7Name";

        public string F7Name
        {
            get { return f7Name; }
            set { f7Name = value; this.RaisePropertyChanged(nameof(F7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string f7Logo= "f7Logo";

        public string F7Logo
        {
            get { return f7Logo; }
            set { f7Logo = value; this.RaisePropertyChanged(nameof(F7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string f7Num= "f7Num";

        public string F7Num
        {
            get { return f7Num; }
            set { f7Num = value; this.RaisePropertyChanged(nameof(F7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string f8Name= "f8Name";

        public string F8Name
        {
            get { return f8Name; }
            set { f8Name = value; this.RaisePropertyChanged(nameof(F8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string f8Logo= "f8Logo";

        public string F8Logo
        {
            get { return f8Logo; }
            set { f8Logo = value; this.RaisePropertyChanged(nameof(F8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string f8Num= "f8Num";

        public string F8Num
        {
            get { return f8Num; }
            set { f8Num = value; this.RaisePropertyChanged(nameof(F8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string f9Name= "f9Name";

        public string F9Name
        {
            get { return f9Name; }
            set { f9Name = value; this.RaisePropertyChanged(nameof(F9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string f9Logo= "f9Logo";

        public string F9Logo
        {
            get { return f9Logo; }
            set { f9Logo = value; this.RaisePropertyChanged(nameof(F9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string f9Num= "f9Num";

        public string F9Num
        {
            get { return f9Num; }
            set { f9Num = value; this.RaisePropertyChanged(nameof(F9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string f10Name= "f10Name";

        public string F10Name
        {
            get { return f10Name; }
            set { f10Name = value; this.RaisePropertyChanged(nameof(F10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string f10Logo= "f10Logo";

        public string F10Logo
        {
            get { return f10Logo; }
            set { f10Logo = value; this.RaisePropertyChanged(nameof(F10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string f10Num= "f10Num";

        public string F10Num
        {
            get { return f10Num; }
            set { f10Num = value; this.RaisePropertyChanged(nameof(F10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string f11Name= "f11Name";

        public string F11Name
        {
            get { return f11Name; }
            set { f11Name = value; this.RaisePropertyChanged(nameof(F11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string f11Logo= "f11Logo";

        public string F11Logo
        {
            get { return f11Logo; }
            set { f11Logo = value; this.RaisePropertyChanged(nameof(F11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string f11Num= "f11Num";

        public string F11Num
        {
            get { return f11Num; }
            set { f11Num = value; this.RaisePropertyChanged(nameof(F11Num)); }
        }



        #endregion

        #region 第七行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string e1Name= "e1Name";

        public string E1Name
        {
            get { return e1Name; }
            set { e1Name = value; this.RaisePropertyChanged(nameof(E1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string e1Logo= "e1Logo";

        public string E1Logo
        {
            get { return e1Logo; }
            set { e1Logo = value; this.RaisePropertyChanged(nameof(E1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string e1Num= "e1Num";

        public string E1Num
        {
            get { return e1Num; }
            set { e1Num = value; this.RaisePropertyChanged(nameof(E1Num)); }
        }




        private string e2Name= "e2Name";

        public string E2Name
        {
            get { return e2Name; }
            set { e2Name = value; this.RaisePropertyChanged(nameof(E2Name)); }
        }


        private string e2Logo= "e2Logo";

        public string E2Logo
        {
            get { return e2Logo; }
            set { e2Logo = value; this.RaisePropertyChanged(nameof(E2Logo)); }
        }


        private string e2Num= "e2Num";

        public string E2Num
        {
            get { return e2Num; }
            set { e2Num = value; this.RaisePropertyChanged(nameof(E2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string e3Name= "e3Name";

        public string E3Name
        {
            get { return e3Name; }
            set { e3Name = value; this.RaisePropertyChanged(nameof(E3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string e3Logo= "e3Logo";

        public string E3Logo
        {
            get { return e3Logo; }
            set { e3Logo = value; this.RaisePropertyChanged(nameof(E3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string e3Num= "e3Num";

        public string E3Num
        {
            get { return e3Num; }
            set { e3Num = value; this.RaisePropertyChanged(nameof(E3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string e4Name= "e4Name";

        public string E4Name
        {
            get { return e4Name; }
            set { e4Name = value; this.RaisePropertyChanged(nameof(E4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string e4Logo= "e4Logo";

        public string E4Logo
        {
            get { return e4Logo; }
            set { e4Logo = value; this.RaisePropertyChanged(nameof(E4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string e4Num= "e4Num";

        public string E4Num
        {
            get { return e4Num; }
            set { e4Num = value; this.RaisePropertyChanged(nameof(E4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string e5Name= "e5Name";

        public string E5Name
        {
            get { return e5Name; }
            set { e5Name = value; this.RaisePropertyChanged(nameof(E5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string e5Logo= "e5Logo";

        public string E5Logo
        {
            get { return e5Logo; }
            set { e5Logo = value; this.RaisePropertyChanged(nameof(E5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string e5Num= "e5Num";

        public string E5Num
        {
            get { return e5Num; }
            set { e5Num = value; this.RaisePropertyChanged(nameof(E5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string e6Name= "e6Name";

        public string E6Name
        {
            get { return e6Name; }
            set { e6Name = value; this.RaisePropertyChanged(nameof(E6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string e6Logo= "e6Logo";

        public string E6Logo
        {
            get { return e6Logo; }
            set { e6Logo = value; this.RaisePropertyChanged(nameof(E6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string e6Num= "e6Num";

        public string E6Num
        {
            get { return e6Num; }
            set { e6Num = value; this.RaisePropertyChanged(nameof(E6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string e7Name= "e7Name";

        public string E7Name
        {
            get { return e7Name; }
            set { e7Name = value; this.RaisePropertyChanged(nameof(E7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string e7Logo= "e7Logo";

        public string E7Logo
        {
            get { return e7Logo; }
            set { e7Logo = value; this.RaisePropertyChanged(nameof(E7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string e7Num= "e7Num";

        public string E7Num
        {
            get { return e7Num; }
            set { e7Num = value; this.RaisePropertyChanged(nameof(E7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string e8Name= "e8Name";

        public string E8Name
        {
            get { return e8Name; }
            set { e8Name = value; this.RaisePropertyChanged(nameof(E8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string e8Logo= "e8Logo";

        public string E8Logo
        {
            get { return e8Logo; }
            set { e8Logo = value; this.RaisePropertyChanged(nameof(E8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string e8Num= "e8Num";

        public string E8Num
        {
            get { return e8Num; }
            set { e8Num = value; this.RaisePropertyChanged(nameof(E8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string e9Name= "e9Name";

        public string E9Name
        {
            get { return e9Name; }
            set { e9Name = value; this.RaisePropertyChanged(nameof(E9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string e9Logo= "e9Logo";

        public string E9Logo
        {
            get { return e9Logo; }
            set { e9Logo = value; this.RaisePropertyChanged(nameof(E9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string e9Num= "e9Num";

        public string E9Num
        {
            get { return e9Num; }
            set { e9Num = value; this.RaisePropertyChanged(nameof(E9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string e10Name= "e10Name";

        public string E10Name
        {
            get { return e10Name; }
            set { e10Name = value; this.RaisePropertyChanged(nameof(E10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string e10Logo= "e10Logo";

        public string E10Logo
        {
            get { return e10Logo; }
            set { e10Logo = value; this.RaisePropertyChanged(nameof(E10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string e10Num= "e10Num";

        public string E10Num
        {
            get { return e10Num; }
            set { e10Num = value; this.RaisePropertyChanged(nameof(E10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string e11Name= "e11Name";

        public string E11Name
        {
            get { return e11Name; }
            set { e11Name = value; this.RaisePropertyChanged(nameof(E11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string e11Logo= "e11Logo";

        public string E11Logo
        {
            get { return e11Logo; }
            set { e11Logo = value; this.RaisePropertyChanged(nameof(E11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string e11Num= "e11Num";

        public string E11Num
        {
            get { return e11Num; }
            set { e11Num = value; this.RaisePropertyChanged(nameof(E11Num)); }
        }


        #endregion

        #region 第八行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string d1Name= "d1Name";

        public string D1Name
        {
            get { return d1Name; }
            set { d1Name = value; this.RaisePropertyChanged(nameof(D1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string d1Logo= "d1Logo";

        public string D1Logo
        {
            get { return d1Logo; }
            set { d1Logo = value; this.RaisePropertyChanged(nameof(D1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string d1Num= "d1Num";

        public string D1Num
        {
            get { return d1Num; }
            set { d1Num = value; this.RaisePropertyChanged(nameof(D1Num)); }
        }




        private string d2Name= "d2Name";

        public string D2Name
        {
            get { return d2Name; }
            set { d2Name = value; this.RaisePropertyChanged(nameof(D2Name)); }
        }


        private string d2Logo= "d2Logo";

        public string D2Logo
        {
            get { return d2Logo; }
            set { d2Logo = value; this.RaisePropertyChanged(nameof(D2Logo)); }
        }


        private string d2Num= "d2Num";

        public string D2Num
        {
            get { return d2Num; }
            set { d2Num = value; this.RaisePropertyChanged(nameof(D2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string d3Name= "d3Name";

        public string D3Name
        {
            get { return d3Name; }
            set { d3Name = value; this.RaisePropertyChanged(nameof(D3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string d3Logo= "d3Logo";

        public string D3Logo
        {
            get { return d3Logo; }
            set { d3Logo = value; this.RaisePropertyChanged(nameof(D3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string d3Num= "d3Num";

        public string D3Num
        {
            get { return d3Num; }
            set { d3Num = value; this.RaisePropertyChanged(nameof(D3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string d4Name= "d4Name";

        public string D4Name
        {
            get { return d4Name; }
            set { d4Name = value; this.RaisePropertyChanged(nameof(D4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string d4Logo= "d4Logo";

        public string D4Logo
        {
            get { return d4Logo; }
            set { d4Logo = value; this.RaisePropertyChanged(nameof(D4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string d4Num= "d4Num";

        public string D4Num
        {
            get { return d4Num; }
            set { d4Num = value; this.RaisePropertyChanged(nameof(D4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string d5Name= "d5Name";

        public string D5Name
        {
            get { return d5Name; }
            set { d5Name = value; this.RaisePropertyChanged(nameof(D5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string d5Logo= "d5Logo";

        public string D5Logo
        {
            get { return d5Logo; }
            set { d5Logo = value; this.RaisePropertyChanged(nameof(D5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string d5Num= "d5Num";

        public string D5Num
        {
            get { return d5Num; }
            set { d5Num = value; this.RaisePropertyChanged(nameof(D5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string d6Name= "d6Name";

        public string D6Name
        {
            get { return d6Name; }
            set { d6Name = value; this.RaisePropertyChanged(nameof(D6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string d6Logo= "d6Logo";

        public string D6Logo
        {
            get { return d6Logo; }
            set { d6Logo = value; this.RaisePropertyChanged(nameof(D6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string d6Num= "d6Num";

        public string D6Num
        {
            get { return d6Num; }
            set { d6Num = value; this.RaisePropertyChanged(nameof(D6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string d7Name= "d7Name";

        public string D7Name
        {
            get { return d7Name; }
            set { d7Name = value; this.RaisePropertyChanged(nameof(D7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string d7Logo= "d7Logo";

        public string D7Logo
        {
            get { return d7Logo; }
            set { d7Logo = value; this.RaisePropertyChanged(nameof(D7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string d7Num= "d7Num";

        public string D7Num
        {
            get { return d7Num; }
            set { d7Num = value; this.RaisePropertyChanged(nameof(D7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string d8Name= "d8Name";

        public string D8Name
        {
            get { return d8Name; }
            set { d8Name = value; this.RaisePropertyChanged(nameof(D8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string d8Logo= "d8Logo";

        public string D8Logo
        {
            get { return d8Logo; }
            set { d8Logo = value; this.RaisePropertyChanged(nameof(D8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string d8Num= "d8Num";

        public string D8Num
        {
            get { return d8Num; }
            set { d8Num = value; this.RaisePropertyChanged(nameof(D8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string d9Name= "d9Name";

        public string D9Name
        {
            get { return d9Name; }
            set { d9Name = value; this.RaisePropertyChanged(nameof(D9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string d9Logo= "d9Logo";

        public string D9Logo
        {
            get { return d9Logo; }
            set { d9Logo = value; this.RaisePropertyChanged(nameof(D9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string d9Num= "d9Num";

        public string D9Num
        {
            get { return d9Num; }
            set { d9Num = value; this.RaisePropertyChanged(nameof(D9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string d10Name= "d10Name";

        public string D10Name
        {
            get { return d10Name; }
            set { d10Name = value; this.RaisePropertyChanged(nameof(D10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string d10Logo= "d10Logo";

        public string D10Logo
        {
            get { return d10Logo; }
            set { d10Logo = value; this.RaisePropertyChanged(nameof(D10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string d10Num= "d10Num";

        public string D10Num
        {
            get { return d10Num; }
            set { d10Num = value; this.RaisePropertyChanged(nameof(D10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string d11Name= "d11Name";

        public string D11Name
        {
            get { return d11Name; }
            set { d11Name = value; this.RaisePropertyChanged(nameof(D11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string d11Logo= "d11Logo";

        public string D11Logo
        {
            get { return d11Logo; }
            set { d11Logo = value; this.RaisePropertyChanged(nameof(D11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string d11Num= "d11Num";

        public string D11Num
        {
            get { return d11Num; }
            set { d11Num = value; this.RaisePropertyChanged(nameof(D11Num)); }
        }


        #endregion

        #region 第九行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string c1Name= "c1Name";

        public string C1Name
        {
            get { return c1Name; }
            set { c1Name = value; this.RaisePropertyChanged(nameof(C1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string c1Logo= "c1Logo";

        public string C1Logo
        {
            get { return c1Logo; }
            set { c1Logo = value; this.RaisePropertyChanged(nameof(C1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string c1Num= "c1Num";

        public string C1Num
        {
            get { return c1Num; }
            set { c1Num = value; this.RaisePropertyChanged(nameof(C1Num)); }
        }




        private string c2Name= "c2Name";

        public string C2Name
        {
            get { return c2Name; }
            set { c2Name = value; this.RaisePropertyChanged(nameof(C2Name)); }
        }


        private string c2Logo= "c2Logo";

        public string C2Logo
        {
            get { return c2Logo; }
            set { c2Logo = value; this.RaisePropertyChanged(nameof(C2Logo)); }
        }


        private string c2Num= "c2Num";

        public string C2Num
        {
            get { return c2Num; }
            set { c2Num = value; this.RaisePropertyChanged(nameof(C2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string c3Name= "c3Name";

        public string C3Name
        {
            get { return c3Name; }
            set { c3Name = value; this.RaisePropertyChanged(nameof(C3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string c3Logo= "c3Logo";

        public string C3Logo
        {
            get { return c3Logo; }
            set { c3Logo = value; this.RaisePropertyChanged(nameof(C3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string c3Num= "c3Num";

        public string C3Num
        {
            get { return c3Num; }
            set { c3Num = value; this.RaisePropertyChanged(nameof(C3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string c4Name= "c4Name";

        public string C4Name
        {
            get { return c4Name; }
            set { c4Name = value; this.RaisePropertyChanged(nameof(C4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string c4Logo= "c4Logo";

        public string C4Logo
        {
            get { return c4Logo; }
            set { c4Logo = value; this.RaisePropertyChanged(nameof(C4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string c4Num= "c4Num";

        public string C4Num
        {
            get { return c4Num; }
            set { c4Num = value; this.RaisePropertyChanged(nameof(C4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string c5Name= "c5Name";

        public string C5Name
        {
            get { return c5Name; }
            set { c5Name = value; this.RaisePropertyChanged(nameof(C5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string c5Logo= "c5Logo";

        public string C5Logo
        {
            get { return c5Logo; }
            set { c5Logo = value; this.RaisePropertyChanged(nameof(C5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string c5Num= "c5Num";

        public string C5Num
        {
            get { return c5Num; }
            set { c5Num = value; this.RaisePropertyChanged(nameof(C5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string c6Name= "c6Name";

        public string C6Name
        {
            get { return c6Name; }
            set { c6Name = value; this.RaisePropertyChanged(nameof(C6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string c6Logo= "c6Logo";

        public string C6Logo
        {
            get { return c6Logo; }
            set { c6Logo = value; this.RaisePropertyChanged(nameof(C6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string c6Num= "c6Num";

        public string C6Num
        {
            get { return c6Num; }
            set { c6Num = value; this.RaisePropertyChanged(nameof(C6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string c7Name= "c7Name";

        public string C7Name
        {
            get { return c7Name; }
            set { c7Name = value; this.RaisePropertyChanged(nameof(C7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string c7Logo= "c7Logo";

        public string C7Logo
        {
            get { return c7Logo; }
            set { c7Logo = value; this.RaisePropertyChanged(nameof(C7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string c7Num= "c7Num";

        public string C7Num
        {
            get { return c7Num; }
            set { c7Num = value; this.RaisePropertyChanged(nameof(C7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string c8Name= "c8Name";

        public string C8Name
        {
            get { return c8Name; }
            set { c8Name = value; this.RaisePropertyChanged(nameof(C8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string c8Logo= "c8Logo";

        public string C8Logo
        {
            get { return c8Logo; }
            set { c8Logo = value; this.RaisePropertyChanged(nameof(C8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string c8Num= "c8Num";

        public string C8Num
        {
            get { return c8Num; }
            set { c8Num = value; this.RaisePropertyChanged(nameof(C8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string c9Name= "c9Name";

        public string C9Name
        {
            get { return c9Name; }
            set { c9Name = value; this.RaisePropertyChanged(nameof(C9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string c9Logo= "c9Logo";

        public string C9Logo
        {
            get { return c9Logo; }
            set { c9Logo = value; this.RaisePropertyChanged(nameof(C9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string c9Num= "c9Num";

        public string C9Num
        {
            get { return c9Num; }
            set { c9Num = value; this.RaisePropertyChanged(nameof(C9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string c10Name= "c10Name";

        public string C10Name
        {
            get { return c10Name; }
            set { c10Name = value; this.RaisePropertyChanged(nameof(C10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string c10Logo= "c10Logo";

        public string C10Logo
        {
            get { return c10Logo; }
            set { c10Logo = value; this.RaisePropertyChanged(nameof(C10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string c10Num= "c10Num";

        public string C10Num
        {
            get { return c10Num; }
            set { c10Num = value; this.RaisePropertyChanged(nameof(C10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string c11Name= "c11Name";

        public string C11Name
        {
            get { return c11Name; }
            set { c11Name = value; this.RaisePropertyChanged(nameof(C11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string c11Logo= "c11Logo";

        public string C11Logo
        {
            get { return c11Logo; }
            set { c11Logo = value; this.RaisePropertyChanged(nameof(C11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string c11Num= "c11Num";

        public string C11Num
        {
            get { return c11Num; }
            set { c11Num = value; this.RaisePropertyChanged(nameof(C11Num)); }
        }


        #endregion

        #region 第十行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string b1Name= "b1Name";

        public string B1Name
        {
            get { return b1Name; }
            set { b1Name = value; this.RaisePropertyChanged(nameof(B1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string b1Logo= "b1Logo";

        public string B1Logo
        {
            get { return b1Logo; }
            set { b1Logo = value; this.RaisePropertyChanged(nameof(B1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string b1Num= "b1Num";

        public string B1Num
        {
            get { return b1Num; }
            set { b1Num = value; this.RaisePropertyChanged(nameof(B1Num)); }
        }




        private string b2Name= "b2Name";

        public string B2Name
        {
            get { return b2Name; }
            set { b2Name = value; this.RaisePropertyChanged(nameof(B2Name)); }
        }


        private string b2Logo= "b2Logo";

        public string B2Logo
        {
            get { return b2Logo; }
            set { b2Logo = value; this.RaisePropertyChanged(nameof(B2Logo)); }
        }


        private string b2Num= "b2Num";

        public string B2Num
        {
            get { return b2Num; }
            set { b2Num = value; this.RaisePropertyChanged(nameof(B2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string b3Name= "b3Name";

        public string B3Name
        {
            get { return b3Name; }
            set { b3Name = value; this.RaisePropertyChanged(nameof(B3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string b3Logo= "b3Logo";

        public string B3Logo
        {
            get { return b3Logo; }
            set { b3Logo = value; this.RaisePropertyChanged(nameof(B3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string b3Num= "b3Num";

        public string B3Num
        {
            get { return b3Num; }
            set { b3Num = value; this.RaisePropertyChanged(nameof(B3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string b4Name= "b4Name";

        public string B4Name
        {
            get { return b4Name; }
            set { b4Name = value; this.RaisePropertyChanged(nameof(B4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string b4Logo= "b4Logo";

        public string B4Logo
        {
            get { return b4Logo; }
            set { b4Logo = value; this.RaisePropertyChanged(nameof(B4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string b4Num= "b4Num";

        public string B4Num
        {
            get { return b4Num; }
            set { b4Num = value; this.RaisePropertyChanged(nameof(B4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string b5Name= "b5Name";

        public string B5Name
        {
            get { return b5Name; }
            set { b5Name = value; this.RaisePropertyChanged(nameof(B5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string b5Logo= "b5Logo";

        public string B5Logo
        {
            get { return b5Logo; }
            set { b5Logo = value; this.RaisePropertyChanged(nameof(B5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string b5Num= "b5Num";

        public string B5Num
        {
            get { return b5Num; }
            set { b5Num = value; this.RaisePropertyChanged(nameof(B5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string b6Name= "b6Name";

        public string B6Name
        {
            get { return b6Name; }
            set { b6Name = value; this.RaisePropertyChanged(nameof(B6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string b6Logo= "b6Logo";

        public string B6Logo
        {
            get { return b6Logo; }
            set { b6Logo = value; this.RaisePropertyChanged(nameof(B6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string b6Num= "b6Num";

        public string B6Num
        {
            get { return b6Num; }
            set { b6Num = value; this.RaisePropertyChanged(nameof(B6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string b7Name= "b7Name";

        public string B7Name
        {
            get { return b7Name; }
            set { b7Name = value; this.RaisePropertyChanged(nameof(B7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string b7Logo= "b7Logo";

        public string B7Logo
        {
            get { return b7Logo; }
            set { b7Logo = value; this.RaisePropertyChanged(nameof(B7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string b7Num= "b7Num";

        public string B7Num
        {
            get { return b7Num; }
            set { b7Num = value; this.RaisePropertyChanged(nameof(B7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string b8Name= "b8Name";

        public string B8Name
        {
            get { return b8Name; }
            set { b8Name = value; this.RaisePropertyChanged(nameof(B8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string b8Logo= "b8Logo";

        public string B8Logo
        {
            get { return b8Logo; }
            set { b8Logo = value; this.RaisePropertyChanged(nameof(B8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string b8Num= "b8Num";

        public string B8Num
        {
            get { return b8Num; }
            set { b8Num = value; this.RaisePropertyChanged(nameof(B8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string b9Name= "b9Name";

        public string B9Name
        {
            get { return b9Name; }
            set { b9Name = value; this.RaisePropertyChanged(nameof(B9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string b9Logo= "b9Logo";

        public string B9Logo
        {
            get { return b9Logo; }
            set { b9Logo = value; this.RaisePropertyChanged(nameof(B9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string b9Num= "b9Num";

        public string B9Num
        {
            get { return b9Num; }
            set { b9Num = value; this.RaisePropertyChanged(nameof(B9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string b10Name= "b10Name";

        public string B10Name
        {
            get { return b10Name; }
            set { b10Name = value; this.RaisePropertyChanged(nameof(B10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string b10Logo= "b10Logo";

        public string B10Logo
        {
            get { return b10Logo; }
            set { b10Logo = value; this.RaisePropertyChanged(nameof(B10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string b10Num= "b10Num";

        public string B10Num
        {
            get { return b10Num; }
            set { b10Num = value; this.RaisePropertyChanged(nameof(B10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string b11Name= "b11Name";

        public string B11Name
        {
            get { return b11Name; }
            set { b11Name = value; this.RaisePropertyChanged(nameof(B11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string b11Logo= "b11Logo";

        public string B11Logo
        {
            get { return b11Logo; }
            set { b11Logo = value; this.RaisePropertyChanged(nameof(B11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string b11Num= "b11Num";

        public string B11Num
        {
            get { return b11Num; }
            set { b11Num = value; this.RaisePropertyChanged(nameof(B11Num)); }
        }


        #endregion

        #region 第十一行数据


        /// <summary>
        /// 球员名称
        /// </summary>
        private string a1Name= "a1Name";

        public string A1Name
        {
            get { return a1Name; }
            set { a1Name = value; this.RaisePropertyChanged(nameof(A1Name)); }
        }

        /// <summary>
        /// 球员图片
        /// </summary>
        private string a1Logo= "a1Logo";

        public string A1Logo
        {
            get { return a1Logo; }
            set { a1Logo = value; this.RaisePropertyChanged(nameof(A1Logo)); }
        }


        /// <summary>
        /// 球衣号
        /// </summary>
        private string a1Num= "a1Num";

        public string A1Num
        {
            get { return a1Num; }
            set { a1Num = value; this.RaisePropertyChanged(nameof(A1Num)); }
        }




        private string a2Name= "a2Name";

        public string A2Name
        {
            get { return a2Name; }
            set { a2Name = value; this.RaisePropertyChanged(nameof(A2Name)); }
        }


        private string a2Logo= "a2Logo";

        public string A2Logo
        {
            get { return a2Logo; }
            set { a2Logo = value; this.RaisePropertyChanged(nameof(A2Logo)); }
        }


        private string a2Num= "a2Num";

        public string A2Num
        {
            get { return a2Num; }
            set { a2Num = value; this.RaisePropertyChanged(nameof(A2Num)); }
        }



        /// <summary>
        /// 球员名称3
        /// </summary>
        private string a3Name= "a3Name";

        public string A3Name
        {
            get { return a3Name; }
            set { a3Name = value; this.RaisePropertyChanged(nameof(A3Name)); }
        }

        /// <summary>
        /// 球员图片3
        /// </summary>
        private string a3Logo= "a3Logo";

        public string A3Logo
        {
            get { return a3Logo; }
            set { a3Logo = value; this.RaisePropertyChanged(nameof(A3Logo)); }
        }


        /// <summary>
        /// 球衣号3
        /// </summary>
        private string a3Num= "a3Num";

        public string A3Num
        {
            get { return a3Num; }
            set { a3Num = value; this.RaisePropertyChanged(nameof(A3Num)); }
        }




        /// <summary>
        /// 球员名称4
        /// </summary>
        private string a4Name= "a4Name";

        public string A4Name
        {
            get { return a4Name; }
            set { a4Name = value; this.RaisePropertyChanged(nameof(A4Name)); }
        }

        /// <summary>
        /// 球员图片4
        /// </summary>
        private string a4Logo= "a4Logo";

        public string A4Logo
        {
            get { return a4Logo; }
            set { a4Logo = value; this.RaisePropertyChanged(nameof(A4Logo)); }
        }


        /// <summary>
        /// 球衣号4
        /// </summary>
        private string a4Num= "a4Num";

        public string A4Num
        {
            get { return a4Num; }
            set { a4Num = value; this.RaisePropertyChanged(nameof(A4Num)); }
        }



        /// <summary>
        /// 球员名称5
        /// </summary>
        private string a5Name= "a5Name";

        public string A5Name
        {
            get { return a5Name; }
            set { a5Name = value; this.RaisePropertyChanged(nameof(A5Name)); }
        }

        /// <summary>
        /// 球员图片5
        /// </summary>
        private string a5Logo= "a5Logo";

        public string A5Logo
        {
            get { return a5Logo; }
            set { a5Logo = value; this.RaisePropertyChanged(nameof(A5Logo)); }
        }


        /// <summary>
        /// 球衣号5
        /// </summary>
        private string a5Num= "a5Num";

        public string A5Num
        {
            get { return a5Num; }
            set { a5Num = value; this.RaisePropertyChanged(nameof(A5Num)); }
        }




        /// <summary>
        /// 球员名称6
        /// </summary>
        private string a6Name= "a6Name";

        public string A6Name
        {
            get { return a6Name; }
            set { a6Name = value; this.RaisePropertyChanged(nameof(A6Name)); }
        }

        /// <summary>
        /// 球员图片6
        /// </summary>
        private string a6Logo= "a6Logo";

        public string A6Logo
        {
            get { return a6Logo; }
            set { a6Logo = value; this.RaisePropertyChanged(nameof(A6Logo)); }
        }


        /// <summary>
        /// 球衣号6
        /// </summary>
        private string a6Num= "a6Num";

        public string A6Num
        {
            get { return a6Num; }
            set { a6Num = value; this.RaisePropertyChanged(nameof(A6Num)); }
        }



        /// <summary>
        /// 球员名称7
        /// </summary>
        private string a7Name= "a7Name";

        public string A7Name
        {
            get { return a7Name; }
            set { a7Name = value; this.RaisePropertyChanged(nameof(A7Name)); }
        }

        /// <summary>
        /// 球员图片7
        /// </summary>
        private string a7Logo= "a7Logo";

        public string A7Logo
        {
            get { return a7Logo; }
            set { a7Logo = value; this.RaisePropertyChanged(nameof(A7Logo)); }
        }


        /// <summary>
        /// 球衣号7
        /// </summary>
        private string a7Num= "a7Num";

        public string A7Num
        {
            get { return a7Num; }
            set { a7Num = value; this.RaisePropertyChanged(nameof(A7Num)); }
        }



        /// <summary>
        /// 球员名称8
        /// </summary>
        private string a8Name= "a8Name";

        public string A8Name
        {
            get { return a8Name; }
            set { a8Name = value; this.RaisePropertyChanged(nameof(A8Name)); }
        }

        /// <summary>
        /// 球员图片8
        /// </summary>
        private string a8Logo= "a8Logo";

        public string A8Logo
        {
            get { return a8Logo; }
            set { a8Logo = value; this.RaisePropertyChanged(nameof(A8Logo)); }
        }


        /// <summary>
        /// 球衣号8
        /// </summary>
        private string a8Num= "a8Num";

        public string A8Num
        {
            get { return a8Num; }
            set { a8Num = value; this.RaisePropertyChanged(nameof(A8Num)); }
        }



        /// <summary>
        /// 球员名称9
        /// </summary>
        private string a9Name= "a9Name";

        public string A9Name
        {
            get { return a9Name; }
            set { a9Name = value; this.RaisePropertyChanged(nameof(A9Name)); }
        }

        /// <summary>
        /// 球员图片9
        /// </summary>
        private string a9Logo= "a9Logo";

        public string A9Logo
        {
            get { return a9Logo; }
            set { a9Logo = value; this.RaisePropertyChanged(nameof(A9Logo)); }
        }


        /// <summary>
        /// 球衣号9
        /// </summary>
        private string a9Num= "a9Num";

        public string A9Num
        {
            get { return a9Num; }
            set { a9Num = value; this.RaisePropertyChanged(nameof(A9Num)); }
        }



        /// <summary>
        /// 球员名称10
        /// </summary>
        private string a10Name= "a10Name";

        public string A10Name
        {
            get { return a10Name; }
            set { a10Name = value; this.RaisePropertyChanged(nameof(A10Name)); }
        }

        /// <summary>
        /// 球员图片10
        /// </summary>
        private string a10Logo= "a10Logo";

        public string A10Logo
        {
            get { return a10Logo; }
            set { a10Logo = value; this.RaisePropertyChanged(nameof(A10Logo)); }
        }


        /// <summary>
        /// 球衣号10
        /// </summary>
        private string a10Num= "a10Num";

        public string A10Num
        {
            get { return a10Num; }
            set { a10Num = value; this.RaisePropertyChanged(nameof(A10Num)); }
        }



        /// <summary>
        /// 球员名称11
        /// </summary>
        private string a11Name= "a11Name";

        public string A11Name
        {
            get { return a11Name; }
            set { a11Name = value; this.RaisePropertyChanged(nameof(A11Name)); }
        }

        /// <summary>
        /// 球员图片11
        /// </summary>
        private string a11Logo= "a11Logo";

        public string A11Logo
        {
            get { return a11Logo; }
            set { a11Logo = value; this.RaisePropertyChanged(nameof(A11Logo)); }
        }


        /// <summary>
        /// 球衣号11
        /// </summary>
        private string a11Num= "a11Num";

        public string A11Num
        {
            get { return a11Num; }
            set { a11Num = value; this.RaisePropertyChanged(nameof(A11Num)); }
        }


        #endregion


        /// <summary>
        /// 清除数据
        /// </summary>
        public void CleanData()
        {

            #region 第一行数据清空

            K1Name = "";
            K1Logo = "";
            K1Num = "";


            K2Name = "";
            K2Logo = "";
            K2Num = "";

            K3Name = "";
            K3Logo = "";
            K3Num = "";

            K4Name = "";
            K4Logo = "";
            K4Num = "";

            K5Name = "";
            K5Logo = "";
            K5Num = "";

            K6Name = "";
            K6Logo = "";
            K6Num = "";

            K7Name = "";
            K7Logo = "";
            K7Num = "";

            K8Name = "";
            K8Logo = "";
            K8Num = "";

            K9Name = "";
            K9Logo = "";
            K9Num = "";

            K10Name = "";
            K10Logo = "";
            K10Num = "";


            K11Name = "";
            K11Logo = "";
            K11Num = "";


            #endregion

            #region 第二行数据清空

            J1Name = "";
            J1Logo = "";
            J1Num = "";


            J2Name = "";
            J2Logo = "";
            J2Num = "";

            J3Name = "";
            J3Logo = "";
            J3Num = "";

            J4Name = "";
            J4Logo = "";
            J4Num = "";

            J5Name = "";
            J5Logo = "";
            J5Num = "";

            J6Name = "";
            J6Logo = "";
            J6Num = "";

            J7Name = "";
            J7Logo = "";
            J7Num = "";

            J8Name = "";
            J8Logo = "";
            J8Num = "";

            J9Name = "";
            J9Logo = "";
            J9Num = "";

            J10Name = "";
            J10Logo = "";
            J10Num = "";


            J11Name = "";
            J11Logo = "";
            J11Num = "";


            #endregion

            #region 第三行数据清空

            I1Name = "";
            I1Logo = "";
            I1Num = "";


            I2Name = "";
            I2Logo = "";
            I2Num = "";

            I3Name = "";
            I3Logo = "";
            I3Num = "";

            I4Name = "";
            I4Logo = "";
            I4Num = "";

            I5Name = "";
            I5Logo = "";
            I5Num = "";

            I6Name = "";
            I6Logo = "";
            I6Num = "";

            I7Name = "";
            I7Logo = "";
            I7Num = "";

            I8Name = "";
            I8Logo = "";
            I8Num = "";

            I9Name = "";
            I9Logo = "";
            I9Num = "";

            I10Name = "";
            I10Logo = "";
            I10Num = "";


            I11Name = "";
            I11Logo = "";
            I11Num = "";


            #endregion

            #region 第四行数据清空

            H1Name = "";
            H1Logo = "";
            H1Num = "";


            H2Name = "";
            H2Logo = "";
            H2Num = "";

            H3Name = "";
            H3Logo = "";
            H3Num = "";

            H4Name = "";
            H4Logo = "";
            H4Num = "";

            H5Name = "";
            H5Logo = "";
            H5Num = "";

            H6Name = "";
            H6Logo = "";
            H6Num = "";

            H7Name = "";
            H7Logo = "";
            H7Num = "";

            H8Name = "";
            H8Logo = "";
            H8Num = "";

            H9Name = "";
            H9Logo = "";
            H9Num = "";

            H10Name = "";
            H10Logo = "";
            H10Num = "";


            H11Name = "";
            H11Logo = "";
            H11Num = "";


            #endregion

            #region 第五行数据清空

            G1Name = "";
            G1Logo = "";
            G1Num = "";


            G2Name = "";
            G2Logo = "";
            G2Num = "";

            G3Name = "";
            G3Logo = "";
            G3Num = "";

            G4Name = "";
            G4Logo = "";
            G4Num = "";

            G5Name = "";
            G5Logo = "";
            G5Num = "";

            G6Name = "";
            G6Logo = "";
            G6Num = "";

            G7Name = "";
            G7Logo = "";
            G7Num = "";

            G8Name = "";
            G8Logo = "";
            G8Num = "";

            G9Name = "";
            G9Logo = "";
            G9Num = "";

            G10Name = "";
            G10Logo = "";
            G10Num = "";


            G11Name = "";
            G11Logo = "";
            G11Num = "";


            #endregion

            #region 第六行数据清空

            F1Name = "";
            F1Logo = "";
            F1Num = "";


            F2Name = "";
            F2Logo = "";
            F2Num = "";

            F3Name = "";
            F3Logo = "";
            F3Num = "";

            F4Name = "";
            F4Logo = "";
            F4Num = "";

            F5Name = "";
            F5Logo = "";
            F5Num = "";

            F6Name = "";
            F6Logo = "";
            F6Num = "";

            F7Name = "";
            F7Logo = "";
            F7Num = "";

            F8Name = "";
            F8Logo = "";
            F8Num = "";

            F9Name = "";
            F9Logo = "";
            F9Num = "";

            F10Name = "";
            F10Logo = "";
            F10Num = "";


            F11Name = "";
            F11Logo = "";
            F11Num = "";


            #endregion

            #region 第七行数据清空

            E1Name = "";
            E1Logo = "";
            E1Num = "";


            E2Name = "";
            E2Logo = "";
            E2Num = "";

            E3Name = "";
            E3Logo = "";
            E3Num = "";

            E4Name = "";
            E4Logo = "";
            E4Num = "";

            E5Name = "";
            E5Logo = "";
            E5Num = "";

            E6Name = "";
            E6Logo = "";
            E6Num = "";

            E7Name = "";
            E7Logo = "";
            E7Num = "";

            E8Name = "";
            E8Logo = "";
            E8Num = "";

            E9Name = "";
            E9Logo = "";
            E9Num = "";

            E10Name = "";
            E10Logo = "";
            E10Num = "";


            E11Name = "";
            E11Logo = "";
            E11Num = "";


            #endregion

            #region 第八行数据清空

            D1Name = "";
            D1Logo = "";
            D1Num = "";


            D2Name = "";
            D2Logo = "";
            D2Num = "";

            D3Name = "";
            D3Logo = "";
            D3Num = "";

            D4Name = "";
            D4Logo = "";
            D4Num = "";

            D5Name = "";
            D5Logo = "";
            D5Num = "";

            D6Name = "";
            D6Logo = "";
            D6Num = "";

            D7Name = "";
            D7Logo = "";
            D7Num = "";

            D8Name = "";
            D8Logo = "";
            D8Num = "";

            D9Name = "";
            D9Logo = "";
            D9Num = "";

            D10Name = "";
            D10Logo = "";
            D10Num = "";


            D11Name = "";
            D11Logo = "";
            D11Num = "";


            #endregion

            #region 第九行数据清空

            C1Name = "";
            C1Logo = "";
            C1Num = "";


            C2Name = "";
            C2Logo = "";
            C2Num = "";

            C3Name = "";
            C3Logo = "";
            C3Num = "";

            C4Name = "";
            C4Logo = "";
            C4Num = "";

            C5Name = "";
            C5Logo = "";
            C5Num = "";

            C6Name = "";
            C6Logo = "";
            C6Num = "";

            C7Name = "";
            C7Logo = "";
            C7Num = "";

            C8Name = "";
            C8Logo = "";
            C8Num = "";

            C9Name = "";
            C9Logo = "";
            C9Num = "";

            C10Name = "";
            C10Logo = "";
            C10Num = "";


            C11Name = "";
            C11Logo = "";
            C11Num = "";


            #endregion

            #region 第十行数据清空

            B1Name = "";
            B1Logo = "";
            B1Num = "";


            B2Name = "";
            B2Logo = "";
            B2Num = "";

            B3Name = "";
            B3Logo = "";
            B3Num = "";

            B4Name = "";
            B4Logo = "";
            B4Num = "";

            B5Name = "";
            B5Logo = "";
            B5Num = "";

            B6Name = "";
            B6Logo = "";
            B6Num = "";

            B7Name = "";
            B7Logo = "";
            B7Num = "";

            B8Name = "";
            B8Logo = "";
            B8Num = "";

            B9Name = "";
            B9Logo = "";
            B9Num = "";

            B10Name = "";
            B10Logo = "";
            B10Num = "";


            B11Name = "";
            B11Logo = "";
            B11Num = "";


            #endregion

            #region 第十一行数据清空

            A1Name = "";
            A1Logo = "";
            A1Num = "";

            A2Name = "";
            A2Logo = "";
            A2Num = "";

            A3Name = "";
            A3Logo = "";
            A3Num = "";

            A4Name = "";
            A4Logo = "";
            A4Num = "";

            A5Name = "";
            A5Logo = "";
            A5Num = "";

            A6Name = "";
            A6Logo = "";
            A6Num = "";

            A7Name = "";
            A7Logo = "";
            A7Num = "";

            A8Name = "";
            A8Logo = "";
            A8Num = "";

            A9Name = "";
            A9Logo = "";
            A9Num = "";

            A10Name = "";
            A10Logo = "";
            A10Num = "";

            A11Name = "";
            A11Logo = "";
            A11Num = "";


            #endregion

        }


        public  string CombineTeamComData()
        {

            try
            {
                string data = "";

                //设置阵型
                if (selectForMationItem == "4-4-2")
                {
                    data = data + "0" + "&";

                }
                else if (selectForMationItem == "4-2-3-1")
                {
                    data = data + "1" + "&";
                }
                else if (selectForMationItem == "3-5-2")
                {
                    data = data + "2" + "&";
                }

                //设置国家图片
                data = data + nationTeam+"&";
                //设置国家名称
                data = data + TeamName + "&";


                //第一行只处理守门员信息
                if (!string.IsNullOrEmpty(A6Logo))
                {
                    data += A6Logo + "*";
                }
                if (!string.IsNullOrEmpty(A6Num))
                {
                    data += A6Num + "*";
                }
                if (!string.IsNullOrEmpty(A6Name))
                {
                    data += A6Name + ";";
                }

                #region 处理第二行信息

                if (!string.IsNullOrEmpty(B1Logo))
                {
                    data += B1Logo + "*";
                }
                if (!string.IsNullOrEmpty(B1Num))
                {
                    data += B1Num + "*";
                }
                if (!string.IsNullOrEmpty(B1Name))
                {
                    data += B1Name + ";";
                }



                if (!string.IsNullOrEmpty(B2Logo))
                {
                    data += B2Logo + "*";
                }
                if (!string.IsNullOrEmpty(B2Num))
                {
                    data += B2Num + "*";
                }
                if (!string.IsNullOrEmpty(B2Name))
                {
                    data += B2Name + ";";
                }


                if (!string.IsNullOrEmpty(B3Logo))
                {
                    data += B3Logo + "*";
                }
                if (!string.IsNullOrEmpty(B3Num))
                {
                    data += B3Num + "*";
                }
                if (!string.IsNullOrEmpty(B3Name))
                {
                    data += B3Name + ";";
                }



                if (!string.IsNullOrEmpty(B4Logo))
                {
                    data += B4Logo + "*";
                }
                if (!string.IsNullOrEmpty(B4Num))
                {
                    data += B4Num + "*";
                }
                if (!string.IsNullOrEmpty(B4Name))
                {
                    data += B4Name + ";";
                }



                if (!string.IsNullOrEmpty(B5Logo))
                {
                    data += B5Logo + "*";
                }
                if (!string.IsNullOrEmpty(B5Num))
                {
                    data += B5Num + "*";
                }
                if (!string.IsNullOrEmpty(B5Name))
                {
                    data += B5Name + ";";
                }


                if (!string.IsNullOrEmpty(B6Logo))
                {
                    data += B6Logo + "*";
                }
                if (!string.IsNullOrEmpty(B6Num))
                {
                    data += B6Num + "*";
                }
                if (!string.IsNullOrEmpty(B6Name))
                {
                    data += B6Name + ";";
                }


                if (!string.IsNullOrEmpty(B7Logo))
                {
                    data += B7Logo + "*";
                }
                if (!string.IsNullOrEmpty(B7Num))
                {
                    data += B7Num + "*";
                }
                if (!string.IsNullOrEmpty(B7Name))
                {
                    data += B7Name + ";";
                }


                if (!string.IsNullOrEmpty(B8Logo))
                {
                    data += B8Logo + "*";
                }
                if (!string.IsNullOrEmpty(B8Num))
                {
                    data += B8Num + "*";
                }
                if (!string.IsNullOrEmpty(B8Name))
                {
                    data += B8Name + ";";
                }


                if (!string.IsNullOrEmpty(B9Logo))
                {
                    data += B9Logo + "*";
                }
                if (!string.IsNullOrEmpty(B9Num))
                {
                    data += B9Num + "*";
                }
                if (!string.IsNullOrEmpty(B9Name))
                {
                    data += B9Name + ";";
                }


                if (!string.IsNullOrEmpty(B10Logo))
                {
                    data += B10Logo + "*";
                }
                if (!string.IsNullOrEmpty(B10Num))
                {
                    data += B10Num + "*";
                }
                if (!string.IsNullOrEmpty(B10Name))
                {
                    data += B10Name + ";";
                }

                if (!string.IsNullOrEmpty(B11Logo))
                {
                    data += B11Logo + "*";
                }
                if (!string.IsNullOrEmpty(B11Num))
                {
                    data += B11Num + "*";
                }
                if (!string.IsNullOrEmpty(B11Name))
                {
                    data += B11Name + ";";
                }


                #endregion

                #region 处理第三行信息

                if (!string.IsNullOrEmpty(C1Logo))
                {
                    data += C1Logo + "*";
                }
                if (!string.IsNullOrEmpty(C1Num))
                {
                    data += C1Num + "*";
                }
                if (!string.IsNullOrEmpty(C1Name))
                {
                    data += C1Name + ";";
                }



                if (!string.IsNullOrEmpty(C2Logo))
                {
                    data += C2Logo + "*";
                }
                if (!string.IsNullOrEmpty(C2Num))
                {
                    data += C2Num + "*";
                }
                if (!string.IsNullOrEmpty(C2Name))
                {
                    data += C2Name + ";";
                }


                if (!string.IsNullOrEmpty(C3Logo))
                {
                    data += C3Logo + "*";
                }
                if (!string.IsNullOrEmpty(C3Num))
                {
                    data += C3Num + "*";
                }
                if (!string.IsNullOrEmpty(C3Name))
                {
                    data += C3Name + ";";
                }



                if (!string.IsNullOrEmpty(C4Logo))
                {
                    data += C4Logo + "*";
                }
                if (!string.IsNullOrEmpty(C4Num))
                {
                    data += C4Num + "*";
                }
                if (!string.IsNullOrEmpty(C4Name))
                {
                    data += C4Name + ";";
                }



                if (!string.IsNullOrEmpty(C5Logo))
                {
                    data += C5Logo + "*";
                }
                if (!string.IsNullOrEmpty(C5Num))
                {
                    data += C5Num + "*";
                }
                if (!string.IsNullOrEmpty(C5Name))
                {
                    data += C5Name + ";";
                }


                if (!string.IsNullOrEmpty(C6Logo))
                {
                    data += C6Logo + "*";
                }
                if (!string.IsNullOrEmpty(C6Num))
                {
                    data += C6Num + "*";
                }
                if (!string.IsNullOrEmpty(C6Name))
                {
                    data += C6Name + ";";
                }


                if (!string.IsNullOrEmpty(C7Logo))
                {
                    data += C7Logo + "*";
                }
                if (!string.IsNullOrEmpty(C7Num))
                {
                    data += C7Num + "*";
                }
                if (!string.IsNullOrEmpty(C7Name))
                {
                    data += C7Name + ";";
                }


                if (!string.IsNullOrEmpty(C8Logo))
                {
                    data += C8Logo + "*";
                }
                if (!string.IsNullOrEmpty(C8Num))
                {
                    data += C8Num + "*";
                }
                if (!string.IsNullOrEmpty(C8Name))
                {
                    data += C8Name + ";";
                }


                if (!string.IsNullOrEmpty(C9Logo))
                {
                    data += C9Logo + "*";
                }
                if (!string.IsNullOrEmpty(C9Num))
                {
                    data += C9Num + "*";
                }
                if (!string.IsNullOrEmpty(C9Name))
                {
                    data += C9Name + ";";
                }


                if (!string.IsNullOrEmpty(C10Logo))
                {
                    data += C10Logo + "*";
                }
                if (!string.IsNullOrEmpty(C10Num))
                {
                    data += C10Num + "*";
                }
                if (!string.IsNullOrEmpty(C10Name))
                {
                    data += C10Name + ";";
                }

                if (!string.IsNullOrEmpty(C11Logo))
                {
                    data += C11Logo + "*";
                }
                if (!string.IsNullOrEmpty(C11Num))
                {
                    data += C11Num + "*";
                }
                if (!string.IsNullOrEmpty(C11Name))
                {
                    data += C11Name + ";";
                }


                #endregion

                #region 处理第四行信息

                if (!string.IsNullOrEmpty(D1Logo))
                {
                    data += D1Logo + "*";
                }
                if (!string.IsNullOrEmpty(D1Num))
                {
                    data += D1Num + "*";
                }
                if (!string.IsNullOrEmpty(D1Name))
                {
                    data += D1Name + ";";
                }



                if (!string.IsNullOrEmpty(D2Logo))
                {
                    data += D2Logo + "*";
                }
                if (!string.IsNullOrEmpty(D2Num))
                {
                    data += D2Num + "*";
                }
                if (!string.IsNullOrEmpty(D2Name))
                {
                    data += D2Name + ";";
                }


                if (!string.IsNullOrEmpty(D3Logo))
                {
                    data += D3Logo + "*";
                }
                if (!string.IsNullOrEmpty(D3Num))
                {
                    data += D3Num + "*";
                }
                if (!string.IsNullOrEmpty(D3Name))
                {
                    data += D3Name + ";";
                }



                if (!string.IsNullOrEmpty(D4Logo))
                {
                    data += D4Logo + "*";
                }
                if (!string.IsNullOrEmpty(D4Num))
                {
                    data += D4Num + "*";
                }
                if (!string.IsNullOrEmpty(D4Name))
                {
                    data += D4Name + ";";
                }



                if (!string.IsNullOrEmpty(D5Logo))
                {
                    data += D5Logo + "*";
                }
                if (!string.IsNullOrEmpty(D5Num))
                {
                    data += D5Num + "*";
                }
                if (!string.IsNullOrEmpty(D5Name))
                {
                    data += D5Name + ";";
                }


                if (!string.IsNullOrEmpty(D6Logo))
                {
                    data += D6Logo + "*";
                }
                if (!string.IsNullOrEmpty(D6Num))
                {
                    data += D6Num + "*";
                }
                if (!string.IsNullOrEmpty(D6Name))
                {
                    data += D6Name + ";";
                }


                if (!string.IsNullOrEmpty(D7Logo))
                {
                    data += D7Logo + "*";
                }
                if (!string.IsNullOrEmpty(D7Num))
                {
                    data += D7Num + "*";
                }
                if (!string.IsNullOrEmpty(D7Name))
                {
                    data += D7Name + ";";
                }


                if (!string.IsNullOrEmpty(D8Logo))
                {
                    data += D8Logo + "*";
                }
                if (!string.IsNullOrEmpty(D8Num))
                {
                    data += D8Num + "*";
                }
                if (!string.IsNullOrEmpty(D8Name))
                {
                    data += D8Name + ";";
                }


                if (!string.IsNullOrEmpty(D9Logo))
                {
                    data += D9Logo + "*";
                }
                if (!string.IsNullOrEmpty(D9Num))
                {
                    data += D9Num + "*";
                }
                if (!string.IsNullOrEmpty(D9Name))
                {
                    data += D9Name + ";";
                }


                if (!string.IsNullOrEmpty(D10Logo))
                {
                    data += D10Logo + "*";
                }
                if (!string.IsNullOrEmpty(D10Num))
                {
                    data += D10Num + "*";
                }
                if (!string.IsNullOrEmpty(D10Name))
                {
                    data += D10Name + ";";
                }

                if (!string.IsNullOrEmpty(D11Logo))
                {
                    data += D11Logo + "*";
                }
                if (!string.IsNullOrEmpty(D11Num))
                {
                    data += D11Num + "*";
                }
                if (!string.IsNullOrEmpty(D11Name))
                {
                    data += D11Name + ";";
                }


                #endregion

                #region 处理第五行信息

                if (!string.IsNullOrEmpty(E1Logo))
                {
                    data += E1Logo + "*";
                }
                if (!string.IsNullOrEmpty(E1Num))
                {
                    data += E1Num + "*";
                }
                if (!string.IsNullOrEmpty(E1Name))
                {
                    data += E1Name + ";";
                }



                if (!string.IsNullOrEmpty(E2Logo))
                {
                    data += E2Logo + "*";
                }
                if (!string.IsNullOrEmpty(E2Num))
                {
                    data += E2Num + "*";
                }
                if (!string.IsNullOrEmpty(E2Name))
                {
                    data += E2Name + ";";
                }


                if (!string.IsNullOrEmpty(E3Logo))
                {
                    data += E3Logo + "*";
                }
                if (!string.IsNullOrEmpty(E3Num))
                {
                    data += E3Num + "*";
                }
                if (!string.IsNullOrEmpty(E3Name))
                {
                    data += E3Name + ";";
                }



                if (!string.IsNullOrEmpty(E4Logo))
                {
                    data += E4Logo + "*";
                }
                if (!string.IsNullOrEmpty(E4Num))
                {
                    data += E4Num + "*";
                }
                if (!string.IsNullOrEmpty(E4Name))
                {
                    data += E4Name + ";";
                }



                if (!string.IsNullOrEmpty(E5Logo))
                {
                    data += E5Logo + "*";
                }
                if (!string.IsNullOrEmpty(E5Num))
                {
                    data += E5Num + "*";
                }
                if (!string.IsNullOrEmpty(E5Name))
                {
                    data += E5Name + ";";
                }


                if (!string.IsNullOrEmpty(E6Logo))
                {
                    data += E6Logo + "*";
                }
                if (!string.IsNullOrEmpty(E6Num))
                {
                    data += E6Num + "*";
                }
                if (!string.IsNullOrEmpty(E6Name))
                {
                    data += E6Name + ";";
                }


                if (!string.IsNullOrEmpty(E7Logo))
                {
                    data += E7Logo + "*";
                }
                if (!string.IsNullOrEmpty(E7Num))
                {
                    data += E7Num + "*";
                }
                if (!string.IsNullOrEmpty(E7Name))
                {
                    data += E7Name + ";";
                }


                if (!string.IsNullOrEmpty(E8Logo))
                {
                    data += E8Logo + "*";
                }
                if (!string.IsNullOrEmpty(E8Num))
                {
                    data += E8Num + "*";
                }
                if (!string.IsNullOrEmpty(E8Name))
                {
                    data += E8Name + ";";
                }


                if (!string.IsNullOrEmpty(E9Logo))
                {
                    data += E9Logo + "*";
                }
                if (!string.IsNullOrEmpty(E9Num))
                {
                    data += E9Num + "*";
                }
                if (!string.IsNullOrEmpty(E9Name))
                {
                    data += E9Name + ";";
                }


                if (!string.IsNullOrEmpty(E10Logo))
                {
                    data += E10Logo + "*";
                }
                if (!string.IsNullOrEmpty(E10Num))
                {
                    data += E10Num + "*";
                }
                if (!string.IsNullOrEmpty(E10Name))
                {
                    data += E10Name + ";";
                }

                if (!string.IsNullOrEmpty(E11Logo))
                {
                    data += E11Logo + "*";
                }
                if (!string.IsNullOrEmpty(E11Num))
                {
                    data += E11Num + "*";
                }
                if (!string.IsNullOrEmpty(E11Name))
                {
                    data += E11Name + ";";
                }


                #endregion

                #region 处理第六行信息

                if (!string.IsNullOrEmpty(F1Logo))
                {
                    data += F1Logo + "*";
                }
                if (!string.IsNullOrEmpty(F1Num))
                {
                    data += F1Num + "*";
                }
                if (!string.IsNullOrEmpty(F1Name))
                {
                    data += F1Name + ";";
                }



                if (!string.IsNullOrEmpty(F2Logo))
                {
                    data += F2Logo + "*";
                }
                if (!string.IsNullOrEmpty(F2Num))
                {
                    data += F2Num + "*";
                }
                if (!string.IsNullOrEmpty(F2Name))
                {
                    data += F2Name + ";";
                }


                if (!string.IsNullOrEmpty(F3Logo))
                {
                    data += F3Logo + "*";
                }
                if (!string.IsNullOrEmpty(F3Num))
                {
                    data += F3Num + "*";
                }
                if (!string.IsNullOrEmpty(F3Name))
                {
                    data += F3Name + ";";
                }



                if (!string.IsNullOrEmpty(F4Logo))
                {
                    data += F4Logo + "*";
                }
                if (!string.IsNullOrEmpty(F4Num))
                {
                    data += F4Num + "*";
                }
                if (!string.IsNullOrEmpty(F4Name))
                {
                    data += F4Name + ";";
                }



                if (!string.IsNullOrEmpty(F5Logo))
                {
                    data += F5Logo + "*";
                }
                if (!string.IsNullOrEmpty(F5Num))
                {
                    data += F5Num + "*";
                }
                if (!string.IsNullOrEmpty(F5Name))
                {
                    data += F5Name + ";";
                }


                if (!string.IsNullOrEmpty(F6Logo))
                {
                    data += F6Logo + "*";
                }
                if (!string.IsNullOrEmpty(F6Num))
                {
                    data += F6Num + "*";
                }
                if (!string.IsNullOrEmpty(F6Name))
                {
                    data += F6Name + ";";
                }


                if (!string.IsNullOrEmpty(F7Logo))
                {
                    data += F7Logo + "*";
                }
                if (!string.IsNullOrEmpty(F7Num))
                {
                    data += F7Num + "*";
                }
                if (!string.IsNullOrEmpty(F7Name))
                {
                    data += F7Name + ";";
                }


                if (!string.IsNullOrEmpty(F8Logo))
                {
                    data += F8Logo + "*";
                }
                if (!string.IsNullOrEmpty(F8Num))
                {
                    data += F8Num + "*";
                }
                if (!string.IsNullOrEmpty(F8Name))
                {
                    data += F8Name + ";";
                }


                if (!string.IsNullOrEmpty(F9Logo))
                {
                    data += F9Logo + "*";
                }
                if (!string.IsNullOrEmpty(F9Num))
                {
                    data += F9Num + "*";
                }
                if (!string.IsNullOrEmpty(F9Name))
                {
                    data += F9Name + ";";
                }


                if (!string.IsNullOrEmpty(F10Logo))
                {
                    data += F10Logo + "*";
                }
                if (!string.IsNullOrEmpty(F10Num))
                {
                    data += F10Num + "*";
                }
                if (!string.IsNullOrEmpty(F10Name))
                {
                    data += F10Name + ";";
                }

                if (!string.IsNullOrEmpty(F11Logo))
                {
                    data += F11Logo + "*";
                }
                if (!string.IsNullOrEmpty(F11Num))
                {
                    data += F11Num + "*";
                }
                if (!string.IsNullOrEmpty(F11Name))
                {
                    data += F11Name + ";";
                }


                #endregion

                #region 处理第七行信息

                if (!string.IsNullOrEmpty(G1Logo))
                {
                    data += G1Logo + "*";
                }
                if (!string.IsNullOrEmpty(G1Num))
                {
                    data += G1Num + "*";
                }
                if (!string.IsNullOrEmpty(G1Name))
                {
                    data += G1Name + ";";
                }



                if (!string.IsNullOrEmpty(G2Logo))
                {
                    data += G2Logo + "*";
                }
                if (!string.IsNullOrEmpty(G2Num))
                {
                    data += G2Num + "*";
                }
                if (!string.IsNullOrEmpty(G2Name))
                {
                    data += G2Name + ";";
                }


                if (!string.IsNullOrEmpty(G3Logo))
                {
                    data += G3Logo + "*";
                }
                if (!string.IsNullOrEmpty(G3Num))
                {
                    data += G3Num + "*";
                }
                if (!string.IsNullOrEmpty(G3Name))
                {
                    data += G3Name + ";";
                }



                if (!string.IsNullOrEmpty(G4Logo))
                {
                    data += G4Logo + "*";
                }
                if (!string.IsNullOrEmpty(G4Num))
                {
                    data += G4Num + "*";
                }
                if (!string.IsNullOrEmpty(G4Name))
                {
                    data += G4Name + ";";
                }



                if (!string.IsNullOrEmpty(G5Logo))
                {
                    data += G5Logo + "*";
                }
                if (!string.IsNullOrEmpty(G5Num))
                {
                    data += G5Num + "*";
                }
                if (!string.IsNullOrEmpty(G5Name))
                {
                    data += G5Name + ";";
                }


                if (!string.IsNullOrEmpty(G6Logo))
                {
                    data += G6Logo + "*";
                }
                if (!string.IsNullOrEmpty(G6Num))
                {
                    data += G6Num + "*";
                }
                if (!string.IsNullOrEmpty(G6Name))
                {
                    data += G6Name + ";";
                }


                if (!string.IsNullOrEmpty(G7Logo))
                {
                    data += G7Logo + "*";
                }
                if (!string.IsNullOrEmpty(G7Num))
                {
                    data += G7Num + "*";
                }
                if (!string.IsNullOrEmpty(G7Name))
                {
                    data += G7Name + ";";
                }


                if (!string.IsNullOrEmpty(G8Logo))
                {
                    data += G8Logo + "*";
                }
                if (!string.IsNullOrEmpty(G8Num))
                {
                    data += G8Num + "*";
                }
                if (!string.IsNullOrEmpty(G8Name))
                {
                    data += G8Name + ";";
                }


                if (!string.IsNullOrEmpty(G9Logo))
                {
                    data += G9Logo + "*";
                }
                if (!string.IsNullOrEmpty(G9Num))
                {
                    data += G9Num + "*";
                }
                if (!string.IsNullOrEmpty(G9Name))
                {
                    data += G9Name + ";";
                }


                if (!string.IsNullOrEmpty(G10Logo))
                {
                    data += G10Logo + "*";
                }
                if (!string.IsNullOrEmpty(G10Num))
                {
                    data += G10Num + "*";
                }
                if (!string.IsNullOrEmpty(G10Name))
                {
                    data += G10Name + ";";
                }

                if (!string.IsNullOrEmpty(G11Logo))
                {
                    data += G11Logo + "*";
                }
                if (!string.IsNullOrEmpty(G11Num))
                {
                    data += G11Num + "*";
                }
                if (!string.IsNullOrEmpty(G11Name))
                {
                    data += G11Name + ";";
                }


                #endregion

                #region 处理第八行信息

                if (!string.IsNullOrEmpty(H1Logo))
                {
                    data += H1Logo + "*";
                }
                if (!string.IsNullOrEmpty(H1Num))
                {
                    data += H1Num + "*";
                }
                if (!string.IsNullOrEmpty(H1Name))
                {
                    data += H1Name + ";";
                }



                if (!string.IsNullOrEmpty(H2Logo))
                {
                    data += H2Logo + "*";
                }
                if (!string.IsNullOrEmpty(H2Num))
                {
                    data += H2Num + "*";
                }
                if (!string.IsNullOrEmpty(H2Name))
                {
                    data += H2Name + ";";
                }


                if (!string.IsNullOrEmpty(H3Logo))
                {
                    data += H3Logo + "*";
                }
                if (!string.IsNullOrEmpty(H3Num))
                {
                    data += H3Num + "*";
                }
                if (!string.IsNullOrEmpty(H3Name))
                {
                    data += H3Name + ";";
                }



                if (!string.IsNullOrEmpty(H4Logo))
                {
                    data += H4Logo + "*";
                }
                if (!string.IsNullOrEmpty(H4Num))
                {
                    data += H4Num + "*";
                }
                if (!string.IsNullOrEmpty(H4Name))
                {
                    data += H4Name + ";";
                }



                if (!string.IsNullOrEmpty(H5Logo))
                {
                    data += H5Logo + "*";
                }
                if (!string.IsNullOrEmpty(H5Num))
                {
                    data += H5Num + "*";
                }
                if (!string.IsNullOrEmpty(H5Name))
                {
                    data += H5Name + ";";
                }


                if (!string.IsNullOrEmpty(H6Logo))
                {
                    data += H6Logo + "*";
                }
                if (!string.IsNullOrEmpty(H6Num))
                {
                    data += H6Num + "*";
                }
                if (!string.IsNullOrEmpty(H6Name))
                {
                    data += H6Name + ";";
                }


                if (!string.IsNullOrEmpty(H7Logo))
                {
                    data += H7Logo + "*";
                }
                if (!string.IsNullOrEmpty(H7Num))
                {
                    data += H7Num + "*";
                }
                if (!string.IsNullOrEmpty(H7Name))
                {
                    data += H7Name + ";";
                }


                if (!string.IsNullOrEmpty(H8Logo))
                {
                    data += H8Logo + "*";
                }
                if (!string.IsNullOrEmpty(H8Num))
                {
                    data += H8Num + "*";
                }
                if (!string.IsNullOrEmpty(H8Name))
                {
                    data += H8Name + ";";
                }


                if (!string.IsNullOrEmpty(H9Logo))
                {
                    data += H9Logo + "*";
                }
                if (!string.IsNullOrEmpty(H9Num))
                {
                    data += H9Num + "*";
                }
                if (!string.IsNullOrEmpty(H9Name))
                {
                    data += H9Name + ";";
                }


                if (!string.IsNullOrEmpty(H10Logo))
                {
                    data += H10Logo + "*";
                }
                if (!string.IsNullOrEmpty(H10Num))
                {
                    data += H10Num + "*";
                }
                if (!string.IsNullOrEmpty(H10Name))
                {
                    data += H10Name + ";";
                }

                if (!string.IsNullOrEmpty(H11Logo))
                {
                    data += H11Logo + "*";
                }
                if (!string.IsNullOrEmpty(H11Num))
                {
                    data += H11Num + "*";
                }
                if (!string.IsNullOrEmpty(H11Name))
                {
                    data += H11Name + ";";
                }


                #endregion

                #region 处理第九行信息

                if (!string.IsNullOrEmpty(I1Logo))
                {
                    data += I1Logo + "*";
                }
                if (!string.IsNullOrEmpty(I1Num))
                {
                    data += I1Num + "*";
                }
                if (!string.IsNullOrEmpty(I1Name))
                {
                    data += I1Name + ";";
                }



                if (!string.IsNullOrEmpty(I2Logo))
                {
                    data += I2Logo + "*";
                }
                if (!string.IsNullOrEmpty(I2Num))
                {
                    data += I2Num + "*";
                }
                if (!string.IsNullOrEmpty(I2Name))
                {
                    data += I2Name + ";";
                }


                if (!string.IsNullOrEmpty(I3Logo))
                {
                    data += I3Logo + "*";
                }
                if (!string.IsNullOrEmpty(I3Num))
                {
                    data += I3Num + "*";
                }
                if (!string.IsNullOrEmpty(I3Name))
                {
                    data += I3Name + ";";
                }



                if (!string.IsNullOrEmpty(I4Logo))
                {
                    data += I4Logo + "*";
                }
                if (!string.IsNullOrEmpty(I4Num))
                {
                    data += I4Num + "*";
                }
                if (!string.IsNullOrEmpty(I4Name))
                {
                    data += I4Name + ";";
                }



                if (!string.IsNullOrEmpty(I5Logo))
                {
                    data += I5Logo + "*";
                }
                if (!string.IsNullOrEmpty(I5Num))
                {
                    data += I5Num + "*";
                }
                if (!string.IsNullOrEmpty(I5Name))
                {
                    data += I5Name + ";";
                }


                if (!string.IsNullOrEmpty(I6Logo))
                {
                    data += I6Logo + "*";
                }
                if (!string.IsNullOrEmpty(I6Num))
                {
                    data += I6Num + "*";
                }
                if (!string.IsNullOrEmpty(I6Name))
                {
                    data += I6Name + ";";
                }


                if (!string.IsNullOrEmpty(I7Logo))
                {
                    data += I7Logo + "*";
                }
                if (!string.IsNullOrEmpty(I7Num))
                {
                    data += I7Num + "*";
                }
                if (!string.IsNullOrEmpty(I7Name))
                {
                    data += I7Name + ";";
                }


                if (!string.IsNullOrEmpty(I8Logo))
                {
                    data += I8Logo + "*";
                }
                if (!string.IsNullOrEmpty(I8Num))
                {
                    data += I8Num + "*";
                }
                if (!string.IsNullOrEmpty(I8Name))
                {
                    data += I8Name + ";";
                }


                if (!string.IsNullOrEmpty(I9Logo))
                {
                    data += I9Logo + "*";
                }
                if (!string.IsNullOrEmpty(I9Num))
                {
                    data += I9Num + "*";
                }
                if (!string.IsNullOrEmpty(I9Name))
                {
                    data += I9Name + ";";
                }


                if (!string.IsNullOrEmpty(I10Logo))
                {
                    data += I10Logo + "*";
                }
                if (!string.IsNullOrEmpty(I10Num))
                {
                    data += I10Num + "*";
                }
                if (!string.IsNullOrEmpty(I10Name))
                {
                    data += I10Name + ";";
                }

                if (!string.IsNullOrEmpty(I11Logo))
                {
                    data += I11Logo + "*";
                }
                if (!string.IsNullOrEmpty(I11Num))
                {
                    data += I11Num + "*";
                }
                if (!string.IsNullOrEmpty(I11Name))
                {
                    data += I11Name + ";";
                }


                #endregion

                #region 处理第十行信息

                if (!string.IsNullOrEmpty(J1Logo))
                {
                    data += J1Logo + "*";
                }
                if (!string.IsNullOrEmpty(J1Num))
                {
                    data += J1Num + "*";
                }
                if (!string.IsNullOrEmpty(J1Name))
                {
                    data += J1Name + ";";
                }



                if (!string.IsNullOrEmpty(J2Logo))
                {
                    data += J2Logo + "*";
                }
                if (!string.IsNullOrEmpty(J2Num))
                {
                    data += J2Num + "*";
                }
                if (!string.IsNullOrEmpty(J2Name))
                {
                    data += J2Name + ";";
                }


                if (!string.IsNullOrEmpty(J3Logo))
                {
                    data += J3Logo + "*";
                }
                if (!string.IsNullOrEmpty(J3Num))
                {
                    data += J3Num + "*";
                }
                if (!string.IsNullOrEmpty(J3Name))
                {
                    data += J3Name + ";";
                }



                if (!string.IsNullOrEmpty(J4Logo))
                {
                    data += J4Logo + "*";
                }
                if (!string.IsNullOrEmpty(J4Num))
                {
                    data += J4Num + "*";
                }
                if (!string.IsNullOrEmpty(J4Name))
                {
                    data += J4Name + ";";
                }



                if (!string.IsNullOrEmpty(J5Logo))
                {
                    data += J5Logo + "*";
                }
                if (!string.IsNullOrEmpty(J5Num))
                {
                    data += J5Num + "*";
                }
                if (!string.IsNullOrEmpty(J5Name))
                {
                    data += J5Name + ";";
                }


                if (!string.IsNullOrEmpty(J6Logo))
                {
                    data += J6Logo + "*";
                }
                if (!string.IsNullOrEmpty(J6Num))
                {
                    data += J6Num + "*";
                }
                if (!string.IsNullOrEmpty(J6Name))
                {
                    data += J6Name + ";";
                }


                if (!string.IsNullOrEmpty(J7Logo))
                {
                    data += J7Logo + "*";
                }
                if (!string.IsNullOrEmpty(J7Num))
                {
                    data += J7Num + "*";
                }
                if (!string.IsNullOrEmpty(J7Name))
                {
                    data += J7Name + ";";
                }


                if (!string.IsNullOrEmpty(J8Logo))
                {
                    data += J8Logo + "*";
                }
                if (!string.IsNullOrEmpty(J8Num))
                {
                    data += J8Num + "*";
                }
                if (!string.IsNullOrEmpty(J8Name))
                {
                    data += J8Name + ";";
                }


                if (!string.IsNullOrEmpty(J9Logo))
                {
                    data += J9Logo + "*";
                }
                if (!string.IsNullOrEmpty(J9Num))
                {
                    data += J9Num + "*";
                }
                if (!string.IsNullOrEmpty(J9Name))
                {
                    data += J9Name + ";";
                }


                if (!string.IsNullOrEmpty(J10Logo))
                {
                    data += J10Logo + "*";
                }
                if (!string.IsNullOrEmpty(J10Num))
                {
                    data += J10Num + "*";
                }
                if (!string.IsNullOrEmpty(J10Name))
                {
                    data += J10Name + ";";
                }

                if (!string.IsNullOrEmpty(J11Logo))
                {
                    data += J11Logo + "*";
                }
                if (!string.IsNullOrEmpty(J11Num))
                {
                    data += J11Num + "*";
                }
                if (!string.IsNullOrEmpty(J11Name))
                {
                    data += J11Name + ";";
                }


                #endregion

                #region 处理第十一行信息

                if (!string.IsNullOrEmpty(K1Logo))
                {
                    data += K1Logo + "*";
                }
                if (!string.IsNullOrEmpty(K1Num))
                {
                    data += K1Num + "*";
                }
                if (!string.IsNullOrEmpty(K1Name))
                {
                    data += K1Name + ";";
                }



                if (!string.IsNullOrEmpty(K2Logo))
                {
                    data += K2Logo + "*";
                }
                if (!string.IsNullOrEmpty(K2Num))
                {
                    data += K2Num + "*";
                }
                if (!string.IsNullOrEmpty(K2Name))
                {
                    data += K2Name + ";";
                }


                if (!string.IsNullOrEmpty(K3Logo))
                {
                    data += K3Logo + "*";
                }
                if (!string.IsNullOrEmpty(K3Num))
                {
                    data += K3Num + "*";
                }
                if (!string.IsNullOrEmpty(K3Name))
                {
                    data += K3Name + ";";
                }



                if (!string.IsNullOrEmpty(K4Logo))
                {
                    data += K4Logo + "*";
                }
                if (!string.IsNullOrEmpty(K4Num))
                {
                    data += K4Num + "*";
                }
                if (!string.IsNullOrEmpty(K4Name))
                {
                    data += K4Name + ";";
                }



                if (!string.IsNullOrEmpty(K5Logo))
                {
                    data += K5Logo + "*";
                }
                if (!string.IsNullOrEmpty(K5Num))
                {
                    data += K5Num + "*";
                }
                if (!string.IsNullOrEmpty(K5Name))
                {
                    data += K5Name + ";";
                }


                if (!string.IsNullOrEmpty(K6Logo))
                {
                    data += K6Logo + "*";
                }
                if (!string.IsNullOrEmpty(K6Num))
                {
                    data += K6Num + "*";
                }
                if (!string.IsNullOrEmpty(K6Name))
                {
                    data += K6Name + ";";
                }


                if (!string.IsNullOrEmpty(K7Logo))
                {
                    data += K7Logo + "*";
                }
                if (!string.IsNullOrEmpty(K7Num))
                {
                    data += K7Num + "*";
                }
                if (!string.IsNullOrEmpty(K7Name))
                {
                    data += K7Name + ";";
                }


                if (!string.IsNullOrEmpty(K8Logo))
                {
                    data += K8Logo + "*";
                }
                if (!string.IsNullOrEmpty(K8Num))
                {
                    data += K8Num + "*";
                }
                if (!string.IsNullOrEmpty(K8Name))
                {
                    data += K8Name + ";";
                }


                if (!string.IsNullOrEmpty(K9Logo))
                {
                    data += K9Logo + "*";
                }
                if (!string.IsNullOrEmpty(K9Num))
                {
                    data += K9Num + "*";
                }
                if (!string.IsNullOrEmpty(K9Name))
                {
                    data += K9Name + ";";
                }


                if (!string.IsNullOrEmpty(K10Logo))
                {
                    data += K10Logo + "*";
                }
                if (!string.IsNullOrEmpty(K10Num))
                {
                    data += K10Num + "*";
                }
                if (!string.IsNullOrEmpty(K10Name))
                {
                    data += K10Name + ";";
                }

                if (!string.IsNullOrEmpty(K11Logo))
                {
                    data += K11Logo + "*";
                }
                if (!string.IsNullOrEmpty(K11Num))
                {
                    data += K11Num + "*";
                }
                if (!string.IsNullOrEmpty(K11Name))
                {
                    data += K11Name + ";";
                }


                #endregion


                Log.Info("首发上版子数据：" + data);

                return data;
            
            }
            catch (Exception ex)
            {
                Log.Info("首发上版子数据：" + "");
                return "";
            }

        }

    }
}
