﻿using DevExpress.Xpf.Grid.GroupRowLayout;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;


namespace VIZ.TVP.WMCUP.Module
{

    /// <summary>
    /// 单球员数据统计
    /// </summary>
    public class FSinglePlayerViewModel : ViewModelBase
    {
        private static ILog Log = LogManager.GetLogger(typeof(FSinglePlayerViewModel));

        public static List<FSinglePlayerViewModel> FSinglePlayerInstance = new List<FSinglePlayerViewModel>();

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();



        public FSinglePlayerViewModel()
        {
            BtnCommand = new VCommand(BtnCmd);
            ChooseImageCmd = new VCommand(OpenLocalFile);

            matchStatsIds = new ObservableCollection<int>()
            {
                3,
                4,
                5,
                6
            };

            PromptCommand = new VCommand(this.PromptCmd);
            //ScheduleID = DateHeaderViewModel.ScheduleID;
            //Matchtypeid = DateHeaderViewModel.Matchtypeid;

            homeTeamId = DateHeaderViewModel.HomeTeamId;
            visitTeamId = DateHeaderViewModel.VisitTeamId;
            homeNationTeam = DateHeaderViewModel.HomeNationName;
            awayNationTeam = DateHeaderViewModel.VisitingNationName;

            matchId = DateHeaderViewModel.MatchId;

            TeamItems = new ObservableCollection<string>();

            if (!string.IsNullOrEmpty(DateHeaderViewModel.HomeTeamName)&&!string.IsNullOrEmpty(DateHeaderViewModel.VisitingTeamName))
            {
                TeamItems.Add(DateHeaderViewModel.HomeTeamName);
                TeamItems.Add(DateHeaderViewModel.VisitingTeamName);
                SelectedIndex = 0;
            }


            SetTeamData();
        }





        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";


        public string homeTeamId = "";

        public string visitTeamId = "";

        //创建【球队】数据对比时的字典---主队球员数据与对比项的一一对应【主队-例如:得分--读取接口得分数据】
       // public Dictionary<string, string> HomeTeamCompareOptionDictionary = new Dictionary<string, string>();
        //创建【球队】数据对比时的字典---客队球员数据与对比项的一一对应【客队队-例如:得分--读取接口得分数据】
       // public Dictionary<string, string> VisitTeamCompareOptionDictionary = new Dictionary<string, string>();

        //        public Dictionary<string, Dictionary<string, string>> CNAliasVisitSportsDictionary
        //= new Dictionary<string, Dictionary<string, string>>();

        ///// <summary>
        ///// 球员赛季数据
        ///// </summary>
        //public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        ///// <summary>
        ///// 队伍赛程信息
        ///// </summary>
        //public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        ///// <summary>
        ///// 实时直播数据
        ///// </summary>
        //public OnAirDataModel onAirDataModel = new OnAirDataModel();


        /// <summary>
        /// 主队球员信息全部
        /// </summary>
       // public TeamStats teamHomeStats = new TeamStats();

        public SingleTeamPlayers homeTeamPlayer = new SingleTeamPlayers();

        /// <summary>
        /// 客队队伍统计得分
        /// </summary>
        //public TeamStats teamVisitStats = new TeamStats();

        
        // 客队球员信息全部
        public SingleTeamPlayers visitTeamPlayer = new SingleTeamPlayers();


        /// <summary>
        /// 技术统计项
        /// </summary>
        private int matchStatsId = 6;

        public int MatchStatsId
        {
            get { return matchStatsId; }

            set
            {

                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));


                if (matchStatsId == 3)
                {

                    IsCheckVisible3 = Visibility.Hidden;
                    HScoreVisible3 = Visibility.Hidden;
                    HSeasonScoreVisible3 = Visibility.Hidden;
                    TechStatsVisible3 = Visibility.Hidden;
                    AScoreVisible3 = Visibility.Hidden;
                    ASeasonScoreVisible3 = Visibility.Hidden;


                    IsCheckVisible4 = Visibility.Hidden;
                    HScoreVisible4 = Visibility.Hidden;
                    HSeasonScoreVisible4 = Visibility.Hidden;
                    TechStatsVisible4 = Visibility.Hidden;
                    AScoreVisible4 = Visibility.Hidden;
                    ASeasonScoreVisible4 = Visibility.Hidden;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                }


                if (matchStatsId == 4)
                {

                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;



                    IsCheckVisible4 = Visibility.Hidden;
                    HScoreVisible4 = Visibility.Hidden;
                    HSeasonScoreVisible4 = Visibility.Hidden;
                    TechStatsVisible4 = Visibility.Hidden;
                    AScoreVisible4 = Visibility.Hidden;
                    ASeasonScoreVisible4 = Visibility.Hidden;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                    //IsCheckVisible6 = Visibility.Hidden;
                    //HScoreVisible6 = Visibility.Hidden;
                    //HSeasonScoreVisible6 = Visibility.Hidden;
                    //TechStatsVisible6 = Visibility.Hidden;
                    //AScoreVisible6 = Visibility.Hidden;
                    //ASeasonScoreVisible6 = Visibility.Hidden;


                }
                else if (matchStatsId == 5)
                {

                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;

                    IsCheckVisible4 = Visibility.Visible;
                    HScoreVisible4 = Visibility.Visible;
                    HSeasonScoreVisible4 = Visibility.Visible;
                    TechStatsVisible4 = Visibility.Visible;
                    AScoreVisible4 = Visibility.Visible;
                    ASeasonScoreVisible4 = Visibility.Visible;


                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                    //IsCheckVisible6 = Visibility.Hidden;
                    //HScoreVisible6 = Visibility.Hidden;
                    //HSeasonScoreVisible6 = Visibility.Hidden;
                    //TechStatsVisible6 = Visibility.Hidden;
                    //AScoreVisible6 = Visibility.Hidden;
                    //ASeasonScoreVisible6 = Visibility.Hidden;

                }
                else if (matchStatsId == 6)
                {


                    IsCheckVisible3 = Visibility.Visible;
                    HScoreVisible3 = Visibility.Visible;
                    HSeasonScoreVisible3 = Visibility.Visible;
                    TechStatsVisible3 = Visibility.Visible;
                    AScoreVisible3 = Visibility.Visible;
                    ASeasonScoreVisible3 = Visibility.Visible;


                    IsCheckVisible4 = Visibility.Visible;
                    HScoreVisible4 = Visibility.Visible;
                    HSeasonScoreVisible4 = Visibility.Visible;
                    TechStatsVisible4 = Visibility.Visible;
                    AScoreVisible4 = Visibility.Visible;
                    ASeasonScoreVisible4 = Visibility.Visible;




                    IsCheckVisible5 = Visibility.Visible;
                    HScoreVisible5 = Visibility.Visible;
                    HSeasonScoreVisible5 = Visibility.Visible;
                    TechStatsVisible5 = Visibility.Visible;
                    AScoreVisible5 = Visibility.Visible;
                    ASeasonScoreVisible5 = Visibility.Visible;

                    //IsCheckVisible6 = Visibility.Visible;
                    //HScoreVisible6 = Visibility.Visible;
                    //HSeasonScoreVisible6 = Visibility.Visible;
                    //TechStatsVisible6 = Visibility.Visible;
                    //AScoreVisible6 = Visibility.Visible;
                    //ASeasonScoreVisible6 = Visibility.Visible;
                }

                //NewSetHData(0);
                NewSetAData(0);

            }
        }

        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }

        //private string homeTeam;

        //public string HomeTeam
        //{
        //    get { return homeTeam; }
        //    set { homeTeam = value; this.RaisePropertyChanged(nameof(HomeTeam)); }
        //}

        //// 主队国旗
        public string homeNationTeam;


        //private string awayTeam;

        //public string AwayTeam
        //{
        //    get { return awayTeam; }

        //    set { awayTeam = value; this.RaisePropertyChanged(nameof(AwayTeam)); }
        //}

        public string awayNationTeam;


        public string nationTeam;

        public string matchId;

        private string title = "数据信息";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }



        /// <summary>
        /// 队伍信息绑定
        /// </summary>
        private ObservableCollection<string> teamItems;

        public ObservableCollection<string> TeamItems
        {
            get { return teamItems; }
            set { teamItems = value; this.RaisePropertyChanged(nameof(TeamItems)); }
        }

        private string selectTeamItem;

        public string SelectTeamItem
        {
            get { return selectTeamItem; }
            set
            {
                selectTeamItem = value;
                this.RaisePropertyChanged(nameof(SelectTeamItem));

            }
        }



        /// <summary>
        /// 球员图片
        /// </summary>

        private ImageSource playerLogo;

        public ImageSource PlayerLogo
        {
            get { return playerLogo; }
            set
            {
                playerLogo = value; this.RaisePropertyChanged(nameof(PlayerLogo));
            }
        }



        public ObservableCollection<string> playerItems;

        public ObservableCollection<string> PlayerItems
        {
            get { return playerItems; }

            set { playerItems = value; this.RaisePropertyChanged(nameof(PlayerItems)); }
        }

        private string selectPlayer;

        public string SelectPlayer
        {
            get { return selectPlayer; }
            set
            {
                selectPlayer = value;
                this.RaisePropertyChanged(nameof(SelectPlayer));

                if (selectPlayer == null)
                    return;

                PlayerName = selectPlayer;


                SetPlayerStatic();

                string baesePath = AppSetup_InitLiteDB.HttpUrlConfigEntity.PlayersLogo;

                //if (selectedIndex == 0)
                //{
                //    if (HNameNums.ContainsKey(selectPlayer))
                //    {
                //        PlayNum = HNameNums[selectPlayer];

                //        //if (TeamItems[selectedIndex] == "北京控股666")
                //        //{
                if (File.Exists(string.Format("{0}\\{1}\\{2}.png", baesePath, nationTeam, PlayerName)))
                {
                    PlayerLogo = new BitmapImage(new Uri(string.Format("{0}\\{1}\\{2}.png", baesePath, nationTeam, PlayerName)));
                }

                //        //}
                //        //else
                //        //{
                //        //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])))
                //        //    {
                //        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                //        //    }

                //        //}

                //    }
                //}
                //else
                //{
                //    if (VNameNums.ContainsKey(selectPlayer))
                //    {
                //        PlayNum = VNameNums[selectPlayer];

                //        //if (TeamItems[selectedIndex] == "北京控股666")
                //        //{
                //        //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                //        //    {
                //        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));

                //        //    }
                //        //}
                //        //else
                //        //{
                //        //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])))
                //        //    {
                //        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                //        //    }

                //        //}

                //    }
                //}
                //SetData(0);


            }
        }


        private async void SetPlayerStatic()
        {

            string figureId = "";

            if (selectPlayer == null) return;
            if (SelectedIndex == 0)
            {
                if (HPlayer.ContainsKey(selectPlayer))
                {
                    PlayerNum = HPlayer[selectPlayer].Item2;
                    figureId= HPlayer[selectPlayer].Item1;  
                }
            }
            else if (SelectedIndex == 1)
            {
                if (APlayer.ContainsKey(selectPlayer))
                {
                    PlayerNum = APlayer[selectPlayer].Item2;
                    figureId = APlayer[selectPlayer].Item1;
                }
            }

            if (!string.IsNullOrEmpty(figureId))
            {

                VisitScoreDictionary.Clear();

                var singlePlayers = await JsonModel.PostSinglePlayerData_Path(figureId);

                if (singlePlayers==null||singlePlayers.playerStat == null) return;

                //homeNationTeam = singlePlayers.playerStat.nationName;

                foreach (var player in singlePlayers.playerStat.statistics)
                {
                    if(!VisitScoreDictionary.ContainsKey(player.name))
                    {
                        VisitScoreDictionary.Add(player.name,player.value);
                    }
                }
            }

            //设置球员信息
            NewSetAData(0);
        }




        /// <summary>
        /// 球队选中的数据
        /// </summary>
        private int selectedIndex;

        /// <summary>
        /// 0 是主队 1 是客队
        /// </summary>

        public int SelectedIndex
        {
            get { return selectedIndex; }
            set
            {
                selectedIndex = value;

                this.RaisePropertyChanged(nameof(SelectedIndex));

                //SetPlayer(selectedIndex);

                if(selectedIndex==0)
                {
                    nationTeam = homeNationTeam;
                }
                else if(selectedIndex==1)
                {
                    nationTeam = awayNationTeam;
                }

                SetPlayerItems();
            }
        }



        /// <summary>
        /// 球员图片名称
        /// </summary>

        private string  playerName;

        public string  PlayerName
        {
            get { return playerName; }
            set { playerName = value; this.RaisePropertyChanged(nameof(PlayerName)); }
        }

        /// <summary>
        ///球员名称
        /// </summary>

        private string playerNum;

        public string PlayerNum
        {
            get { return playerNum; }
            set { playerNum = value; this.RaisePropertyChanged(nameof(PlayerNum)); }
        }



        public VCommand BtnCommand { get; set; }


        public VCommand BtnCmdUpData { get; set; }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "单球员数据统计：" + PluginConstant.Operate_Message);
            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            //if (onAirDataModel != null)
            //{
            //    string onAirLastDate = $"直播接口更新时间：{onAirDataModel.LastPushDataDateTime}";
            //    vm.OnErrorLogMessage(onAirLastDate);
            //}

            //if (PlayerSeasonData != null)
            //{
            //    string playerSeasonLastDate = $"球员赛季接口更新时间：{PlayerSeasonData.LastPushDataDateTime}";
            //    vm.OnErrorLogMessage(playerSeasonLastDate);
            //}

            //if (TeamSeasonData != null)
            //{
            //    string teamSeasonLastDate = $"球队赛季接口更新时间:{TeamSeasonData.LastPushDataDateTime}";
            //    vm.OnErrorLogMessage(teamSeasonLastDate);
            //}

            if (homeTeamPlayer != null)
            {
                string teamSeasonLastDate = $"单球员统计接口更新时间:{homeTeamPlayer.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }


            if (visitTeamPlayer != null)
            {
                string teamSeasonLastDate = $"单球员统计接口更新时间:{visitTeamPlayer.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }

            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }




        #endregion
        public string CombineTeamComData()
        {
            try
            {
                string data = "";

                //if (matchStatsId != 0)
                //{
                //    data += matchStatsId.ToString().Replace(" ", "") + "*";
                //}
                //else
                //{
                //    data += "7*";
                //}
                data += title.ToString().Replace(" ", "") + "&";

                if (!string.IsNullOrEmpty(nationTeam))
                {
                    data += nationTeam.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                if (!string.IsNullOrEmpty(PlayerNum))
                {
                    data += PlayerNum.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }

                if (!string.IsNullOrEmpty(SelectPlayer))
                {
                    data += SelectPlayer.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }


                if (!string.IsNullOrEmpty(PlayerName))
                {
                    data += PlayerName.Replace(" ", "") + "#";
                }
                else
                {
                    data += "" + "#";
                }



                if (matchStatsId == 6)
                {

                    //if (!string.IsNullOrEmpty(HomeScore))
                    //{
                    //    data += HomeScore.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}


                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第二项


                    //if (!string.IsNullOrEmpty(HomeScore1))
                    //{
                    //    data += HomeScore1.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}


                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项


                    //if (!string.IsNullOrEmpty(HomeScore2))
                    //{
                    //    data += HomeScore2.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第四项


                    //if (!string.IsNullOrEmpty(HomeScore3))
                    //{
                    //    data += HomeScore3.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第五项

                    //if (!string.IsNullOrEmpty(HomeScore4))
                    //{
                    //    data += HomeScore4.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}




                    data += selectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore4))
                    {
                        data += AwayScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第六项

                    //if (!string.IsNullOrEmpty(HomeScore5))
                    //{
                    //    data += HomeScore5.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats5.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore5))
                    {
                        data += AwayScore5.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                }
                else if (matchStatsId == 5)
                {
                    //第一项

                    //if (!string.IsNullOrEmpty(HomeScore))
                    //{
                    //    data += HomeScore.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    //if (!string.IsNullOrEmpty(HomeScore1))
                    //{
                    //    data += HomeScore1.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第三项


                    //if (!string.IsNullOrEmpty(HomeScore2))
                    //{
                    //    data += HomeScore2.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第四项


                    //if (!string.IsNullOrEmpty(HomeScore3))
                    //{
                    //    data += HomeScore3.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第五项

                    //if (!string.IsNullOrEmpty(HomeScore4))
                    //{
                    //    data += HomeScore4.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}


                    data += selectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore4))
                    {
                        data += AwayScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }

                }

                else if (matchStatsId == 4)
                {
                    //第一项

                    //if (!string.IsNullOrEmpty(HomeScore))
                    //{
                    //    data += HomeScore.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    //if (!string.IsNullOrEmpty(HomeScore1))
                    //{
                    //    data += HomeScore1.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第三项


                    //if (!string.IsNullOrEmpty(HomeScore2))
                    //{
                    //    data += HomeScore2.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第四项


                    //if (!string.IsNullOrEmpty(HomeScore3))
                    //{
                    //    data += HomeScore3.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore3))
                    {
                        data += AwayScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                }
                else if (matchStatsId == 3)
                {
                    //第一项

                    //if (!string.IsNullOrEmpty(HomeScore))
                    //{
                    //    data += HomeScore.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}




                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore))
                    {
                        data += AwayScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }




                    //第二项

                    //if (!string.IsNullOrEmpty(HomeScore1))
                    //{
                    //    data += HomeScore1.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore1))
                    {
                        data += AwayScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项


                    //if (!string.IsNullOrEmpty(HomeScore2))
                    //{
                    //    data += HomeScore2.Replace(" ", "") + "*";
                    //}
                    //else
                    //{
                    //    data += "" + "*";
                    //}



                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AwayScore2))
                    {
                        data += AwayScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                }



                Log.Info("单球员===>发送的数据命令到viz:"+data);
                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }



        #region ChooseImageCmd -- 打开图片文件命令

        /// <summary>
        /// 打开本地文件命令
        /// </summary>
        public VCommand ChooseImageCmd { get; set; }

        /// <summary>
        /// 打开本地文件
        /// </summary>
        private void OpenLocalFile()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Filter = "Image|*.png;";//*.jpg;*.jpeg;*.bmp;
            ofd.Multiselect = false;
            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            PlayerLogo = new BitmapImage(new Uri((ofd.FileName)));
            //this.PlayerName = ofd.FileName.Replace(@"\", @"\\");

            //string name = System.IO.Path.GetFileName(ofd.FileName);
            PlayerName = Path.GetFileNameWithoutExtension(ofd.FileName);
        }

        #endregion



        public void BtnCmd()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足球队数据统计：" + PluginConstant.Operate_Message);

            //onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            //if (onAirDataModel == null) return;
            //Utils.NewSetHomeTeamDictionary(this);
            //Utils.NewSetVisitTeamDictionary(this);
            //Utils.NewSetHData(this, 0);
            //Utils.NewSetAData(this, 0);

            // SetTeamData();

            SetPlayerStatic();


        }




        public Dictionary<string, Tuple<string,string>> HPlayer = new Dictionary<string, Tuple<string,string>>();

        public Dictionary<string, Tuple<string,string>> APlayer = new Dictionary<string, Tuple<string,string>>();

        public async void SetTeamData()
        {
            HPlayer.Clear();
            APlayer.Clear();

            homeTeamPlayer = await JsonModel.PostTeamPlayerData_Path(homeTeamId,matchId,"");
            if (homeTeamPlayer == null) return;


            foreach(var hPlayer in homeTeamPlayer.matchTeamPlayers)
            {
                if(!HPlayer.ContainsKey(hPlayer.figureName)&&!string.IsNullOrEmpty(hPlayer.figureName))
                {
                    HPlayer.Add(hPlayer.figureName,new Tuple<string, string>(hPlayer.figureId,hPlayer.playerNum));
                }
            }

            visitTeamPlayer = await JsonModel.PostTeamPlayerData_Path(visitTeamId,matchId, "");
            if (visitTeamPlayer == null) return;


            foreach(var aPlayer in visitTeamPlayer.matchTeamPlayers)
            {
                if(!APlayer.ContainsKey(aPlayer.figureName)&&!string.IsNullOrEmpty(aPlayer.figureName))
                {
                    APlayer.Add(aPlayer.figureName,new Tuple<string, string>(aPlayer.figureId,aPlayer.playerNum));
                }
            }

            SetPlayerItems();

            //HomeTeam = teamHomeStats.teamStat.FirstOrDefault().teamName;

            //AwayTeam = teamVisitStats.teamStat.FirstOrDefault().teamName;

            //homeNationTeam = teamHomeStats.teamStat.FirstOrDefault().nationName;
            //awayNationTeam = teamVisitStats.teamStat.FirstOrDefault().nationName;

            //SetVisitHomeDictionary();
            //SetTeamHomeDictionary();

            //if (SelectMatchItems == null) return;
            //ScheduleID = SetMatchDict[SelectMatchItems];

            //Log.Error(string.Format("teamStatsViewModel:{0}", ScheduleID));
            //if (string.IsNullOrEmpty(ScheduleID)) return;
            //onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            //ClearData();
            //if (onAirDataModel == null) return;
            //if (onAirDataModel != null)
            //{

            //    if (onAirDataModel.liveTeamInfo.StatusCNName == "")
            //    {
            //        MatchStatus = "未开始";
            //    }
            //    else if (onAirDataModel.liveTeamInfo.StatusCNName != "")
            //    {
            //        MatchStatus = onAirDataModel.liveTeamInfo.StatusCNName;
            //    }
            //}
            //else
            //{
            //    MatchStatus = "未开始";
            //}

            //PlayerCompareViewModel.HName = vm.onAirDataModel.liveTeamInfo.HomeTeamCNAlias;
            //PlayerCompareViewModel.AName = vm.onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;

            //HomeTeam = onAirDataModel.liveTeamInfo.HomeTeamCNAlias;


            //string baesePath = AppDomain.CurrentDomain.BaseDirectory;
            //if (!string.IsNullOrEmpty(HomeTeam))
            //{
            //    if (HomeTeam == "北京控股666")
            //    {
            //        if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
            //        {
            //            HomeTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
            //        }

            //    }
            //    else
            //    {
            //        if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HomeTeam)))
            //        {
            //            HomeTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HomeTeam)));
            //        }

            //    }

            //}

            // AwayTeam = onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;

            //if (!string.IsNullOrEmpty(AwayTeam))
            //{
            //    if (AwayTeam == "北京控股666")
            //    {
            //        if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
            //        {
            //            AwayTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
            //        }

            //    }
            //    else
            //    {
            //        if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AwayTeam)))
            //        {
            //            AwayTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AwayTeam)));
            //        } 
            //    }
            //}

            //TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);

            //SetTeamSeasonDictionary();

            //Utils.NewSetHomeTeamDictionary(this);
            //Utils.NewSetVisitTeamDictionary(this);

           // NewSetHData(0);
            NewSetAData(0);
        }


        private void SetPlayerItems()
        {
            PlayerItems = new ObservableCollection<string>();

            if (SelectedIndex == 0)
            {
                PlayerItems = HPlayer.Keys.ToObservableCollection();
            }
            else if(SelectedIndex == 1)
            {
                PlayerItems = APlayer.Keys.ToObservableCollection();
            }
        }

        /// <summary>
        /// 设置主场数据
        /// </summary>
        /// <param name="index"></param>

        //public void NewSetHData(int index)
        //{
        //    if (HomeScoreDictionary.Count == 0) return;

        //    //if (teamStatsViewModel != null)
        //    //{
        //    //    if (teamStatsViewModel.HomeTeam == null || string.IsNullOrEmpty(teamStatsViewModel.HomeTeam)) return;
        //    //}

        //    if (index == 1)
        //    {
        //        //第一项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats))
        //        {
        //            HomeScore = HomeScoreDictionary[SelectTechStats];
        //        }
        //        else
        //        {
        //            HomeScore = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //if (teamStatsViewModel.HomeTeam == null) return;

        //        //if (HomeScoreDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //{
        //        ////    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //    if (HomeScoreDictionary.ContainsKey(SelectTechStats))
        //        //    {
        //        //        teamStatsViewModel.HSeasonScore = HomeScoreDictionary[.SelectTechStats];
        //        //    }
        //        //    else
        //        //    {
        //        //        teamStatsViewModel.HSeasonScore = "0";
        //        //    }
        //        //}
        //        //}
        //    }
        //    else if (index == 2)
        //    {


        //        //第二项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats1))
        //        {
        //            HomeScore1 = HomeScoreDictionary[SelectTechStats1];
        //        }
        //        else
        //        {
        //            HomeScore1 = "0";
        //        }

        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore1 = "0";
        //        //        }
        //        //    }
        //        //}
        //    }
        //    else if (index == 3)
        //    {
        //        //第三项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats2))
        //        {
        //            HomeScore2 = HomeScoreDictionary[SelectTechStats2];
        //        }
        //        else
        //        {
        //            HomeScore2 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore2 = "0";
        //        //        }
        //        //    }
        //        //}

        //    }
        //    else if (index == 4)
        //    {
        //        //第四项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats3))
        //        {
        //            HomeScore3 = HomeScoreDictionary[SelectTechStats3];
        //        }
        //        else
        //        {
        //            HomeScore3 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore3 = "0";
        //        //        }
        //        //    }
        //        //}

        //    }
        //    else if (index == 5)
        //    {

        //        //第五项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats3))
        //        {
        //            HomeScore4 = HomeScoreDictionary[SelectTechStats4];
        //        }
        //        else
        //        {
        //            HomeScore4 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore4 = "0";
        //        //        }
        //        //    }
        //        //}

        //    }
        //    else if (index == 6)
        //    {

        //        //第六项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats5))
        //        {
        //            HomeScore5 = HomeScoreDictionary[SelectTechStats5];
        //        }
        //        else
        //        {
        //            HomeScore5 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore5 = "0";
        //        //        }
        //        //    }
        //        //}

        //    }
        //    //else if (index == 7)
        //    //{
        //    //    //第七项

        //    //    if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats6))
        //    //    {
        //    //        teamStatsViewModel.HomeScore6 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats6];
        //    //    }
        //    //    else
        //    //    {
        //    //        teamStatsViewModel.HomeScore6 = "0";
        //    //    }
        //    //    if (teamStatsViewModel != null)
        //    //    {
        //    //        if (teamStatsViewModel.HomeTeam == null) return;

        //    //        if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //    //        {
        //    //            var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //    //            if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
        //    //            {
        //    //                teamStatsViewModel.HSeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
        //    //            }
        //    //            else
        //    //            {
        //    //                teamStatsViewModel.HSeasonScore6 = "0";
        //    //            }
        //    //        }
        //    //    }
        //    //}
        //    else
        //    {


        //        //第一项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats))
        //        {
        //            HomeScore = HomeScoreDictionary[SelectTechStats];
        //        }
        //        else
        //        {
        //            HomeScore = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore = teamSeasonData[teamStatsViewModel.SelectTechStats];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore = "0";
        //        //        }
        //        //    }
        //        //}



        //        //第二项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats1))
        //        {
        //            HomeScore1 = HomeScoreDictionary[SelectTechStats1];
        //        }
        //        else
        //        {
        //            HomeScore1 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore1 = "0";
        //        //        }
        //        //    }
        //        //}


        //        //第三项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats2))
        //        {
        //            HomeScore2 = HomeScoreDictionary[SelectTechStats2];
        //        }
        //        else
        //        {
        //            HomeScore2 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore2 = "0";
        //        //        }
        //        //    }
        //        //}


        //        //第四项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats3))
        //        {
        //            HomeScore3 = HomeScoreDictionary[SelectTechStats3];
        //        }
        //        else
        //        {
        //            HomeScore3 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore3 = "0";
        //        //        }
        //        //    }
        //        //}



        //        //第五项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats3))
        //        {
        //            HomeScore4 = HomeScoreDictionary[SelectTechStats4];
        //        }
        //        else
        //        {
        //            HomeScore4 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore4 = "0";
        //        //        }
        //        //    }
        //        //}


        //        //第六项

        //        if (HomeScoreDictionary.ContainsKey(SelectTechStats5))
        //        {
        //            HomeScore5 = HomeScoreDictionary[SelectTechStats5];
        //        }
        //        else
        //        {
        //            HomeScore5 = "0";
        //        }
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore5 = "0";
        //        //        }
        //        //    }
        //        //}

        //        //第七项

        //        //if (HomeScoreDictionary.ContainsKey(SelectTechStats6))
        //        //{
        //        //    HomeScore6 = HomeScoreDictionary[SelectTechStats6];
        //        //}
        //        //else
        //        //{
        //        //    HomeScore6 = "0";
        //        //}
        //        //if (teamStatsViewModel != null)
        //        //{
        //        //    if (teamStatsViewModel.HomeTeam == null) return;

        //        //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
        //        //    {
        //        //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
        //        //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
        //        //        }
        //        //        else
        //        //        {
        //        //            teamStatsViewModel.HSeasonScore6 = "0";
        //        //        }
        //        //    }
        //        //}
        //    }


        //}



        /// <summary>
        /// 设置客场信息
        /// </summary>
        /// <param name="teamStatsViewModel"></param>
        public void NewSetAData(int index)
        {

            if (VisitScoreDictionary.Count == 0) return;

            if (index == 1)
            {
                //第一项
                if (SelectTechStats!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats))
                {
                    AwayScore = VisitScoreDictionary[SelectTechStats];
                }
                else
                {
                    AwayScore = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats))
                //        {
                //            teamStatsViewModel.ASeasonScore = teamSeasonData[teamStatsViewModel.SelectTechStats];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore = "0";
                //        }

                //    }

                //}
            }
            else if (index == 2)
            {
                //第二项
                if (SelectTechStats1!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    AwayScore1 = VisitScoreDictionary[SelectTechStats1];
                }
                else
                {
                    AwayScore1 = "0";
                }

                //if (teamStatsViewModel != null)
                //{
                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
                //        {
                //            teamStatsViewModel.ASeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore1 = "0";
                //        }

                //    }
                //}
            }
            else if (index == 3)
            {

                //第三项
                if (SelectTechStats2!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    AwayScore2 = VisitScoreDictionary[SelectTechStats2];
                }
                else
                {
                    AwayScore2 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
                //        {
                //            teamStatsViewModel.ASeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore2 = "0";
                //        }

                //    }

                //}

            }
            else if (index == 4)
            {
                //第四项
                if (SelectTechStats3!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    AwayScore3 = VisitScoreDictionary[SelectTechStats3];
                }
                else
                {
                    AwayScore3 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
                //        {
                //            teamStatsViewModel.ASeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore3 = "0";
                //        }

                //    }

                //}

            }

            else if (index == 5)
            {
                //第五项
                if (SelectTechStats4!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats4))
                {
                    AwayScore4 = VisitScoreDictionary[SelectTechStats4];
                }
                else
                {
                    AwayScore4 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
                //        {
                //            teamStatsViewModel.ASeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore4 = "0";
                //        }

                //    }

                //}

            }
            else if (index == 6)
            {


                //第六项
                if (SelectTechStats5!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats5))
                {
                    AwayScore5 = VisitScoreDictionary[SelectTechStats5];
                }
                else
                {
                    AwayScore5 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
                //        {
                //            teamStatsViewModel.ASeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore5 = "0";
                //        }

                //    }

                //}
            }
            //else if (index == 7)
            //{
            //    //第七项
            //    if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats6))
            //    {
            //        teamStatsViewModel.AwayScore6 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats6];
            //    }
            //    else
            //    {
            //        teamStatsViewModel.AwayScore6 = "0";
            //    }

            //    if (teamStatsViewModel != null)
            //    {

            //        if (teamStatsViewModel.AwayTeam == null) return;
            //        if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
            //        {
            //            var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

            //            if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
            //            {
            //                teamStatsViewModel.ASeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
            //            }
            //            else
            //            {
            //                teamStatsViewModel.ASeasonScore6 = "0";
            //            }

            //        }

            //    }
            //}
            else
            {

                //第一项
                if (SelectTechStats!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats))
                {
                    AwayScore = VisitScoreDictionary[SelectTechStats];
                }
                else
                {
                    AwayScore = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats))
                //        {
                //            teamStatsViewModel.ASeasonScore = teamSeasonData[teamStatsViewModel.SelectTechStats];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore = "0";
                //        }

                //    }

                //}


                //第二项
                if (SelectTechStats1!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats1))
                {
                    AwayScore1 = VisitScoreDictionary[SelectTechStats1];
                }
                else
                {
                    AwayScore1 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
                //        {
                //            teamStatsViewModel.ASeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore1 = "0";
                //        }

                //    }

                //}


                //第三项
                if (SelectTechStats2!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats2))
                {
                    AwayScore2 = VisitScoreDictionary[SelectTechStats2];
                }
                else
                {
                    AwayScore2 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
                //        {
                //            teamStatsViewModel.ASeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore2 = "0";
                //        }

                //    }

                //}


                //第四项
                if (SelectTechStats3!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats3))
                {
                    AwayScore3 = VisitScoreDictionary[SelectTechStats3];
                }
                else
                {
                    AwayScore3 = "0";
                }

                //if (teamStatsViewModel != null)
                //{

                //    if (teamStatsViewModel.AwayTeam == null) return;
                //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                //    {
                //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
                //        {
                //            teamStatsViewModel.ASeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
                //        }
                //        else
                //        {
                //            teamStatsViewModel.ASeasonScore3 = "0";
                //        }

                //    }

            }



            //第五项
            if (SelectTechStats4!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats4))
            {
                AwayScore4 = VisitScoreDictionary[SelectTechStats4];
            }
            else
            {
                AwayScore4 = "0";
            }

            //if (teamStatsViewModel != null)
            //{

            //    if (teamStatsViewModel.AwayTeam == null) return;
            //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
            //    {
            //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

            //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
            //        {
            //            teamStatsViewModel.ASeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
            //        }
            //        else
            //        {
            //            teamStatsViewModel.ASeasonScore4 = "0";
            //        }

            //    }

            //}


            //第六项
            if (SelectTechStats5!=null&&VisitScoreDictionary.ContainsKey(SelectTechStats5))
            {
                AwayScore5 = VisitScoreDictionary[SelectTechStats5];
            }
            else
            {
                AwayScore5 = "0";
            }

            //if (teamStatsViewModel != null)
            //{

            //    if (teamStatsViewModel.AwayTeam == null) return;
            //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
            //    {
            //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

            //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
            //        {
            //            teamStatsViewModel.ASeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
            //        }
            //        else
            //        {
            //            teamStatsViewModel.ASeasonScore5 = "0";
            //        }

            //    }

            //}


            //第七项
            //if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats6))
            //{
            //    teamStatsViewModel.AwayScore6 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats6];
            //}
            //else
            //{
            //    teamStatsViewModel.AwayScore6 = "0";
            //}

            //if (teamStatsViewModel != null)
            //{

            //    if (teamStatsViewModel.AwayTeam == null) return;
            //    if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
            //    {
            //        var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

            //        if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
            //        {
            //            teamStatsViewModel.ASeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
            //        }
            //        else
            //        {
            //            teamStatsViewModel.ASeasonScore6 = "0";
            //        }

            //    }

            //}
            // }


        }



        private void ClearData()
        {

            //if (onAirDataModel != null) return;
            //HomeTeam = "";
            //AwayTeam = "";

            HomeScore = "";
            HSeasonScore = "";
            HomeScore1 = "";
            HSeasonScore1 = "";
            HomeScore2 = "";
            HSeasonScore2 = "";
            HomeScore3 = "";
            HSeasonScore3 = "";
            HomeScore4 = "";
            HSeasonScore4 = "";
            HomeScore5 = "";
            HSeasonScore5 = "";
            //HomeScore6 = "";
            //HSeasonScore6 = "";


            AwayScore = "";
            ASeasonScore = "";
            AwayScore1 = "";
            ASeasonScore1 = "";
            AwayScore2 = "";
            ASeasonScore2 = "";
            AwayScore3 = "";
            ASeasonScore3 = "";
            AwayScore4 = "";
            ASeasonScore4 = "";
            AwayScore5 = "";
            ASeasonScore5 = "";
            //AwayScore6 = "";
            //ASeasonScore6 = "";

        }


        public Dictionary<string, string> HomeScoreDictionary = new Dictionary<string, string>();


        /// <summary>
        /// 设置主队字典集合
        /// </summary>
        private void SetTeamHomeDictionary()
        {
            HomeScoreDictionary.Clear();
            //if (teamHomeStats == null || teamHomeStats.teamStat == null) return;
            //foreach (var teamSeasonData in teamHomeStats.teamStat.FirstOrDefault().statistics)
            //{
            //    if (!HomeScoreDictionary.ContainsKey(teamSeasonData.name))
            //    {
            //        HomeScoreDictionary.Add(teamSeasonData.name, teamSeasonData.value);
            //    }


            //    //Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

            //    //CompareItemToNumber.Add("得分", teamSeasonData.PointsAverage);
            //    //CompareItemToNumber.Add("篮板", teamSeasonData.ReboundsAverage);
            //    //CompareItemToNumber.Add("助攻", teamSeasonData.AssistsAverage);
            //    //CompareItemToNumber.Add("抢断", teamSeasonData.StealsAverage);//StealsAverage
            //    //CompareItemToNumber.Add("盖帽", teamSeasonData.BlockedAverage);
            //    //CompareItemToNumber.Add("失误", teamSeasonData.TurnoversAverage);
            //    //CompareItemToNumber.Add("犯规", teamSeasonData.PersonalFoulsAverage);
            //    //CompareItemToNumber.Add("罚球", teamSeasonData.FreeThrowsAverage.ToString());
            //    ////HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
            //    //CompareItemToNumber.Add("罚球命中率", (teamSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
            //    //CompareItemToNumber.Add("两分命中率", (teamSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");
            //    //CompareItemToNumber.Add("三分命中率", (teamSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
            //    //CompareItemToNumber.Add("投篮命中率", (teamSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
            //    //CompareItemToNumber.Add("篮下投篮命中率", (teamSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
            //    //CompareItemToNumber.Add("中距离投篮命中率", (teamSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");

            //    //if (!CNAliasVisitSportsDictionary.ContainsKey(teamSeasonData.TeamCNAlias))
            //    //{
            //    //    CNAliasVisitSportsDictionary.Add(teamSeasonData.TeamCNAlias, CompareItemToNumber);
            //    //}

            //}

        }


        public Dictionary<string, string> VisitScoreDictionary = new Dictionary<string, string>();


        //private void SetVisitHomeDictionary()
        //{

        //    VisitScoreDictionary.Clear();
        //    //if (teamVisitStats == null || teamVisitStats.teamStat == null) return;
        //    //foreach (var teamSeasonData in teamVisitStats.teamStat.FirstOrDefault().statistics)
        //    //{
        //    //    if (!VisitScoreDictionary.ContainsKey(teamSeasonData.name))
        //    //    {
        //    //        VisitScoreDictionary.Add(teamSeasonData.name, teamSeasonData.value);
        //    //    }

        //    //}
        //}




        public PageModel page = null;

        static ObservableCollection<string> listTechStats = new ObservableCollection<string>() { "出场次数", "进球", "黄牌", "红牌","助攻","控球率", "射门", "上次国家队进球", "犯规", "俱乐部", "年龄"};//"罚球",

        #region 第一项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight;

        public bool IsHeight
        {
            get { return isHeight; }
            set { isHeight = value; this.RaisePropertyChanged(nameof(IsHeight)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible;
        public Visibility IsCheckVisible
        {
            get { return isCheckVisible; }
            set { isCheckVisible = value; this.RaisePropertyChanged(nameof(IsCheckVisible)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore;

        public string HomeScore
        {
            get { return homeScore; }
            set { homeScore = value; this.RaisePropertyChanged(nameof(HomeScore)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible;

        public Visibility HScoreVisible
        {
            get { return hScoreVisible; }
            set { hScoreVisible = value; this.RaisePropertyChanged(nameof(hScoreVisible)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore;

        public string HSeasonScore
        {
            get { return hSeasonScore; }
            set { hSeasonScore = value; this.RaisePropertyChanged(nameof(HSeasonScore)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible;
        public Visibility HSeasonScoreVisible
        {
            get { return hSeasonScoreVisible; }
            set { hSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats = listTechStats;

        public ObservableCollection<string> TechStats
        {
            get { return techStats; }
            set { techStats = value; this.RaisePropertyChanged(nameof(TechStats)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats = "出场次数";

        public string SelectTechStats
        {
            get { return selectTechStats; }
            set
            {
                selectTechStats = value;
                this.RaisePropertyChanged(nameof(SelectTechStats));

                //NewSetHData(1);
                NewSetAData(1);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible;


        public Visibility TechStatsVisible
        {
            get { return techStatsVisible; }
            set { techStatsVisible = value; this.RaisePropertyChanged(nameof(TechStatsVisible)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore;

        public string AwayScore
        {
            get { return awayScore; }
            set { awayScore = value; this.RaisePropertyChanged(nameof(AwayScore)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible;

        public Visibility AScoreVisible
        {
            get { return aScoreVisible; }

            set { aScoreVisible = value; this.RaisePropertyChanged(nameof(AScoreVisible)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore;

        public string ASeasonScore
        {
            get { return aSeasonScore; }

            set { aSeasonScore = value; this.RaisePropertyChanged(nameof(ASeasonScore)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible;

        public Visibility ASeasonScoreVisible
        {
            get { return aSeasonScoreVisible; }
            set { aSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible)); }
        }

        #endregion


        #region 第二项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight1;

        public bool IsHeight1
        {
            get { return isHeight1; }
            set { isHeight1 = value; this.RaisePropertyChanged(nameof(IsHeight1)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible1;
        public Visibility IsCheckVisible1
        {
            get { return isCheckVisible1; }
            set { isCheckVisible1 = value; this.RaisePropertyChanged(nameof(IsCheckVisible1)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore1;

        public string HomeScore1
        {
            get { return homeScore1; }
            set { homeScore1 = value; this.RaisePropertyChanged(nameof(HomeScore1)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible1;

        public Visibility HScoreVisible1
        {
            get { return hScoreVisible1; }
            set { hScoreVisible1 = value; this.RaisePropertyChanged(nameof(hScoreVisible1)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore1;

        public string HSeasonScore1
        {
            get { return hSeasonScore1; }
            set { hSeasonScore1 = value; this.RaisePropertyChanged(nameof(HSeasonScore1)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible1;
        public Visibility HSeasonScoreVisible1
        {
            get { return hSeasonScoreVisible1; }
            set { hSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible1)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats1 = listTechStats;

        public ObservableCollection<string> TechStats1
        {
            get { return techStats1; }
            set { techStats1 = value; this.RaisePropertyChanged(nameof(TechStats1)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats1 = "进球";

        public string SelectTechStats1
        {
            get { return selectTechStats1; }
            set
            {
                selectTechStats1 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats1));

               // NewSetHData(2);
                NewSetAData(2);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible1;


        public Visibility TechStatsVisible1
        {
            get { return techStatsVisible1; }
            set { techStatsVisible1 = value; this.RaisePropertyChanged(nameof(TechStatsVisible1)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore1;

        public string AwayScore1
        {
            get { return awayScore1; }
            set { awayScore1 = value; this.RaisePropertyChanged(nameof(AwayScore1)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible1;

        public Visibility AScoreVisible1
        {
            get { return aScoreVisible1; }

            set { aScoreVisible1 = value; this.RaisePropertyChanged(nameof(AScoreVisible1)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore1;

        public string ASeasonScore1
        {
            get { return aSeasonScore1; }

            set { aSeasonScore1 = value; this.RaisePropertyChanged(nameof(ASeasonScore1)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible1;

        public Visibility ASeasonScoreVisible1
        {
            get { return aSeasonScoreVisible1; }
            set { aSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible1)); }
        }

        #endregion


        #region 第三项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight2;

        public bool IsHeight2
        {
            get { return isHeight2; }
            set { isHeight2 = value; this.RaisePropertyChanged(nameof(IsHeight2)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible2;
        public Visibility IsCheckVisible2
        {
            get { return isCheckVisible2; }
            set { isCheckVisible2 = value; this.RaisePropertyChanged(nameof(IsCheckVisible2)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore2;

        public string HomeScore2
        {
            get { return homeScore2; }
            set { homeScore2 = value; this.RaisePropertyChanged(nameof(HomeScore2)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible2;

        public Visibility HScoreVisible2
        {
            get { return hScoreVisible2; }
            set { hScoreVisible2 = value; this.RaisePropertyChanged(nameof(hScoreVisible2)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore2;

        public string HSeasonScore2
        {
            get { return hSeasonScore2; }
            set { hSeasonScore2 = value; this.RaisePropertyChanged(nameof(HSeasonScore2)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible2;
        public Visibility HSeasonScoreVisible2
        {
            get { return hSeasonScoreVisible2; }
            set { hSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible2)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats2 = listTechStats;

        public ObservableCollection<string> TechStats2
        {
            get { return techStats2; }
            set { techStats2 = value; this.RaisePropertyChanged(nameof(TechStats2)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats2 = "黄牌";

        public string SelectTechStats2
        {
            get { return selectTechStats2; }
            set
            {
                selectTechStats2 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats2));

               // NewSetHData(3);
                NewSetAData(3);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible2;


        public Visibility TechStatsVisible2
        {
            get { return techStatsVisible2; }
            set { techStatsVisible2 = value; this.RaisePropertyChanged(nameof(TechStatsVisible2)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore2;

        public string AwayScore2
        {
            get { return awayScore2; }
            set { awayScore2 = value; this.RaisePropertyChanged(nameof(AwayScore2)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible2;

        public Visibility AScoreVisible2
        {
            get { return aScoreVisible2; }

            set { aScoreVisible2 = value; this.RaisePropertyChanged(nameof(AScoreVisible2)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore2;

        public string ASeasonScore2
        {
            get { return aSeasonScore2; }

            set { aSeasonScore2 = value; this.RaisePropertyChanged(nameof(ASeasonScore2)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible2;

        public Visibility ASeasonScoreVisible2
        {
            get { return aSeasonScoreVisible2; }
            set { aSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible2)); }
        }

        #endregion


        #region 第四项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight3;

        public bool IsHeight3
        {
            get { return isHeight3; }
            set { isHeight3 = value; this.RaisePropertyChanged(nameof(IsHeight3)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible3;
        public Visibility IsCheckVisible3
        {
            get { return isCheckVisible3; }
            set { isCheckVisible3 = value; this.RaisePropertyChanged(nameof(IsCheckVisible3)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore3;

        public string HomeScore3
        {
            get { return homeScore3; }
            set { homeScore3 = value; this.RaisePropertyChanged(nameof(HomeScore3)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible3;

        public Visibility HScoreVisible3
        {
            get { return hScoreVisible3; }
            set { hScoreVisible3 = value; this.RaisePropertyChanged(nameof(hScoreVisible3)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore3;

        public string HSeasonScore3
        {
            get { return hSeasonScore3; }
            set { hSeasonScore3 = value; this.RaisePropertyChanged(nameof(HSeasonScore3)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible3;
        public Visibility HSeasonScoreVisible3
        {
            get { return hSeasonScoreVisible3; }
            set { hSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible3)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats3 = listTechStats;

        public ObservableCollection<string> TechStats3
        {
            get { return techStats3; }
            set { techStats3 = value; this.RaisePropertyChanged(nameof(TechStats3)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats3 = "红牌";

        public string SelectTechStats3
        {
            get { return selectTechStats3; }
            set
            {
                selectTechStats3 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats3));

                //NewSetHData(4);
                NewSetAData(4);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible3;


        public Visibility TechStatsVisible3
        {
            get { return techStatsVisible3; }
            set { techStatsVisible3 = value; this.RaisePropertyChanged(nameof(TechStatsVisible3)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore3;

        public string AwayScore3
        {
            get { return awayScore3; }
            set { awayScore3 = value; this.RaisePropertyChanged(nameof(AwayScore3)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible3;

        public Visibility AScoreVisible3
        {
            get { return aScoreVisible3; }

            set { aScoreVisible3 = value; this.RaisePropertyChanged(nameof(AScoreVisible3)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore3;

        public string ASeasonScore3
        {
            get { return aSeasonScore3; }

            set { aSeasonScore3 = value; this.RaisePropertyChanged(nameof(ASeasonScore3)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible3;

        public Visibility ASeasonScoreVisible3
        {
            get { return aSeasonScoreVisible3; }
            set { aSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible3)); }
        }

        #endregion


        #region 第五项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight4;

        public bool IsHeight4
        {
            get { return isHeight4; }
            set { isHeight4 = value; this.RaisePropertyChanged(nameof(IsHeight4)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible4;
        public Visibility IsCheckVisible4
        {
            get { return isCheckVisible4; }
            set { isCheckVisible4 = value; this.RaisePropertyChanged(nameof(IsCheckVisible4)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore4;

        public string HomeScore4
        {
            get { return homeScore4; }
            set { homeScore4 = value; this.RaisePropertyChanged(nameof(HomeScore4)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible4;

        public Visibility HScoreVisible4
        {
            get { return hScoreVisible4; }
            set { hScoreVisible4 = value; this.RaisePropertyChanged(nameof(hScoreVisible4)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore4;

        public string HSeasonScore4
        {
            get { return hSeasonScore4; }
            set { hSeasonScore4 = value; this.RaisePropertyChanged(nameof(HSeasonScore4)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible4;
        public Visibility HSeasonScoreVisible4
        {
            get { return hSeasonScoreVisible4; }
            set { hSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible4)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats4 = listTechStats;

        public ObservableCollection<string> TechStats4
        {
            get { return techStats4; }
            set { techStats4 = value; this.RaisePropertyChanged(nameof(TechStats4)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats4 = "助攻";

        public string SelectTechStats4
        {
            get { return selectTechStats4; }
            set
            {
                selectTechStats4 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats4));

                //NewSetHData(5);
                NewSetAData(5);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible4;


        public Visibility TechStatsVisible4
        {
            get { return techStatsVisible4; }
            set { techStatsVisible4 = value; this.RaisePropertyChanged(nameof(TechStatsVisible4)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore4;

        public string AwayScore4
        {
            get { return awayScore4; }
            set { awayScore4 = value; this.RaisePropertyChanged(nameof(AwayScore4)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible4;

        public Visibility AScoreVisible4
        {
            get { return aScoreVisible4; }

            set { aScoreVisible4 = value; this.RaisePropertyChanged(nameof(AScoreVisible4)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore4;

        public string ASeasonScore4
        {
            get { return aSeasonScore4; }

            set { aSeasonScore4 = value; this.RaisePropertyChanged(nameof(ASeasonScore4)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible4;

        public Visibility ASeasonScoreVisible4
        {
            get { return aSeasonScoreVisible4; }
            set { aSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible4)); }
        }

        #endregion


        #region 第六项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight5;

        public bool IsHeight5
        {
            get { return isHeight5; }
            set { isHeight5 = value; this.RaisePropertyChanged(nameof(IsHeight5)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible5;
        public Visibility IsCheckVisible5
        {
            get { return isCheckVisible5; }
            set { isCheckVisible5 = value; this.RaisePropertyChanged(nameof(IsCheckVisible5)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string homeScore5;

        public string HomeScore5
        {
            get { return homeScore5; }
            set { homeScore5 = value; this.RaisePropertyChanged(nameof(HomeScore5)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible5;

        public Visibility HScoreVisible5
        {
            get { return hScoreVisible5; }
            set { hScoreVisible5 = value; this.RaisePropertyChanged(nameof(hScoreVisible5)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore5;

        public string HSeasonScore5
        {
            get { return hSeasonScore5; }
            set { hSeasonScore5 = value; this.RaisePropertyChanged(nameof(HSeasonScore5)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible5;
        public Visibility HSeasonScoreVisible5
        {
            get { return hSeasonScoreVisible5; }
            set { hSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible5)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats5 = listTechStats;

        public ObservableCollection<string> TechStats5
        {
            get { return techStats5; }
            set { techStats5 = value; this.RaisePropertyChanged(nameof(TechStats5)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats5 = "射门";

        public string SelectTechStats5
        {
            get { return selectTechStats5; }
            set
            {
                selectTechStats5 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats5));

                //NewSetHData(6);
                NewSetAData(6);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible5;


        public Visibility TechStatsVisible5
        {
            get { return techStatsVisible5; }
            set { techStatsVisible5 = value; this.RaisePropertyChanged(nameof(TechStatsVisible5)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string awayScore5;

        public string AwayScore5
        {
            get { return awayScore5; }
            set { awayScore5 = value; this.RaisePropertyChanged(nameof(AwayScore5)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible5;

        public Visibility AScoreVisible5
        {
            get { return aScoreVisible5; }

            set { aScoreVisible5 = value; this.RaisePropertyChanged(nameof(AScoreVisible5)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore5;

        public string ASeasonScore5
        {
            get { return aSeasonScore5; }

            set { aSeasonScore5 = value; this.RaisePropertyChanged(nameof(ASeasonScore5)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible5;

        public Visibility ASeasonScoreVisible5
        {
            get { return aSeasonScoreVisible5; }
            set { aSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible5)); }
        }

        #endregion


        //#region 第七项数据

        ///// <summary>
        ///// 是否高亮
        ///// </summary>

        //private bool isHeight6;

        //public bool IsHeight6
        //{
        //    get { return isHeight6; }
        //    set { isHeight6 = value; this.RaisePropertyChanged(nameof(IsHeight5)); }
        //}

        ///// <summary>
        ///// 是否显示
        ///// </summary>
        //private Visibility isCheckVisible6;
        //public Visibility IsCheckVisible6
        //{
        //    get { return isCheckVisible6; }
        //    set { isCheckVisible6 = value; this.RaisePropertyChanged(nameof(IsCheckVisible6)); }
        //}



        ///// <summary>
        /////主队本场得分
        ///// </summary>
        //private string homeScore6;

        //public string HomeScore6
        //{
        //    get { return homeScore6; }
        //    set { homeScore6 = value; this.RaisePropertyChanged(nameof(HomeScore6)); }
        //}


        ///// <summary>
        ///// 主队本场得分是否可见
        ///// </summary>

        //public Visibility hScoreVisible6;

        //public Visibility HScoreVisible6
        //{
        //    get { return hScoreVisible6; }
        //    set { hScoreVisible6 = value; this.RaisePropertyChanged(nameof(hScoreVisible6)); }
        //}


        ///// <summary>
        ///// 赛季球员得分
        ///// </summary>

        //public string hSeasonScore6;

        //public string HSeasonScore6
        //{
        //    get { return hSeasonScore6; }
        //    set { hSeasonScore6 = value; this.RaisePropertyChanged(nameof(HSeasonScore6)); }
        //}


        ///// <summary>
        ///// 赛季球员是否可见
        ///// </summary>
        //private Visibility hSeasonScoreVisible6;
        //public Visibility HSeasonScoreVisible6
        //{
        //    get { return hSeasonScoreVisible6; }
        //    set { hSeasonScoreVisible6 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible6)); }
        //}


        ///// <summary>
        ///// 技术统计
        ///// </summary>
        //private ObservableCollection<string> techStats6 = listTechStats;

        //public ObservableCollection<string> TechStats6
        //{
        //    get { return techStats6; }
        //    set { techStats6 = value; this.RaisePropertyChanged(nameof(TechStats6)); }
        //}



        ///// <summary>
        ///// 选中的值
        ///// </summary>
        //private string selectTechStats6 = "角球";

        //public string SelectTechStats6
        //{
        //    get { return selectTechStats6; }
        //    set
        //    {
        //        selectTechStats6 = value;
        //        this.RaisePropertyChanged(nameof(SelectTechStats6));

        //       // Utils.NewSetHData(this, 7);
        //       // Utils.NewSetAData(this, 7);
        //    }
        //}


        ///// <summary>
        ///// 技术统计是否可见
        ///// </summary>
        //private Visibility techStatsVisible6;


        //public Visibility TechStatsVisible6
        //{
        //    get { return techStatsVisible6; }
        //    set { techStatsVisible6 = value; this.RaisePropertyChanged(nameof(TechStatsVisible6)); }
        //}


        ///// <summary>
        ///// 客队得分
        ///// </summary>

        //private string awayScore6;

        //public string AwayScore6
        //{
        //    get { return awayScore6; }
        //    set { awayScore6 = value; this.RaisePropertyChanged(nameof(AwayScore6)); }
        //}


        ///// <summary>
        ///// 客队得分是否可见
        ///// </summary>
        //private Visibility aScoreVisible6;

        //public Visibility AScoreVisible6
        //{
        //    get { return aScoreVisible6; }

        //    set { aScoreVisible6 = value; this.RaisePropertyChanged(nameof(AScoreVisible6)); }
        //}


        ///// <summary>
        ///// 客队赛季得分
        ///// </summary>
        //private string aSeasonScore6;

        //public string ASeasonScore6
        //{
        //    get { return aSeasonScore6; }

        //    set { aSeasonScore6 = value; this.RaisePropertyChanged(nameof(ASeasonScore6)); }
        //}


        ///// <summary>
        ///// 客队赛季得分是否可见
        ///// </summary>
        //private Visibility aSeasonScoreVisible6;

        //public Visibility ASeasonScoreVisible6
        //{
        //    get { return aSeasonScoreVisible6; }
        //    set { aSeasonScoreVisible6 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible6)); }
        //}

        //#endregion

    }
}
