﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// FTeamHistoryCompareView.xaml 的交互逻辑
    /// </summary>
    public partial class FTeamHistoryCompareView : UserControl, IPluginView
    {

        public FTeamHistoryCompareViewModel vm = new FTeamHistoryCompareViewModel();
        public FTeamHistoryCompareView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, vm);

            FTeamHistoryCompareViewModel.TeamStatsHistoryInstance.Add(vm);

            this.Loaded += NewSinglePlayerView_Loaded;
            this.IsVisibleChanged += NewSinglePlayerView_IsVisibleChanged;

        }



        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();



        private void NewSinglePlayerView_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!string.IsNullOrEmpty(vm.homeTeamId) && !string.IsNullOrEmpty(vm.visitTeamId))
            {
                vm.SetTeamData();
            }
        }

        private void NewSinglePlayerView_Loaded(object sender, RoutedEventArgs e)
        {
            var service = ApplicationDomainEx.ServiceManager.GetService<IPluginService>(ViewServiceKeys.PLUGIN_SERVICE);
            if (service == null)
                return;
            vm.page = service.GetPageModelFromView(this);

        }


        public void Dispose()
        {

        }

        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected && vm.teamHomeStats != null)
            {
                vm.SetTeamData();
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

        public void PreviewContinue(ConnModel conn)
        {

        }

        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);

            if (conn.IsConnected && vm.teamHomeStats != null)//
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }

        }

        public void PreviewOut(ConnModel conn)
        {

        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);
            if (conn.IsConnected && vm.teamHomeStats != null)//
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

        public void TakeContinue(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_CONTINUE);

            if (conns.IsConnected && vm.teamHomeStats != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeOut(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_OUT);

            if (conns.IsConnected && vm.teamHomeStats != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);

            if (conns.IsConnected && vm.teamHomeStats != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);
            if (conns.IsConnected && vm.teamHomeStats != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

    }
}
