﻿using DevExpress.Mvvm.POCO;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Module;

namespace VIZ.TVP.WMCUP.Module
{
    public class HttpUrlConfigViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MediaSettingViewModel));


        private static AppSetup_InitLiteDB appSetup_InitCBALiteDB = AppSetup_InitLiteDB.CreateInstance;



        /// <summary>
        /// 媒资库配置设置视图模型
        /// </summary>
        public HttpUrlConfigViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // HttpUrlConfigEntity config = AppSetup_InitCBALiteDB.HttpUrlConfigEntity;

            //FootballTypes = new ObservableCollection<string>()
            //{
            //    "英超","法甲","意甲","德甲","西甲" 
            //};
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);

        }


        // =========================================================================
        // Property
        // =========================================================================

        #region 主数据来源

        #region Url -- 地址

        private string url;
        /// <summary>
        /// 地址
        /// </summary>
        public string Url
        {
            get { return url; }
            set { url = value; this.RaisePropertyChanged(nameof(Url)); }
        }

        #endregion


        #region 应用Id
        /// <summary>
        /// 艾果平台应用Id
        /// </summary>
        private string appId;

        public string AppId
        {
            get { return appId; }
            set { appId = value; this.RaisePropertyChanged(nameof(AppId)); }
        }

        #endregion


        #region 平台Key
        /// <summary>
        /// 艾果应用平台Key
        /// </summary>
        private string appKey;

        public string AppKey
        {
            get { return appKey; }
            set { appKey = value; this.RaisePropertyChanged(nameof(AppKey)); }
        }

        #endregion

        #endregion


        #region 备份数据来源

        #region Url -- 地址

        private string burl;
        /// <summary>
        /// 地址
        /// </summary>
        public string BUrl
        {
            get { return burl; }
            set { burl = value; this.RaisePropertyChanged(nameof(BUrl)); }
        }

        #endregion


        #region 应用Id
        /// <summary>
        /// 艾果平台应用Id
        /// </summary>
        private string bappId;

        public string BAppId
        {
            get { return bappId; }
            set { bappId = value; this.RaisePropertyChanged(nameof(BAppId)); }
        }

        #endregion


        #region 平台Key
        /// <summary>
        /// 艾果应用平台Key
        /// </summary>
        private string bappKey;

        public string BAppKey
        {
            get { return bappKey; }
            set { bappKey = value; this.RaisePropertyChanged(nameof(BAppKey)); }
        }

        #endregion




        /// <summary>
        /// 球员图片地址
        /// </summary>
        private string playersLogo;

        public string PlayersLogo
        {
            get { return playersLogo; }
            set { playersLogo = value; this.RaisePropertyChanged(nameof(PlayersLogo)); }
        }



        #endregion

        // =========================================================================
        // Command
        // =========================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }


        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            this.Url = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;

            this.AppId = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;

            this.AppKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;

            this.BUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;

            this.BAppId = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;

            this.BAppKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;

            this.PlayersLogo = AppSetup_InitLiteDB.HttpUrlConfigEntity.PlayersLogo;

            // this.SelectFootballType = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectFootballType;

            // this.SelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectSeason;



        }

        #endregion

        // =========================================================================
        // Public Function
        // =========================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            HttpUrlConfigEntity config = AppSetup_InitLiteDB.HttpUrlConfigEntity;
            config.Url = this.Url;
            config.AppId = this.AppId;
            config.AppKey = this.AppKey;

            config.BUrl = this.BUrl;
            config.BAppId = this.BAppId;
            config.BAppKey = this.BAppKey;

            config.PlayersLogo = this.PlayersLogo;
            //config.SelectFootballType = this.SelectFootballType;

            // 选择赛事和赛事Id
            //config.SelectSeason = this.SelectSeason;


            AppSetup_InitLiteDB.localDbContext.HttpUrlConfig.Upsert(config);
        }


       

    }
}
