﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 应用程序域
    /// </summary>
    public class ApplicationDomainEx : ApplicationDomain
    {
        /// <summary>
        /// 远程数据工作目录
        /// </summary>
        public readonly static string REMOTE_DATA_WORK_PATH = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "db", "remote");

        /// <summary>
        /// 球员信息列表
        /// </summary>
        public static ObservableCollection<PlayerInfoModel> PlayerInfos { get; set; }

        /// <summary>
        /// 队伍信息列表
        /// </summary>
        public static ObservableCollection<TeamInfoModel> TeamInfos { get; set; }

        /// <summary>
        /// 洞信息列表
        /// </summary>
        public static ObservableCollection<HoleInfoModel> HoleInfos { get; set; }

        /// <summary>
        /// 赛事信息
        /// </summary>
        public static TournamentInfoModel TournamentInfo { get; set; }

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        public static LiteDBContext LiteDBContext { get; set; }
    }
}
