﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 洞信息
    /// </summary>
    public class HoleInfoModel : ModelBase
    {
        /// <summary>
        /// 实体
        /// </summary>
        public HoleInfo Entity { get; set; }

        #region HoleID -- 洞编号

        private int holeID;
        /// <summary>
        /// 洞编号
        /// </summary>
        public int HoleID
        {
            get { return holeID; }
            set { holeID = value; this.RaisePropertyChanged(nameof(HoleID)); }
        }

        #endregion

        #region Par -- 标准杆

        private int par;
        /// <summary>
        /// 标准杆
        /// </summary>
        public int Par
        {
            get { return par; }
            set { par = value; this.RaisePropertyChanged(nameof(Par)); }
        }

        #endregion

        #region Picture -- 照片

        private string pictire;
        /// <summary>
        /// 照片
        /// </summary>
        public string Picture
        {
            get { return pictire; }
            set { pictire = value; this.RaisePropertyChanged(nameof(Picture)); }
        }

        #endregion

        /// <summary>
        /// 更新属性值实体模型
        /// </summary>
        public void UpdatePropertyToEntity()
        {
            this.Entity.HoleID = this.HoleID;
            this.Entity.Par = this.Par;
            this.Entity.Picture = this.Picture;
        }

        /// <summary>
        /// 从实体模型更新数据
        /// </summary>
        public void UpdatePropertyFromEntity()
        {
            this.HoleID = this.Entity.HoleID;
            this.Par = this.Entity.Par;
            this.Picture = this.Entity.Picture;
        }
    }
}
