﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 球员信息模型
    /// </summary>
    public class PlayerInfoModel : ModelBase
    {
        public PlayerInfoModel()
        {

        }

        /// <summary>
        /// 实体
        /// </summary>
        public PlayerInfo Entity { get; set; }

        #region PlayerID -- 球员编号

        private int playerID;
        /// <summary>
        /// 球员编号
        /// </summary>
        public int PlayerID
        {
            get { return playerID; }
            set { playerID = value; this.RaisePropertyChanged(nameof(PlayerID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Sex -- 性别

        private SexEnum sex = SexEnum.Male;
        /// <summary>
        /// 性别
        /// </summary>
        public SexEnum Sex
        {
            get { return sex; }
            set { sex = value; this.RaisePropertyChanged(nameof(Sex)); }
        }

        #endregion

        #region IsCaptain -- 是否是队长

        private bool isCaptain;
        /// <summary>
        /// 是否是队长
        /// </summary>
        public bool IsCaptain
        {
            get { return isCaptain; }
            set { isCaptain = value; this.RaisePropertyChanged(nameof(IsCaptain)); }
        }

        #endregion

        #region TeamID -- 队伍编号

        private int teamID;
        /// <summary>
        /// 队伍编号
        /// </summary>
        public int TeamID
        {
            get { return teamID; }
            set { teamID = value; this.RaisePropertyChanged(nameof(TeamID)); }
        }

        #endregion

        #region Group -- 分组

        private string group;
        /// <summary>
        /// 分组
        /// </summary>
        public string Group
        {
            get { return group; }
            set { group = value; this.RaisePropertyChanged(nameof(Group)); }
        }

        #endregion

        #region HalfPicture -- 半身照

        private string halfPicture;
        /// <summary>
        /// 半身照
        /// </summary>
        public string HalfPicture
        {
            get { return halfPicture; }
            set { halfPicture = value; this.RaisePropertyChanged(nameof(HalfPicture)); }
        }

        #endregion

        #region TeamInfoModel -- 队伍信息模型

        private TeamInfoModel teamInfoModel;
        /// <summary>
        /// 队伍信息模型
        /// </summary>
        public TeamInfoModel TeamInfoModel
        {
            get { return teamInfoModel; }
            set
            {
                teamInfoModel = value;
                this.RaisePropertyChanged(nameof(TeamInfoModel));
                this.TeamID = value == null ? 0 : value.TeamID;
            }
        }

        #endregion

        /// <summary>
        /// 更新属性值实体模型
        /// </summary>
        public void UpdatePropertyToEntity()
        {
            this.Entity.PlayerID = this.PlayerID;
            this.Entity.Name = this.Name;
            this.Entity.Sex = this.Sex;
            this.Entity.IsCaptain = this.IsCaptain;
            this.Entity.TeamID = this.TeamID;
            this.Entity.Group = this.Group;
            this.Entity.HalfPicture = this.HalfPicture;
        }

        /// <summary>
        /// 从实体模型更新数据
        /// </summary>
        public void UpdatePropertyFromEntity()
        {
            this.PlayerID = this.Entity.PlayerID;
            this.Name = this.Entity.Name;
            this.Sex = this.Entity.Sex;
            this.IsCaptain = this.Entity.IsCaptain;
            this.TeamID = this.Entity.TeamID;
            this.Group = this.Entity.Group;
            this.HalfPicture = this.Entity.HalfPicture;
        }
    }
}
