﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 队伍信息模型
    /// </summary>
    public class TeamInfoModel : ModelBase
    {
        /// <summary>
        /// 实体
        /// </summary>
        public TeamInfo Entity { get; set; }

        #region TeamID -- 队伍编号

        private int teamID;
        /// <summary>
        /// 队伍编号
        /// </summary>
        public int TeamID
        {
            get { return teamID; }
            set { teamID = value; this.RaisePropertyChanged(nameof(TeamID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }


        #endregion

        #region Logo -- Logo

        private string logo;
        /// <summary>
        /// 标志
        /// </summary>
        public string Logo
        {
            get { return logo; }
            set { logo = value; this.RaisePropertyChanged(nameof(Logo)); }
        }

        #endregion

        /// <summary>
        /// 更新属性值实体模型
        /// </summary>
        public void UpdatePropertyToEntity()
        {
            this.Entity.TeamID = this.TeamID;
            this.Entity.Name = this.Name;
            this.Entity.Logo = this.Logo;
        }

        /// <summary>
        /// 从实体模型更新数据
        /// </summary>
        public void UpdatePropertyFromEntity()
        {
            this.TeamID = this.Entity.TeamID;
            this.Name = this.Entity.Name;
            this.Logo = this.Entity.Logo;
        }
    }
}
