﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 赛事信息模型
    /// </summary>
    public class TournamentInfoModel : ModelBase
    {
        /// <summary>
        /// 实体
        /// </summary>
        public TournamentInfo Entity { get; set; }

        #region TournamentID -- 赛事ID

        private int tournamentID;
        /// <summary>
        /// 赛事ID
        /// </summary>
        public int TournamentID
        {
            get { return tournamentID; }
            set { tournamentID = value; this.RaisePropertyChanged(nameof(TournamentID)); }
        }

        #endregion

        #region TournamentName -- 赛事名称

        private string tournamentName;
        /// <summary>
        /// 赛事名称
        /// </summary>
        public string TournamentName
        {
            get { return tournamentName; }
            set { tournamentName = value; this.RaisePropertyChanged(nameof(TournamentName)); }
        }

        #endregion

        #region BeginTime -- 开始时间

        private DateTime beginTime;
        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime BeginTime
        {
            get { return beginTime; }
            set { beginTime = value; this.RaisePropertyChanged(nameof(BeginTime)); }
        }

        #endregion

        #region EndTime -- 结束时间

        private DateTime endTime;
        /// <summary>
        /// 结束时间
        /// </summary>
        public DateTime EndTime
        {
            get { return endTime; }
            set { endTime = value; this.RaisePropertyChanged(nameof(EndTime)); }
        }

        #endregion

        /// <summary>
        /// 更新属性值实体模型
        /// </summary>
        public void UpdatePropertyToEntity()
        {
            this.Entity.TournamentID = this.TournamentID;
            this.Entity.TournamentName = this.TournamentName;
            this.Entity.BeginTime = this.BeginTime;
            this.Entity.EndTime = this.EndTime;
        }

        /// <summary>
        /// 从实体模型更新数据
        /// </summary>
        public void UpdatePropertyFromEntity()
        {
            this.TournamentID = this.Entity.TournamentID;
            this.TournamentName = this.Entity.TournamentName;
            this.BeginTime = this.Entity.BeginTime;
            this.EndTime = this.Entity.EndTime;
        }
    }
}
