﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 球员实时数据模型
    /// </summary>
    public class PlayerRealModel : ModelBase
    {
        /// <summary>
        /// 节点
        /// </summary>
        public PlayerNode Node { get; set; }

        #region PlayerID -- 球员编号

        private int playerID;
        /// <summary>
        /// 球员编号
        /// </summary>
        public int PlayerID
        {
            get { return playerID; }
            set { playerID = value; this.RaisePropertyChanged(nameof(PlayerID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Country -- 国家

        private string country;
        /// <summary>
        /// 国家
        /// </summary>
        public string Country
        {
            get { return country; }
            set { country = value; this.RaisePropertyChanged(nameof(Country)); }
        }

        #endregion

        #region Position -- 排名

        private string position;
        /// <summary>
        /// 排名
        /// </summary>
        public string Position
        {
            get { return position; }
            set { position = value; this.RaisePropertyChanged(nameof(Position)); }
        }

        #endregion

        #region Score -- 得分

        private int score;
        /// <summary>
        /// 得分
        /// </summary>
        public int Score
        {
            get { return score; }
            set { score = value; this.RaisePropertyChanged(nameof(Score)); }
        }

        #endregion

        #region Strokes -- 总杆数

        private int strokes;
        /// <summary>
        /// 总杆数
        /// </summary>
        public int Strokes
        {
            get { return strokes; }
            set { strokes = value; this.RaisePropertyChanged(nameof(Strokes)); }
        }

        #endregion

        #region TeamLogo -- 队伍Logo

        private string teamLogo;
        /// <summary>
        /// 队伍标志
        /// </summary>
        public string TeamLogo
        {
            get { return teamLogo; }
            set { teamLogo = value; this.RaisePropertyChanged(nameof(TeamLogo)); }
        }

        #endregion

        #region Rounds -- 轮次集合

        private ObservableCollection<RoundRealModel> rounds = new ObservableCollection<RoundRealModel>();
        /// <summary>
        /// 轮次集合
        /// </summary>
        public ObservableCollection<RoundRealModel> Rounds
        {
            get { return rounds; }
            set { rounds = value; this.RaisePropertyChanged(nameof(Rounds)); }
        }

        #endregion

        #region PlayerInfoModel -- 球员信息

        private PlayerInfoModel playerInfoModel;
        /// <summary>
        /// 球员信息
        /// </summary>
        public PlayerInfoModel PlayerInfoModel
        {
            get { return playerInfoModel; }
            set { playerInfoModel = value; this.RaisePropertyChanged(nameof(PlayerInfoModel)); }
        }

        #endregion

        #region TeamInfoModel -- 队伍信息

        private TeamInfoModel teamInfoModel;
        /// <summary>
        /// 队伍信息
        /// </summary>
        public TeamInfoModel TeamInfoModel
        {
            get { return teamInfoModel; }
            set { teamInfoModel = value; this.RaisePropertyChanged(nameof(TeamInfoModel)); }
        }

        #endregion

        /// <summary>
        /// 从XML节点获取数据
        /// </summary>
        /// <param name="node">XML节点</param>
        public void FromNode(PlayerNode node)
        {
            this.Node = node;

            this.PlayerID = node.id;
            this.Name = node.pl_tvlname;
            this.Country = node.country;
            this.Position = node.position;
            this.Score = node.score;
            this.Strokes = node.strokes;

            if (node.Rounds == null)
                return;

            foreach (RoundNode round in node.Rounds)
            {
                RoundRealModel model = new RoundRealModel();
                model.FromNode(round);

                this.Rounds.Add(model);
            }
        }
    }
}
