﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 轮次实时数据模型
    /// </summary>
    public class RoundRealModel : ModelBase
    {
        /// <summary>
        /// 轮次节点
        /// </summary>
        public RoundNode Node { get; set; }

        #region No -- 轮次序号

        private int no;
        /// <summary>
        /// 轮次序号
        /// </summary>
        public int No
        {
            get { return no; }
            set { no = value; this.RaisePropertyChanged(nameof(No)); }
        }

        #endregion

        #region TeeTime -- 开球时间

        private TimeSpan teeTime;
        /// <summary>
        /// 开球时间
        /// </summary>
        public TimeSpan TeeTime
        {
            get { return teeTime; }
            set { teeTime = value; this.RaisePropertyChanged(nameof(TeeTime)); }
        }

        #endregion

        #region StartingTee -- 开球台，从哪一洞开始的比赛

        private int startingTee;
        /// <summary>
        /// 开球台，从哪一洞开始的比赛
        /// </summary>
        public int StartingTee
        {
            get { return startingTee; }
            set { startingTee = value; this.RaisePropertyChanged(nameof(StartingTee)); }
        }

        #endregion

        #region Thru -- 已经完成的洞数

        private int thru;
        /// <summary>
        /// 已经完成的洞数
        /// </summary>
        public int Thru
        {
            get { return thru; }
            set { thru = value; this.RaisePropertyChanged(nameof(Thru)); }
        }

        #endregion

        #region Today -- 本轮（今日）杆数与标准杆的差值

        private int today;
        /// <summary>
        /// 本轮（今日）杆数与标准杆的差值
        /// </summary>
        public int Today
        {
            get { return today; }
            set { today = value; this.RaisePropertyChanged(nameof(Today)); }
        }

        #endregion

        #region Total -- 本轮（进入）总杆数

        private int total;
        /// <summary>
        /// 本轮（进入）总杆数
        /// </summary>
        public int Total
        {
            get { return total; }
            set { total = value; this.RaisePropertyChanged(nameof(Total)); }
        }

        #endregion

        #region Scores -- 得分集合

        private ObservableCollection<ScoreRealModel> scores = new ObservableCollection<ScoreRealModel>();
        /// <summary>
        /// 得分集合
        /// </summary>
        public ObservableCollection<ScoreRealModel> Scores
        {
            get { return scores; }
            set { scores = value; this.RaisePropertyChanged(nameof(Scores)); }
        }

        #endregion

        /// <summary>
        /// 从XML节点获取数据
        /// </summary>
        /// <param name="node">XML节点</param>
        public void FromNode(RoundNode node)
        {
            this.Node = node;

            this.No = node.no;
            this.TeeTime = node.teetime;
            this.StartingTee = node.startingtee;
            this.Thru = node.thru;
            this.Today = node.today;
            this.Total = node.total;

            if (node.Scores == null)
                return;

            foreach (ScoreNode score in node.Scores)
            {
                ScoreRealModel model = new ScoreRealModel();
                model.FromNode(score);

                this.Scores.Add(model);
            }
        }
    }
}
