﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 得分实时数据
    /// </summary>
    public class ScoreRealModel : ModelBase
    {
        /// <summary>
        /// 节点
        /// </summary>
        public ScoreNode Node { get; private set; }

        #region Hole -- 洞号

        private int hole;
        /// <summary>
        /// 洞号
        /// </summary>
        public int Hole
        {
            get { return hole; }
            set { hole = value; this.RaisePropertyChanged(nameof(Hole)); }
        }

        #endregion

        #region Strokes -- 杆数

        private int strokes;
        /// <summary>
        /// 杆数
        /// </summary>
        public int Strokes
        {
            get { return strokes; }
            set { strokes = value; this.RaisePropertyChanged(nameof(Strokes)); }
        }

        #endregion

        #region Par -- 标准杆

        private int par;
        /// <summary>
        /// 标准杆
        /// </summary>
        public int Par
        {
            get { return par; }
            set { par = value; this.RaisePropertyChanged(nameof(Par)); }
        }

        #endregion

        #region Bunkers -- 沙滩救球数

        private int bunkers;
        /// <summary>
        /// 沙滩救球数
        /// </summary>
        public int Bunkers
        {
            get { return bunkers; }
            set { bunkers = value; this.RaisePropertyChanged(nameof(Bunkers)); }
        }

        #endregion

        #region Putts -- 推杆数

        private int putts;
        /// <summary>
        /// 推杆数
        /// </summary>
        public int Putts
        {
            get { return putts; }
            set { putts = value; this.RaisePropertyChanged(nameof(Putts)); }
        }

        #endregion

        #region Drive -- 开球距离

        private double drive;
        /// <summary>
        /// 开球距离
        /// </summary>
        public double Drive
        {
            get { return drive; }
            set { drive = value; this.RaisePropertyChanged(nameof(Drive)); }
        }

        #endregion

        #region Fairway -- 是否发球上球道 1: 是 | 0: 否 | 空: 未记录

        private int fairway;
        /// <summary>
        /// 是否发球上球道 1: 是 | 0: 否 | 空: 未记录
        /// </summary>
        public int Fairway
        {
            get { return fairway; }
            set { fairway = value; this.RaisePropertyChanged(nameof(Fairway)); }
        }

        #endregion

        /// <summary>
        /// 从XML节点获取数据
        /// </summary>
        /// <param name="node">XML节点</param>
        public void FromNode(ScoreNode node)
        {
            this.Node = node;

            this.hole = node.hole;
            this.Strokes = node.strokes;
            this.Par = node.par;
            this.Bunkers = node.bunkers;
            this.Putts = node.putts;
            this.drive = node.drive;
            this.fairway = node.fairway;
        }
    }
}
