﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 队伍真实数据
    /// </summary>
    public class TeamRealModel : ModelBase
    {
        /// <summary>
        /// 模型
        /// </summary>
        public TeamInfoModel Model { get; private set; }

        #region Position -- 排名

        private int position;
        /// <summary>
        /// 排名
        /// </summary>
        public int Position
        {
            get { return position; }
            set { position = value; this.RaisePropertyChanged(nameof(Position)); }
        }

        #endregion

        #region Name -- 队伍名称

        private string name;
        /// <summary>
        /// 队伍名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Logo -- Logo

        private string logo;
        /// <summary>
        /// Logo
        /// </summary>
        public string Logo
        {
            get { return logo; }
            set { logo = value; this.RaisePropertyChanged(nameof(Logo)); }
        }

        #endregion

        #region Strokes -- 总杆数

        private int strokes;
        /// <summary>
        /// 总杆数
        /// </summary>
        public int Strokes
        {
            get { return strokes; }
            set { strokes = value; this.RaisePropertyChanged(nameof(Strokes)); }
        }

        #endregion

        #region Players -- 队员

        private ObservableCollection<PlayerRealModel> players = new ObservableCollection<PlayerRealModel>();
        /// <summary>
        /// 队员
        /// </summary>
        public ObservableCollection<PlayerRealModel> Players
        {
            get { return players; }
            set { players = value; this.RaisePropertyChanged(nameof(Players)); }
        }

        #endregion

        /// <summary>
        /// 从模型中获取数据
        /// </summary>
        /// <param name="model">模型</param>
        public void FromModel(TeamInfoModel model)
        {
            this.Model = model;

            this.Name = model.Name;
            this.Logo = model.Name;
        }
    }
}
