﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 分组临时模型
    /// </summary>
    public class GroupTempModel : ModelBase
    {
        #region Group -- 分组信息

        private string group;
        /// <summary>
        /// 分组
        /// </summary>
        public string Group
        {
            get { return group; }
            set { group = value; this.RaisePropertyChanged(nameof(Group)); }
        }

        #endregion

        #region TeamInfo -- 队伍信息

        private TeamInfoModel teamInfo;
        /// <summary>
        /// 队伍信息
        /// </summary>
        public TeamInfoModel TeamInfo
        {
            get { return teamInfo; }
            set { teamInfo = value; this.RaisePropertyChanged(nameof(TeamInfo)); }
        }

        #endregion

        #region Position -- 排名

        private string position;
        /// <summary>
        /// 排名
        /// </summary>
        public string Position
        {
            get { return position; }
            set { position = value; this.RaisePropertyChanged(nameof(Position)); }
        }

        #endregion

        #region Players -- 球员信息

        private ObservableCollection<PlayerInfoModel> players = new ObservableCollection<PlayerInfoModel>();
        /// <summary>
        /// 球员信息
        /// </summary>
        public ObservableCollection<PlayerInfoModel> Players
        {
            get { return players; }
            set { players = value; this.RaisePropertyChanged(nameof(Players)); }
        }

        #endregion

        #region TeamLogo -- 队伍Logo

        private string teamLogo;
        /// <summary>
        /// 队伍Logo
        /// </summary>
        public string TeamLogo
        {
            get { return teamLogo; }
            set { teamLogo = value; this.RaisePropertyChanged(nameof(TeamLogo)); }
        }

        #endregion

        #region PlayersDisplayName -- 显示名称

        private string playersDisplayName;
        /// <summary>
        /// 显示名称
        /// </summary>
        public string PlayersDisplayName
        {
            get { return playersDisplayName; }
            set { playersDisplayName = value; this.RaisePropertyChanged(nameof(PlayersDisplayName)); }
        }

        #endregion

        #region PlayersStrokes -- 总杆数

        private string playersStrokes;
        /// <summary>
        /// 总杆数
        /// </summary>
        public string PlayersStrokes
        {
            get { return playersStrokes; }
            set { playersStrokes = value; this.RaisePropertyChanged(nameof(PlayersStrokes)); }
        }

        #endregion
    }
}
