﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 球员临时模型
    /// </summary>
    public class PlayerTempModel : ModelBase
    {
        #region PlayerID -- 球员编号

        private int playerID;
        /// <summary>
        /// 球员编号
        /// </summary>
        public int PlayerID
        {
            get { return playerID; }
            set { playerID = value; this.RaisePropertyChanged(nameof(PlayerID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region IsCaptain -- 是否是队长

        private bool isCaptain;
        /// <summary>
        /// 是否是队长
        /// </summary>
        public bool IsCaptain
        {
            get { return isCaptain; }
            set { isCaptain = value; this.RaisePropertyChanged(nameof(IsCaptain)); }
        }

        #endregion

        #region HalfPicture -- 半身照

        private string halfPicture;
        /// <summary>
        /// 半身照
        /// </summary>
        public string HalfPicture
        {
            get { return halfPicture; }
            set { halfPicture = value; this.RaisePropertyChanged(nameof(HalfPicture)); }
        }

        #endregion

        #region Strokes -- 总杆数

        private int strokes;
        /// <summary>
        /// 总杆数
        /// </summary>
        public int Strokes
        {
            get { return strokes; }
            set { strokes = value; this.RaisePropertyChanged(nameof(Strokes)); }
        }

        #endregion

        /// <summary>
        /// 从球员信息模型中获取数据 
        /// </summary>
        /// <param name="model">球员信息模型</param>
        public void FromInfoModel(PlayerInfoModel model)
        {
            this.PlayerID = model.PlayerID;
            this.Name = model.Name;
            this.HalfPicture = model.HalfPicture;
            this.IsCaptain = model.IsCaptain;
        }
    }
}
