﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 队伍临时模型
    /// </summary>
    public class TeamTempModel : ModelBase
    {
        #region TeamInfoModel -- 队伍信息

        private TeamInfoModel teamInfoModel;
        /// <summary>
        /// 队伍信息模型
        /// </summary>
        public TeamInfoModel TeamInfoModel
        {
            get { return teamInfoModel; }
            set { teamInfoModel = value; this.RaisePropertyChanged(nameof(TeamInfoModel)); }
        }

        #endregion

        #region TeamID -- 队伍编号

        private int teamID;
        /// <summary>
        /// 队伍编号
        /// </summary>
        public int TeamID
        {
            get { return teamID; }
            set { teamID = value; this.RaisePropertyChanged(nameof(TeamID)); }
        }

        #endregion

        #region Logo -- 队伍Logo

        private string logo;
        /// <summary>
        /// 队伍Logo
        /// </summary>
        public string Logo
        {
            get { return logo; }
            set { logo = value; this.RaisePropertyChanged(nameof(Logo)); }
        }

        #endregion

        #region Name -- 队伍名称

        private string name;
        /// <summary>
        /// 队伍名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Position -- 排名

        private string position;
        /// <summary>
        /// 排名
        /// </summary>
        public string Position
        {
            get { return position; }
            set { position = value; this.RaisePropertyChanged(nameof(Position)); }
        }

        #endregion

        #region TotalStrokes -- 总杆数 

        private string totalStrokes;
        /// <summary>
        /// 总杆数
        /// </summary>
        public string TotalStrokes
        {
            get { return totalStrokes; }
            set { totalStrokes = value; this.RaisePropertyChanged(nameof(TotalStrokes)); }
        }

        #endregion

        /// <summary>
        /// 从信息源初始化
        /// </summary>
        /// <param name="model">队伍信息模型</param>
        public void FromInfoModel(TeamInfoModel model)
        {
            this.TeamInfoModel = model;
            this.TeamID = model.TeamID;
            this.Logo = model.Logo;
            this.Name = model.Name;
        }
    }
}
