﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data.SqlTypes;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Golf.Domain
{
    /// <summary>
    /// 包装静态资源
    /// </summary>
    public static class TvpStaticResource
    {
        /// <summary>
        /// 队伍Logo集合
        /// </summary>
        public static ObservableCollection<string> TeamLogos { get; set; } = new ObservableCollection<string>();

        /// <summary>
        /// 洞图片集合
        /// </summary>
        public static ObservableCollection<string> HolePictures { get; set; } = new ObservableCollection<string>();

        /// <summary>
        /// 球员照片集合
        /// </summary>
        public static ObservableCollection<string> PlayerPictures { get; set; } = new ObservableCollection<string>();

        /// <summary>
        /// 分组集合
        /// </summary>
        public static ObservableCollection<string> Groups { get; set; } = new ObservableCollection<string>();

        /// <summary>
        /// 轮次集合
        /// </summary>
        public static ObservableCollection<int> Rounds { get; set; } = new ObservableCollection<int>();

        /// <summary>
        /// 轮次描述
        /// </summary>
        public static Dictionary<int, string> RoundsDetail { get; set; } = new Dictionary<int, string>();

        /// <summary>
        /// 描述信息结合
        /// </summary>
        public static ObservableCollection<string> Details { get; set; } = new ObservableCollection<string>();
    }

}
