﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module.Resource
{
    /// <summary>
    /// 球员信息转化为描述的转化器
    /// </summary>
    public class PlayerInfos2DetailConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            IEnumerable items = value as IEnumerable;
            if (items == null)
                return null;

            StringBuilder sb = new StringBuilder();

            foreach (PlayerInfoModel model in items)
            {
                if (model == null)
                    continue;

                sb.Append($" {model.Name} /");
            }

            if (sb.Length > 1)
            {
                sb.Remove(sb.Length - 1, 1);
            }

            if (sb.Length > 1)
            {
                sb.Remove(0, 1);
            }

            return sb.ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
