﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 洞列表支持
    /// </summary>
    public class HoleListController
    {
        /// <summary>
        /// 洞列表支持
        /// </summary>
        /// <param name="support">洞列表支持</param>
        public HoleListController(IHoleListSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IHoleListSupport Support { get; private set; }

        /// <summary>
        /// 将数据保存值数据库
        /// </summary>
        public void SaveToDB()
        {
            lock (ApplicationDomainEx.HoleInfos)
            {
                foreach (HoleInfoModel model in ApplicationDomainEx.HoleInfos)
                {
                    model.UpdatePropertyToEntity();

                    ApplicationDomainEx.LiteDBContext.HoleInfos.Upsert(model.Entity);
                }
            }
        }

        /// <summary>
        /// 根据I
        /// </summary>
        /// <param name="id">主键</param>
        public void DeleteByID(int id)
        {
            ApplicationDomainEx.LiteDBContext.HoleInfos.Delete(id);
        }

        /// <summary>
        /// 从数据库中加载数据
        /// </summary>
        public void LoadFromDB()
        {
            lock (ApplicationDomainEx.HoleInfos)
            {
                Dictionary<int, HoleInfoModel> dic = ApplicationDomainEx.HoleInfos.ToDictionary(p => p.Entity.ID);

                var query = ApplicationDomainEx.LiteDBContext.HoleInfos.FindAll();

                foreach (HoleInfo entity in query)
                {
                    if (!dic.TryGetValue(entity.ID, out HoleInfoModel model))
                    {
                        model = new HoleInfoModel();
                        ApplicationDomainEx.HoleInfos.Add(model);
                    }
                    model.Entity = entity;
                    model.UpdatePropertyFromEntity();
                }
            }
        }
    }
}