﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 洞 列表视图模型
    /// </summary>
    public class HoleListViewModel : ViewModelBase, IHoleListSupport
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(HoleListViewModel));

        public HoleListViewModel()
        {
            // 初始化属性
            this.InitProperty();

            // 初始化控制器
            this.InitController();

            // 初始化命令
            this.InitCommand();

        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadTestDataCommand = new VCommand(this.LoadTestData);
            this.LoadLocalDataCommand = new VCommand(this.LoadLocalData);
            this.LoadRemoteDataCommand = new VCommand(this.LoadRemoteData);
            this.SaveLocalDataCommand = new VCommand(this.SaveLocalData);
            this.AddCommand = new VCommand(this.Add);
            this.DeleteCommand = new VCommand(this.Delete);
        }

        /// <summary>
        /// 初始化属性
        /// </summary>
        private void InitProperty()
        {
            this.HoleInfos = ApplicationDomainEx.HoleInfos;
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void InitController()
        {
            this.holeListController = new HoleListController(this);
        }


        // =====================================================================================
        // Controller
        // =====================================================================================

        /// <summary>
        /// 球员列表控制器
        /// </summary>
        private HoleListController holeListController;

        // =====================================================================================
        // Property
        // =====================================================================================

        #region HoleInfos -- 球员信息列表

        private ObservableCollection<HoleInfoModel> holeInfos;
        /// <summary>
        /// 球员信息列表
        /// </summary>
        public ObservableCollection<HoleInfoModel> HoleInfos
        {
            get { return holeInfos; }
            set { holeInfos = value; this.RaisePropertyChanged(nameof(HoleInfos)); }
        }

        #endregion

        #region SelectedHoleInfo -- 选中的球员信息

        private HoleInfoModel selectedHoleInfo;
        /// <summary>
        /// 选中的球员信息
        /// </summary>
        public HoleInfoModel SelectedHoleInfo
        {
            get { return selectedHoleInfo; }
            set { selectedHoleInfo = value; this.RaisePropertyChanged(nameof(SelectedHoleInfo)); }
        }

        #endregion

        // =====================================================================================
        // Command
        // =====================================================================================

        #region LoadTestDataCommand -- 加载测试数据命令

        /// <summary>
        /// 加载测试数据命令
        /// </summary>
        public VCommand LoadTestDataCommand { get; set; }

        /// <summary>
        /// 加载测试
        /// </summary>
        private void LoadTestData()
        {
            this.HoleInfos.Add(new HoleInfoModel { HoleID = 1, Picture = "test1", Entity = new HoleInfo() });
            this.HoleInfos.Add(new HoleInfoModel { HoleID = 2, Picture = "test2", Entity = new HoleInfo() });
        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        public VCommand LoadLocalDataCommand { get; set; }

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        private void LoadLocalData()
        {
            this.holeListController.LoadFromDB();
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据命令
        /// </summary>
        public VCommand LoadRemoteDataCommand { get; set; }

        /// <summary>
        /// 加载远程数据
        /// </summary>
        private void LoadRemoteData()
        {

        }

        #endregion

        #region SaveLocalDataCommand -- 保存本地数据命令

        /// <summary>
        /// 保存本地数据命令
        /// </summary>
        public VCommand SaveLocalDataCommand { get; set; }

        /// <summary>
        /// 保存本地数据
        /// </summary>
        private void SaveLocalData()
        {
            try
            {

                this.holeListController.SaveToDB();

                MessageBox.Show("保存成功");
            }
            catch (Exception ex)
            {
                log.Error(ex);

                MessageBox.Show("保存失败");
            }
        }

        #endregion

        #region AddCommand -- 添加命令

        /// <summary>
        /// 添加命令
        /// </summary>
        public VCommand AddCommand { get; set; }

        /// <summary>
        /// 添加
        /// </summary>
        private void Add()
        {
            HoleInfoModel model = new HoleInfoModel();
            model.HoleID = this.HoleInfos.Max(p => p.HoleID) + 1;
            model.Entity = new HoleInfo();

            this.HoleInfos.Add(model);
        }

        #endregion

        #region DeleteCommand -- 删除命令

        /// <summary>
        /// 删除命令
        /// </summary>
        public VCommand DeleteCommand { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        private void Delete()
        {
            if (this.SelectedHoleInfo == null)
                return;

            this.holeListController.DeleteByID(this.SelectedHoleInfo.Entity.ID);
            this.HoleInfos.Remove(this.SelectedHoleInfo);
        }

        #endregion
    }
}