﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Domain;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 球员列表控制器
    /// </summary>
    public class PlayerListController
    {
        /// <summary>
        /// 球员列表控制器
        /// </summary>
        /// <param name="support">支持</param>
        public PlayerListController(IPlayerListSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IPlayerListSupport Support { get; private set; }

        /// <summary>
        /// 将数据保存值数据库
        /// </summary>
        public void SaveToDB()
        {
            lock (ApplicationDomainEx.PlayerInfos)
            {
                foreach (PlayerInfoModel model in ApplicationDomainEx.PlayerInfos)
                {
                    model.UpdatePropertyToEntity();

                    ApplicationDomainEx.LiteDBContext.PlayerInfos.Upsert(model.Entity);
                }
            }
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="id">主键</param>
        public void DeleteByID(int id)
        {
            ApplicationDomainEx.LiteDBContext.PlayerInfos.Delete(id);
        }

        /// <summary>
        /// 从数据库中加载数据
        /// </summary>
        public void LoadFromDB()
        {
            lock (ApplicationDomainEx.PlayerInfos)
            {
                Dictionary<int, PlayerInfoModel> dic = ApplicationDomainEx.PlayerInfos.ToDictionary(p => p.Entity.ID);

                var query = ApplicationDomainEx.LiteDBContext.PlayerInfos.FindAll();

                foreach (PlayerInfo entity in query)
                {
                    if (!dic.TryGetValue(entity.ID, out PlayerInfoModel model))
                    {
                        model = new PlayerInfoModel();
                        ApplicationDomainEx.PlayerInfos.Add(model);
                    }
                    model.Entity = entity;
                    model.UpdatePropertyFromEntity();
                }
            }
        }
    }
}
