﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 球员列表视图模型
    /// </summary>
    public class PlayerListViewModel : ViewModelBase, IPlayerListSupport
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(PlayerListViewModel));

        public PlayerListViewModel()
        {
            // 初始化属性
            this.InitProperty();

            // 初始化控制器
            this.InitController();

            // 初始化命令
            this.InitCommand();

        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadLocalDataCommand = new VCommand(this.LoadLocalData);
            this.LoadRemoteDataCommand = new VCommand(this.LoadRemoteData);
            this.SaveLocalDataCommand = new VCommand(this.SaveLocalData);
            this.AddCommand = new VCommand(this.Add);
            this.DeleteCommand = new VCommand(this.Delete);
        }

        /// <summary>
        /// 初始化属性
        /// </summary>
        private void InitProperty()
        {
            this.PlayerInfos = ApplicationDomainEx.PlayerInfos;
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void InitController()
        {
            this.playerListController = new PlayerListController(this);
        }


        // =====================================================================================
        // Controller
        // =====================================================================================

        /// <summary>
        /// 球员列表控制器
        /// </summary>
        private PlayerListController playerListController;

        // =====================================================================================
        // Property
        // =====================================================================================

        #region PlayerInfos -- 球员信息列表

        private ObservableCollection<PlayerInfoModel> playerInfos;
        /// <summary>
        /// 球员信息列表
        /// </summary>
        public ObservableCollection<PlayerInfoModel> PlayerInfos
        {
            get { return playerInfos; }
            set { playerInfos = value; this.RaisePropertyChanged(nameof(PlayerInfos)); }
        }

        #endregion

        #region SelectedPlayerInfo -- 选中的球员信息

        private PlayerInfoModel selectedPlayerInfo;
        /// <summary>
        /// 选中的球员信息
        /// </summary>
        public PlayerInfoModel SelectedPlayerInfo
        {
            get { return selectedPlayerInfo; }
            set { selectedPlayerInfo = value; this.RaisePropertyChanged(nameof(SelectedPlayerInfo)); }
        }

        #endregion

        // =====================================================================================
        // Command
        // =====================================================================================

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        public VCommand LoadLocalDataCommand { get; set; }

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        private void LoadLocalData()
        {
            this.playerListController.LoadFromDB();
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据命令
        /// </summary>
        public VCommand LoadRemoteDataCommand { get; set; }

        /// <summary>
        /// 加载远程数据
        /// </summary>
        private void LoadRemoteData()
        {

        }

        #endregion

        #region SaveLocalDataCommand -- 保存本地数据命令

        /// <summary>
        /// 保存本地数据命令
        /// </summary>
        public VCommand SaveLocalDataCommand { get; set; }

        /// <summary>
        /// 保存本地数据
        /// </summary>
        private void SaveLocalData()
        {
            try
            {
                this.playerListController.SaveToDB();

                MessageBox.Show("保存成功");
            }
            catch (Exception ex)
            {
                log.Error(ex);

                MessageBox.Show("保存失败");
            }
        }

        #endregion

        #region AddCommand -- 添加命令

        /// <summary>
        /// 添加命令
        /// </summary>
        public VCommand AddCommand { get; set; }

        /// <summary>
        /// 添加
        /// </summary>
        private void Add()
        {
            PlayerInfoModel model = new PlayerInfoModel();
            model.PlayerID = this.PlayerInfos.Max(p => p.PlayerID) + 1;
            model.Entity = new PlayerInfo();

            this.PlayerInfos.Add(model);
        }

        #endregion

        #region DeleteCommand -- 删除命令

        /// <summary>
        /// 删除命令
        /// </summary>
        public VCommand DeleteCommand { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        private void Delete()
        {
            if (this.SelectedPlayerInfo == null)
                return;

            this.playerListController.DeleteByID(this.SelectedPlayerInfo.Entity.ID);
            this.PlayerInfos.Remove(this.SelectedPlayerInfo);

        }

        #endregion
    }
}
