﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 队伍列表控制器
    /// </summary>
    public class TeamListController
    {
        /// <summary>
        /// 队伍列表控制器
        /// </summary>
        /// <param name="support">支持</param>
        public TeamListController(ITeamListSupport support)
        {
            this.Support = support;
        }


        /// <summary>
        /// 支持
        /// </summary>
        public ITeamListSupport Support { get; private set; }

        /// <summary>
        /// 将数据保存值数据库
        /// </summary>
        public void SaveToDB()
        {
            lock (ApplicationDomainEx.TeamInfos)
            {
                foreach (TeamInfoModel model in ApplicationDomainEx.TeamInfos)
                {
                    model.UpdatePropertyToEntity();

                    ApplicationDomainEx.LiteDBContext.TeamInfos.Upsert(model.Entity);
                }
            }
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="id">主键</param>
        public void DeleteByID(int id)
        {
            ApplicationDomainEx.LiteDBContext.TeamInfos.Delete(id);
        }

        /// <summary>
        /// 从数据库中加载数据
        /// </summary>
        public void LoadFromDB()
        {
            lock (ApplicationDomainEx.TeamInfos)
            {
                Dictionary<int, TeamInfoModel> dic = ApplicationDomainEx.TeamInfos.ToDictionary(p => p.Entity.ID);

                var query = ApplicationDomainEx.LiteDBContext.TeamInfos.FindAll();

                foreach (TeamInfo entity in query)
                {
                    if (!dic.TryGetValue(entity.ID, out TeamInfoModel model))
                    {
                        model = new TeamInfoModel();
                        ApplicationDomainEx.TeamInfos.Add(model);
                    }
                    model.Entity = entity;
                    model.UpdatePropertyFromEntity();
                }
            }
        }
    }
}