﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 队伍列表视图模型
    /// </summary>
    public class TeamListViewModel : ViewModelBase, ITeamListSupport
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(TeamListViewModel));

        public TeamListViewModel()
        {
            // 初始化属性
            this.InitProperty();

            // 初始化控制器
            this.InitController();

            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadTestDataCommand = new VCommand(this.LoadTestData);
            this.LoadLocalDataCommand = new VCommand(this.LoadLocalData);
            this.LoadRemoteDataCommand = new VCommand(this.LoadRemoteData);
            this.SaveLocalDataCommand = new VCommand(this.SaveLocalData);
            this.AddCommand = new VCommand(this.Add);
            this.DeleteCommand = new VCommand(this.Delete);
        }

        /// <summary>
        /// 初始化属性
        /// </summary>
        private void InitProperty()
        {
            this.TeamInfos = ApplicationDomainEx.TeamInfos;
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void InitController()
        {
            this.teamListController = new TeamListController(this);
        }


        // =====================================================================================
        // Controller
        // =====================================================================================

        /// <summary>
        /// 队伍列表控制器
        /// </summary>
        private TeamListController teamListController;

        // =====================================================================================
        // Property
        // =====================================================================================

        #region TeamInfos -- 球员信息列表

        private ObservableCollection<TeamInfoModel> teamInfos;
        /// <summary>
        /// 球员信息列表
        /// </summary>
        public ObservableCollection<TeamInfoModel> TeamInfos
        {
            get { return teamInfos; }
            set { teamInfos = value; this.RaisePropertyChanged(nameof(TeamInfos)); }
        }

        #endregion

        #region SelectedTeamInfo -- 选中的球员信息

        private TeamInfoModel selectedTeamInfo;
        /// <summary>
        /// 选中的球员信息
        /// </summary>
        public TeamInfoModel SelectedTeamInfo
        {
            get { return selectedTeamInfo; }
            set { selectedTeamInfo = value; this.RaisePropertyChanged(nameof(SelectedTeamInfo)); }
        }

        #endregion

        // =====================================================================================
        // Command
        // =====================================================================================

        #region LoadTestDataCommand -- 加载测试数据命令

        /// <summary>
        /// 加载测试数据命令
        /// </summary>
        public VCommand LoadTestDataCommand { get; set; }

        /// <summary>
        /// 加载测试
        /// </summary>
        private void LoadTestData()
        {
            this.TeamInfos.Add(new TeamInfoModel { TeamID = 1, Name = "队伍1", Entity = new TeamInfo() });
            this.TeamInfos.Add(new TeamInfoModel { TeamID = 2, Name = "队伍2", Entity = new TeamInfo() });
        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        public VCommand LoadLocalDataCommand { get; set; }

        /// <summary>
        /// 加载本地数据命令
        /// </summary>
        private void LoadLocalData()
        {
            this.teamListController.LoadFromDB();
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据命令
        /// </summary>
        public VCommand LoadRemoteDataCommand { get; set; }

        /// <summary>
        /// 加载远程数据
        /// </summary>
        private void LoadRemoteData()
        {

        }

        #endregion

        #region SaveLocalDataCommand -- 保存本地数据命令

        /// <summary>
        /// 保存本地数据命令
        /// </summary>
        public VCommand SaveLocalDataCommand { get; set; }

        /// <summary>
        /// 保存本地数据
        /// </summary>
        private void SaveLocalData()
        {
            try
            {
                this.teamListController.SaveToDB();

                MessageBox.Show("保存成功");
            }
            catch (Exception ex)
            {
                log.Error(ex);

                MessageBox.Show("保存失败");
            }
        }

        #endregion

        #region AddCommand -- 添加命令

        /// <summary>
        /// 添加命令
        /// </summary>
        public VCommand AddCommand { get; set; }

        /// <summary>
        /// 添加
        /// </summary>
        private void Add()
        {
            TeamInfoModel model = new TeamInfoModel();
            model.Entity = new TeamInfo();
            model.TeamID = this.TeamInfos.Max(p => p.TeamID) + 1;

            this.TeamInfos.Add(model);
        }

        #endregion

        #region DeleteCommand -- 删除命令

        /// <summary>
        /// 删除命令
        /// </summary>
        public VCommand DeleteCommand { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        private void Delete()
        {
            if (this.SelectedTeamInfo == null)
                return;

            this.teamListController.DeleteByID(this.SelectedTeamInfo.Entity.ID);
            this.TeamInfos.Remove(this.SelectedTeamInfo);
        }

        #endregion
    }
}