﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 包装视图模型 -- 小组信息
    /// </summary>
    public class GroupInfoViewModel : PackageViewModelBase
    {
        public GroupInfoViewModel()
        {
            // 初始化命令
            this.InitCommnad();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommnad()
        {
            this.PresetGroupCommand = new VCommand(this.PresetGroup);
        }

        // ===================================================================================
        // Property
        // ===================================================================================

        #region Group -- 分组

        private string group;
        /// <summary>
        /// 分组
        /// </summary>
        public string Group
        {
            get { return group; }
            set { group = value; this.RaisePropertyChanged(nameof(Group)); }
        }

        #endregion

        #region GroupPickerPanelModel -- 分组选择面板模型1

        private GroupPickerPanelModel groupPickerPanelModel1 = new GroupPickerPanelModel();
        /// <summary>
        /// 分组选择面板模型1
        /// </summary>
        public GroupPickerPanelModel GroupPickerPanelModel1
        {
            get { return groupPickerPanelModel1; }
            set { groupPickerPanelModel1 = value; this.RaisePropertyChanged(nameof(GroupPickerPanelModel)); }
        }

        #endregion

        #region GroupPickerPanelModel -- 分组选择面板模型2

        private GroupPickerPanelModel groupPickerPanelModel2 = new GroupPickerPanelModel();
        /// <summary>
        /// 分组选择面板模型2
        /// </summary>
        public GroupPickerPanelModel GroupPickerPanelModel2
        {
            get { return groupPickerPanelModel2; }
            set { groupPickerPanelModel2 = value; this.RaisePropertyChanged(nameof(GroupPickerPanelModel2)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SendCommand -- 发送命令

        /// <summary>
        /// 执行发送命令
        /// </summary>
        protected override void Send()
        {

        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据
        /// </summary>
        protected override void LoadLocalData()
        {
            RealDataWindow window = new RealDataWindow();
            window.ShowDialog();

            RealDataViewModel vm = window.realDataView.DataContext as RealDataViewModel;
            if (vm == null)
                return;

            if (!vm.IsEnter)
                return;

            List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(vm.SelectedFile.FileName);

            this.UpdatePlayerTempModel(this.GroupPickerPanelModel1?.Player1, list);
            this.UpdatePlayerTempModel(this.GroupPickerPanelModel1?.Player2, list);

            this.UpdatePlayerTempModel(this.GroupPickerPanelModel2?.Player1, list);
            this.UpdatePlayerTempModel(this.GroupPickerPanelModel2?.Player2, list);
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据
        /// </summary>
        protected override void LoadRemoteData()
        {
            Task.Run(() =>
            {
                string fileName = this.realDataService.DownLoadData(INTERFACE_TOURNAMENT);

                if (string.IsNullOrWhiteSpace(fileName))
                {
                    MessageBox.Show("加载远程数据失败！");

                    return;
                }

                WPFHelper.BeginInvoke(() =>
                {
                    List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(fileName);

                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel1?.Player1, list);
                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel1?.Player2, list);

                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel2?.Player1, list);
                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel2?.Player2, list);
                });
            });
        }

        #endregion

        #region PresetGroupCommand -- 预设分组命令

        /// <summary>
        /// 预设分组命令
        /// </summary>
        public VCommand PresetGroupCommand { get; set; }

        /// <summary>
        /// 预设分组命令
        /// </summary>
        private void PresetGroup()
        {
            if (string.IsNullOrWhiteSpace(this.Group))
                return;

            // 根据学校进行分组
            var teams = ApplicationDomainEx.PlayerInfos.Where(p => p.Group == this.Group).GroupBy(p => p.TeamID).ToList();

            if (teams.Count > 0)
            {
                var team = teams[0];
                GroupTempModel model = new GroupTempModel();
                model.TeamInfo = ApplicationDomainEx.TeamInfos.FirstOrDefault(p => p.TeamID == team.Key);
                foreach (var player in team)
                {
                    model.Players.Add(player);
                }

                this.GroupPickerPanelModel1.UpdateByGroupTempModel(model);
            }
            else
            {
                this.GroupPickerPanelModel1.ClearProperty();
            }

            if (teams.Count > 1)
            {
                var team = teams[1];
                GroupTempModel model = new GroupTempModel();
                model.TeamInfo = ApplicationDomainEx.TeamInfos.FirstOrDefault(p => p.TeamID == team.Key);
                foreach (var player in team)
                {
                    model.Players.Add(player);
                }

                this.GroupPickerPanelModel2.UpdateByGroupTempModel(model);
            }
            else
            {
                this.GroupPickerPanelModel2.ClearProperty();
            }
        }

        #endregion
    }
}
