﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 分组排名视图模型基类
    /// </summary>
    public abstract class GroupRankingViewModelBase : PackageViewModelBase
    {
        // ===================================================================================
        // Property
        // ===================================================================================

        #region GroupTempModels -- 分组临时模型集合

        private ObservableCollection<GroupTempModel> groupTempModels;
        /// <summary>
        /// 分组临时模型集合
        /// </summary>
        public ObservableCollection<GroupTempModel> GroupTempModels
        {
            get { return groupTempModels; }
            set { groupTempModels = value; this.RaisePropertyChanged(nameof(GroupTempModels)); }
        }

        #endregion

        #region SelectedRound -- 选中的轮次

        private int selectedRound;
        /// <summary>
        /// 选中的轮次信息
        /// </summary>
        public int SelectedRound
        {
            get { return selectedRound; }
            set { selectedRound = value; this.RaisePropertyChanged(nameof(SelectedRound)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SendCommand -- 发送命令

        /// <summary>
        /// 执行发送命令
        /// </summary>
        protected override void Send()
        {

        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据
        /// </summary>
        protected override void LoadLocalData()
        {
            RealDataWindow window = new RealDataWindow();
            window.ShowDialog();

            RealDataViewModel vm = window.realDataView.DataContext as RealDataViewModel;
            if (vm == null)
                return;

            if (!vm.IsEnter)
                return;

            List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(vm.SelectedFile.FileName);

            this.UpdateGroupTempModels(list);
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据
        /// </summary>
        protected override void LoadRemoteData()
        {
            Task.Run(() =>
            {
                string fileName = this.realDataService.DownLoadData(INTERFACE_TOURNAMENT);

                if (string.IsNullOrWhiteSpace(fileName))
                {
                    MessageBox.Show("加载远程数据失败！");

                    return;
                }

                WPFHelper.BeginInvoke(() =>
                {
                    List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(fileName);

                    this.UpdateGroupTempModels(list);
                });
            });
        }

        #endregion

        // ===================================================================================
        // Private Function
        // ===================================================================================

        /// <summary>
        /// 更新组临时模型
        /// </summary>
        /// <param name="list">球员真实模型</param>
        protected virtual void UpdateGroupTempModels(List<PlayerRealModel> list)
        {
            ObservableCollection<GroupTempModel> groupTempModels = new ObservableCollection<GroupTempModel>();

            var groups = ApplicationDomainEx.PlayerInfos.GroupBy(p => p.Group);

            foreach (var group in groups)
            {
                foreach (var team_group in group.GroupBy(p => p.TeamID))
                {
                    GroupTempModel temp_model = new GroupTempModel();
                    temp_model.Group = group.Key;
                    foreach (PlayerInfoModel player in team_group)
                    {
                        temp_model.Players.Add(player);
                    }
                    temp_model.PlayersDisplayName = string.Join(" / ", temp_model.Players.Select(p => p.Name));
                    List<int> player_ids = temp_model.Players.Select(p => p.PlayerID).ToList();
                    temp_model.PlayersStrokes = list.Where(p => player_ids.Contains(p.PlayerID)).Sum(p => p.Strokes).ToString();
                    temp_model.TeamLogo = ApplicationDomainEx.TeamInfos.FirstOrDefault(p => p.TeamID == team_group.Key)?.Logo;

                    groupTempModels.Add(temp_model);
                }
            }

            this.GroupTempModels = groupTempModels;
        }
    }
}
