﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 底部名条视图模型
    /// </summary>
    public class NameBarBottomViewModel : PackageViewModelBase
    {
        // ===================================================================================
        // Property
        // ===================================================================================

        #region GroupPickerPanelModel -- 分组选择模型

        private GroupPickerPanelModel groupPickerPanelModel = new GroupPickerPanelModel();
        /// <summary>
        /// 分组选择模型
        /// </summary>
        public GroupPickerPanelModel GroupPickerPanelModel
        {
            get { return groupPickerPanelModel; }
            set { groupPickerPanelModel = value; this.RaisePropertyChanged(nameof(GroupPickerPanelModel)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SendCommand -- 发送命令

        /// <summary>
        /// 执行发送命令
        /// </summary>
        protected override void Send()
        {

        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据
        /// </summary>
        protected override void LoadLocalData()
        {
            RealDataWindow window = new RealDataWindow();
            window.ShowDialog();

            RealDataViewModel vm = window.realDataView.DataContext as RealDataViewModel;
            if (vm == null)
                return;

            if (!vm.IsEnter)
                return;

            List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(vm.SelectedFile.FileName);

            this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player1, list);
            this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player2, list);
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据
        /// </summary>
        protected override void LoadRemoteData()
        {
            Task.Run(() =>
            {
                string fileName = this.realDataService.DownLoadData(INTERFACE_TOURNAMENT);

                if (string.IsNullOrWhiteSpace(fileName))
                {
                    MessageBox.Show("加载远程数据失败！");

                    return;
                }

                WPFHelper.BeginInvoke(() =>
                {
                    List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(fileName);

                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player1, list);
                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player2, list);
                });
            });
        }

        #endregion
    }
}