﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Service;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 包装视图模型 -- 人名条
    /// </summary>
    public class NameBarViewModel : PackageViewModelBase
    {
        public NameBarViewModel()
        {

        }

        // ===================================================================================
        // Property
        // ===================================================================================

        #region GroupPickerPanelModel -- 分组选择模型

        private GroupPickerPanelModel groupPickerPanelModel = new GroupPickerPanelModel();
        /// <summary>
        /// 分组选择模型
        /// </summary>
        public GroupPickerPanelModel GroupPickerPanelModel
        {
            get { return groupPickerPanelModel; }
            set { groupPickerPanelModel = value; this.RaisePropertyChanged(nameof(GroupPickerPanelModel)); }
        }

        #endregion

        #region HolePickerPanelNoPictureModel -- 洞选择模型

        private HolePickerPanelNoPictureModel holePickerPanelNoPictureModel = new HolePickerPanelNoPictureModel();
        /// <summary>
        /// 洞选择模型
        /// </summary>
        public HolePickerPanelNoPictureModel HolePickerPanelNoPictureModel
        {
            get { return holePickerPanelNoPictureModel; }
            set { holePickerPanelNoPictureModel = value; this.RaisePropertyChanged(nameof(HolePickerPanelNoPictureModel)); }
        }

        #endregion

        #region DetailPanelModel -- 描述面板模型

        private DetailPanelModel detailPanelModel = new DetailPanelModel();
        /// <summary>
        /// 描述面板模型
        /// </summary>
        public DetailPanelModel DetailPanelModel
        {
            get { return detailPanelModel; }
            set { detailPanelModel = value; this.RaisePropertyChanged(nameof(DetailPanelModel)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SendCommand -- 发送命令

        /// <summary>
        /// 执行发送命令
        /// </summary>
        protected override void Send()
        {

        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据
        /// </summary>
        protected override void LoadLocalData()
        {
            RealDataWindow window = new RealDataWindow();
            window.ShowDialog();

            RealDataViewModel vm = window.realDataView.DataContext as RealDataViewModel;
            if (vm == null)
                return;

            if (!vm.IsEnter)
                return;

            List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(vm.SelectedFile.FileName);

            this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player1, list);
            this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player2, list);
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据
        /// </summary>
        protected override void LoadRemoteData()
        {
            Task.Run(() =>
            {
                string fileName = this.realDataService.DownLoadData(INTERFACE_TOURNAMENT);

                if (string.IsNullOrWhiteSpace(fileName))
                {
                    MessageBox.Show("加载远程数据失败！");

                    return;
                }

                WPFHelper.BeginInvoke(() =>
                {
                    List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(fileName);

                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player1, list);
                    this.UpdatePlayerTempModel(this.GroupPickerPanelModel?.Player2, list);
                });
            });
        }

        #endregion
    }
}
