﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 包装视图模型 -- 短板球队排名
    /// </summary>
    public class ShortTeamRankingViewModel : TeamRankingViewModelBase
    {
        public ShortTeamRankingViewModel()
        {

        }

        // ===================================================================================
        // Property
        // ===================================================================================


        // ===================================================================================
        // Command
        // ===================================================================================

        // ===================================================================================
        // Private Function
        // ===================================================================================

        /// <summary>
        /// 更新组临时模型
        /// </summary>
        /// <param name="list">球员真实模型</param>
        protected void UpdateGroupTempModels(List<PlayerRealModel> list)
        {
            ObservableCollection<TeamTempModel> teamTempModels = new ObservableCollection<TeamTempModel>();
            List<TeamTempModel> temp_list = new List<TeamTempModel>();

            foreach (TeamInfoModel info_model in ApplicationDomainEx.TeamInfos)
            {
                TeamTempModel temp_model = new TeamTempModel();
                temp_model.FromInfoModel(info_model);

                var real_players = list.Where(p => p.TeamInfoModel != null && p.TeamInfoModel.TeamID == temp_model.TeamID).ToList();

                temp_model.TotalStrokes = real_players.Sum(p => p.Strokes).ToString();
                temp_list.Add(temp_model);
            }

            temp_list = temp_list.Take(5).ToList();
            foreach (TeamTempModel temp in temp_list)
            {
                teamTempModels.Add(temp);
            }

            this.TeamTempModels = teamTempModels;
        }
    }
}
