﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 队伍排名视图模型基类
    /// </summary>
    public abstract class TeamRankingViewModelBase : PackageViewModelBase
    {

        // ===================================================================================
        // Property
        // ===================================================================================

        #region SelectedRound -- 选中的轮次

        private int selectedRound;
        /// <summary>
        /// 选中的轮次信息
        /// </summary>
        public int SelectedRound
        {
            get { return selectedRound; }
            set { selectedRound = value; this.RaisePropertyChanged(nameof(SelectedRound)); }
        }

        #endregion

        #region TeamTempModels -- 队伍临时模型集合

        private ObservableCollection<TeamTempModel> teamTempModels;
        /// <summary>
        /// 分组临时模型集合
        /// </summary>
        public ObservableCollection<TeamTempModel> TeamTempModels
        {
            get { return teamTempModels; }
            set { teamTempModels = value; this.RaisePropertyChanged(nameof(TeamTempModels)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SendCommand -- 发送命令

        /// <summary>
        /// 执行发送命令
        /// </summary>
        protected override void Send()
        {

        }

        #endregion

        #region LoadLocalDataCommand -- 加载本地数据命令

        /// <summary>
        /// 加载本地数据
        /// </summary>
        protected override void LoadLocalData()
        {
            RealDataWindow window = new RealDataWindow();
            window.ShowDialog();

            RealDataViewModel vm = window.realDataView.DataContext as RealDataViewModel;
            if (vm == null)
                return;

            if (!vm.IsEnter)
                return;

            List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(vm.SelectedFile.FileName);

            this.UpdateTeamTempModels(list);
        }

        #endregion

        #region LoadRemoteDataCommand -- 加载远程数据命令

        /// <summary>
        /// 加载远程数据
        /// </summary>
        protected override void LoadRemoteData()
        {
            Task.Run(() =>
            {
                string fileName = this.realDataService.DownLoadData(INTERFACE_TOURNAMENT);

                if (string.IsNullOrWhiteSpace(fileName))
                {
                    MessageBox.Show("加载远程数据失败！");

                    return;
                }

                WPFHelper.BeginInvoke(() =>
                {
                    List<PlayerRealModel> list = this.realDataService.LoadPlayerRealModelFormLocal(fileName);

                    this.UpdateTeamTempModels(list);
                });
            });
        }

        #endregion

        // ===================================================================================
        // Private Function
        // ===================================================================================

        /// <summary>
        /// 更新队伍临时模型
        /// </summary>
        /// <param name="list">球员真实模型</param>
        protected virtual void UpdateTeamTempModels(List<PlayerRealModel> list)
        {
            ObservableCollection<TeamTempModel> teamTempModels = new ObservableCollection<TeamTempModel>();

            foreach (TeamInfoModel info_model in ApplicationDomainEx.TeamInfos)
            {
                TeamTempModel temp_model = new TeamTempModel();
                temp_model.FromInfoModel(info_model);

                var real_players = list.Where(p => p.TeamInfoModel != null && p.TeamInfoModel.TeamID == temp_model.TeamID).ToList();

                temp_model.TotalStrokes = real_players.Sum(p => p.Strokes).ToString();
                teamTempModels.Add(temp_model);
            }

            this.TeamTempModels = teamTempModels;
        }
    }
}