﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Documents;
using VIZ.Framework.Core;
using VIZ.Framework.Module;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 应用程序启动 -- 清理本地数据
    /// </summary>
    public class AppSetup_ClearLocalData : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_ClearLocalData));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 清理本地数据";

        /// <summary>
        /// 接口数据保存数量
        /// </summary>
        private readonly static int INTERFACE_SAVE_COUNT = ApplicationDomainEx.IniStorage.GetValue<InterfaceConfig, int>(p => p.INTERFACE_SAVE_COUNT);

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            ApplicationDomainEx.LoopManager.Register("AppSetup_ClearLocalData.ExecuteClear", 60, this.ExecuteClear);

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }

        /// <summary>
        /// 执行清理
        /// </summary>
        private void ExecuteClear()
        {
            string[] files = Directory.GetFiles(ApplicationDomainEx.REMOTE_DATA_WORK_PATH);

            List<string> times = new List<string>();

            List<FileTempModel> list = new List<FileTempModel>();

            // yyyy_MM_dd__HH_mm_ss
            foreach (string file in files)
            {
                FileTempModel model = new FileTempModel();
                model.FullPath = file;
                model.FileName = Path.GetFileName(file);

                string[] parts = Path.GetFileNameWithoutExtension(file).Split(new string[] { "__" }, StringSplitOptions.RemoveEmptyEntries);
                if (parts.Length != 2)
                    continue;

                model.Time = $"{parts[0].Replace("_", "-")} {parts[1].Replace("_", ":")}";

                list.Add(model);
            }

            list = list.OrderByDescending(p => p.Time).Skip(INTERFACE_SAVE_COUNT).ToList();

            foreach (FileTempModel item in list)
            {
                try
                {
                    File.Delete(item.FullPath);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }
    }
}