﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Module;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化LiteDB
    /// </summary>
    public class AppSetup_InitLiteDB : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitLiteDB));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化LiteDB";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            string dir = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "db");
            if (!System.IO.Directory.Exists(dir))
            {
                System.IO.Directory.CreateDirectory(dir);
            }

            string path = System.IO.Path.Combine(dir, "cache.db");

            ApplicationDomainEx.LiteDBContext = new LiteDBContext(path);

            // 初始化球队信息
            this.InitTeamInfos();

            // 初始化球员信息
            this.InitPlayerInfos();

            // 初始化球洞信息
            this.InitHoleInfos();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ApplicationDomainEx.LiteDBContext?.Dispose();
            ApplicationDomainEx.LiteDBContext = null;
        }

        /// <summary>
        /// 初始化球员信息
        /// </summary>
        private void InitPlayerInfos()
        {
            ObservableCollection<PlayerInfoModel> list = new ObservableCollection<PlayerInfoModel>();
            foreach (PlayerInfo entity in ApplicationDomainEx.LiteDBContext.PlayerInfos.FindAll())
            {
                PlayerInfoModel model = new PlayerInfoModel();
                model.Entity = entity;
                model.UpdatePropertyFromEntity();
                model.TeamInfoModel = ApplicationDomainEx.TeamInfos.FirstOrDefault(p => p.TeamID == entity.TeamID);
                model.TeamID = entity.TeamID;

                list.Add(model);
            }

            ApplicationDomainEx.PlayerInfos = list;
        }

        /// <summary>
        /// 初始化球队信息
        /// </summary>
        private void InitTeamInfos()
        {
            ObservableCollection<TeamInfoModel> list = new ObservableCollection<TeamInfoModel>();
            foreach (TeamInfo entity in ApplicationDomainEx.LiteDBContext.TeamInfos.FindAll())
            {
                TeamInfoModel model = new TeamInfoModel();
                model.Entity = entity;
                model.UpdatePropertyFromEntity();

                list.Add(model);
            }

            ApplicationDomainEx.TeamInfos = list;
        }

        /// <summary>
        /// 初始化球洞信息
        /// </summary>
        private void InitHoleInfos()
        {
            ObservableCollection<HoleInfoModel> list = new ObservableCollection<HoleInfoModel>();
            foreach (HoleInfo entity in ApplicationDomainEx.LiteDBContext.HoleInfos.FindAll())
            {
                HoleInfoModel model = new HoleInfoModel();
                model.Entity = entity;
                model.UpdatePropertyFromEntity();

                list.Add(model);
            }

            ApplicationDomainEx.HoleInfos = list;
        }
    }
}