﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Module;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化资源
    /// </summary>
    public class AppSetup_InitResource : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitResource));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化资源";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            // 初始化队伍Logo
            this.InitTeamLogo();

            // 初始化洞图片
            this.InitHolePicture();

            // 初始化球员图片
            this.InitPlayerPicture();

            // 初始化分组信息
            this.InitGroups();

            // 初始化轮次信息
            this.InitRounds();

            // 初始化描述信息
            this.InitDetails();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }

        /// <summary>
        /// 初始化球员信息
        /// </summary>
        private void InitTeamLogo()
        {
            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "picture", "team");
            string[] files = System.IO.Directory.GetFiles(path);

            ObservableCollection<string> logos = new ObservableCollection<string>();
            foreach (string file in files)
            {
                logos.Add(System.IO.Path.GetFileName(file));
            }

            TvpStaticResource.TeamLogos = logos;
        }

        /// <summary>
        /// 初始化洞图片
        /// </summary>
        private void InitHolePicture()
        {
            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "picture", "hole");
            string[] files = System.IO.Directory.GetFiles(path);

            ObservableCollection<string> holes = new ObservableCollection<string>();
            foreach (string file in files)
            {
                holes.Add(System.IO.Path.GetFileName(file));
            }

            TvpStaticResource.HolePictures = holes;
        }

        /// <summary>
        /// 初始化球员图片
        /// </summary>
        private void InitPlayerPicture()
        {
            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "picture", "player");
            string[] files = System.IO.Directory.GetFiles(path);

            ObservableCollection<string> players = new ObservableCollection<string>();
            foreach (string file in files)
            {
                players.Add(System.IO.Path.GetFileName(file));
            }

            TvpStaticResource.PlayerPictures = players;
        }

        /// <summary>
        /// 初始化分组信息
        /// </summary>
        private void InitGroups()
        {
            ObservableCollection<string> groups = new ObservableCollection<string>();
            for (int i = 1; i <= 18; i++)
            {
                groups.Add(i.ToString());
            }

            TvpStaticResource.Groups = groups;
        }

        /// <summary>
        /// 初始化轮次
        /// </summary>
        private void InitRounds()
        {
            Dictionary<int, string> roundsDetail = new Dictionary<int, string>();

            roundsDetail.Add(1, "First Round");
            roundsDetail.Add(2, "Final Rund");

            ObservableCollection<int> rounds = new ObservableCollection<int>();
            foreach (var kv in roundsDetail)
            {
                rounds.Add(kv.Key);
            }

            TvpStaticResource.Rounds = rounds;
            TvpStaticResource.RoundsDetail = roundsDetail;
        }

        /// <summary>
        /// 初始化秒速信息
        /// </summary>
        private void InitDetails()
        {
            ObservableCollection<string> details = new ObservableCollection<string>();
            for (int i = 1; i <= 10; i++)
            {
                details.Add($"Detail {i}");
            }

            TvpStaticResource.Details = details;
        }
    }
}