﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 描述面板模型
    /// </summary>
    public class DetailPanelModel : ModelBase
    {
        public DetailPanelModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.PresetDetailCommand = new VCommand(this.PresetDetail);
        }

        // ===================================================================================
        // Property
        // ===================================================================================

        #region Detail -- 描述

        private string detail;
        /// <summary>
        /// 描述
        /// </summary>
        public string Detail
        {
            get { return detail; }
            set { detail = value; this.RaisePropertyChanged(nameof(Detail)); }
        }

        #endregion

        #region SelectedDetail -- 选中的描述

        private string selectedDetail;
        /// <summary>
        /// 选中的描述
        /// </summary>
        public string SelectedDetail
        {
            get { return selectedDetail; }
            set { selectedDetail = value; this.RaisePropertyChanged(nameof(SelectedDetail)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region PresetDetailCommand -- 预设描述

        /// <summary>
        /// 预设描述命令
        /// </summary>
        public VCommand PresetDetailCommand { get; set; }

        /// <summary>
        /// 预设描述
        /// </summary>
        private void PresetDetail()
        {
            this.Detail = this.SelectedDetail;
        }

        #endregion
    }
}
