﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.HtmlControls;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 组选择面板视图模型
    /// </summary>
    public class GroupPickerPanelModel : ModelBase
    {
        /// <summary>
        /// 组选择面板视图模型
        /// </summary>
        public GroupPickerPanelModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.SelectGroupCommand = new VCommand(this.SelectGroup);
        }

        // ===================================================================================
        // Property
        // ===================================================================================

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Logo -- Logo

        private string logo;
        /// <summary>
        /// 分组1 Logo
        /// </summary>
        public string Logo
        {
            get { return logo; }
            set { logo = value; this.RaisePropertyChanged(nameof(Logo)); }
        }

        #endregion

        #region SelectedGroupInfo -- 选中的分组信息

        private GroupTempModel selectedGroupInfo;
        /// <summary>
        /// 选中的分组信息
        /// </summary>
        public GroupTempModel SelectedGroupInfo
        {
            get { return selectedGroupInfo; }
            set { selectedGroupInfo = value; this.RaisePropertyChanged(nameof(SelectedGroupInfo)); }
        }

        #endregion

        #region Player1 -- 队员1

        private PlayerTempModel player1 = new PlayerTempModel();
        /// <summary>
        /// 队员1
        /// </summary>
        public PlayerTempModel Player1
        {
            get { return player1; }
            set { player1 = value; this.RaisePropertyChanged(nameof(Player1)); }
        }

        #endregion

        #region Player2 -- 队员2

        private PlayerTempModel player2 = new PlayerTempModel();
        /// <summary>
        /// 队员2
        /// </summary>
        public PlayerTempModel Player2
        {
            get { return player2; }
            set { player2 = value; this.RaisePropertyChanged(nameof(Player2)); }
        }

        #endregion

        #region PlayersDisplayName -- 组成员显示名称

        private string playersDisplayName;
        /// <summary>
        /// 组成员显示名称
        /// </summary>
        public string PlayersDisplayName
        {
            get { return playersDisplayName; }
            set { playersDisplayName = value; this.RaisePropertyChanged(nameof(PlayersDisplayName)); }
        }

        #endregion

        #region PlayersStrokes -- 组成员杆数

        private string playersStrokes;
        /// <summary>
        /// 组成员杆数
        /// </summary>
        public string PlayersStrokes
        {
            get { return playersStrokes; }
            set { playersStrokes = value; this.RaisePropertyChanged(nameof(PlayersStrokes)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region SelectGroupCommand -- 选择分组1命令

        /// <summary>
        /// 选择分组1 命令
        /// </summary>
        public VCommand SelectGroupCommand { get; set; }

        /// <summary>
        /// 选择分组1
        /// </summary>
        protected virtual void SelectGroup()
        {
            GroupPickerWindow window = new GroupPickerWindow();
            window.ShowDialog();

            GroupPickerViewModel vm = window.groupPickerView.DataContext as GroupPickerViewModel;
            if (vm == null || !vm.IsEnter)
            {
                this.SelectedGroupInfo = null;
                return;
            }

            this.SelectedGroupInfo = vm.SelectedGroupInfo;
            this.UpdateByGroupTempModel(vm.SelectedGroupInfo);
        }

        #endregion

        // ===================================================================================
        // Public Action
        // ===================================================================================

        /// <summary>
        /// 根据分组更新
        /// </summary>
        /// <param name="groupTempModel">分组临时模型</param>
        public virtual void UpdateByGroupTempModel(GroupTempModel groupTempModel)
        {
            if (groupTempModel == null)
                return;

            this.Name = groupTempModel.TeamInfo.Name;
            this.Logo = groupTempModel.TeamInfo.Logo;

            if (groupTempModel.Players.Count > 0)
            {
                PlayerInfoModel player = groupTempModel.Players[0];

                this.Player1.PlayerID = player.PlayerID;
                this.Player1.Name = player.Name;
                this.Player1.HalfPicture = player.HalfPicture;
            }

            if (groupTempModel.Players.Count > 1)
            {
                PlayerInfoModel player = groupTempModel.Players[1];

                this.player2.PlayerID = player.PlayerID;
                this.Player2.Name = player.Name;
                this.Player2.HalfPicture = player.HalfPicture;
            }

            this.UpdatePlayersProperty();
        }

        /// <summary>
        /// 清理属性
        /// </summary>
        public virtual void ClearProperty()
        {
            this.Name = null;
            this.Logo = null;

            this.Player1.PlayerID = 0;
            this.Player1.Name = null;
            this.Player1.HalfPicture = null;
            this.Player1.Strokes = 0;

            this.Player2.PlayerID = 0;
            this.Player2.Name = null;
            this.Player2.HalfPicture = null;
            this.Player2.Strokes = 0;

            this.PlayersDisplayName = null;
            this.PlayersStrokes = null;
        }

        // ===================================================================================
        // Private Action
        // ===================================================================================

        /// <summary>
        /// 更新球员集合属性
        /// </summary>
        private void UpdatePlayersProperty()
        {
            // 组成员
            StringBuilder sb = new StringBuilder();

            if (this.Player1 != null)
            {
                sb.Append(this.Player1.Name);
            }

            if (this.Player2 != null)
            {
                sb.Append(" / ");
                sb.Append(this.Player2.Name);
            }

            this.PlayersDisplayName = sb.ToString();

            // 总杆数
            int strokes = this.Player1?.Strokes ?? 0 + this.Player2?.Strokes ?? 0;
            this.PlayersStrokes = strokes == 0 ? "E" : strokes > 0 ? $"+{strokes}" : $"-{strokes}";
        }
    }
}
