﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 组筛选器
    /// </summary>
    public class GroupPickerViewModel : ViewModelBase
    {
        public GroupPickerViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // =====================================================================================
        // Property
        // =====================================================================================

        #region IsEnter -- 是否点击确定按钮

        private bool isEnter;
        /// <summary>
        /// 是否点击确定按钮
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }

        #endregion

        #region SelectedTeamInfo -- 选中的队伍信息

        private TeamInfoModel selectedTeamInfo;
        /// <summary>
        /// 选中的队伍信息
        /// </summary>
        public TeamInfoModel SelectedTeamInfo
        {
            get { return selectedTeamInfo; }
            set
            {
                selectedTeamInfo = value;
                this.RaisePropertyChanged(nameof(SelectedTeamInfo));
                this.UpdateGroupInfos();
            }
        }

        #endregion

        #region GroupInfos -- 分组信息集合

        private ObservableCollection<GroupTempModel> groupInfos;
        /// <summary>
        /// 分组信息集合
        /// </summary>
        public ObservableCollection<GroupTempModel> GroupInfos
        {
            get { return groupInfos; }
            set { groupInfos = value; this.RaisePropertyChanged(nameof(GroupInfos)); }
        }

        #endregion

        #region SelectedGroupInfo -- 选中的分组信息

        private GroupTempModel selectedGroupInfo;
        /// <summary>
        /// 选中的分组信息
        /// </summary>
        public GroupTempModel SelectedGroupInfo
        {
            get { return selectedGroupInfo; }
            set { selectedGroupInfo = value; this.RaisePropertyChanged(nameof(SelectedGroupInfo)); }
        }

        #endregion

        // =====================================================================================
        // Command
        // =====================================================================================
        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            if (this.SelectedGroupInfo == null)
            {
                MessageBox.Show("请选择分组信息");

                return;
            }

            this.IsEnter = true;

            this.GetWindow()?.Close();
        }

        #endregion

        #region CnacelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            this.IsEnter = false;

            this.GetWindow()?.Close();
        }

        #endregion

        /// <summary>
        /// 更新分组信息结合
        /// </summary>
        private void UpdateGroupInfos()
        {
            if (this.SelectedTeamInfo == null)
            {
                this.GroupInfos = null;
                this.SelectedGroupInfo = null;

                return;
            }

            ObservableCollection<GroupTempModel> groupInfos = new ObservableCollection<GroupTempModel>();

            var groups = ApplicationDomainEx.PlayerInfos.Where(p => !string.IsNullOrWhiteSpace(p.Group) && p.TeamInfoModel == this.SelectedTeamInfo).GroupBy(p => p.Group);
            foreach (var group in groups)
            {
                GroupTempModel model = new GroupTempModel();
                model.Group = group.Key;
                model.TeamInfo = this.SelectedTeamInfo;
                model.TeamLogo = this.SelectedTeamInfo.Logo;
                foreach (PlayerInfoModel item in group)
                {
                    model.Players.Add(item);
                }

                groupInfos.Add(model);
            }

            this.GroupInfos = groupInfos;
        }
    }
}
