﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 洞选择面板视图模型
    /// </summary>
    public class HolePickerPanelModel : ModelBase
    {
        public HolePickerPanelModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.PresetHoleCommand = new VCommand(this.PresetHole);
        }

        #region SelectedHoleInfo -- 选中的洞信息

        private HoleInfoModel selectedHoleInfo;
        /// <summary>
        /// 选中的洞信息
        /// </summary>
        public HoleInfoModel SelectedHoleInfo
        {
            get { return selectedHoleInfo; }
            set { selectedHoleInfo = value; this.RaisePropertyChanged(nameof(SelectedHoleInfo)); }
        }

        #endregion

        #region HoleID -- 洞编号

        private string holeID;
        /// <summary>
        /// 洞编号
        /// </summary>
        public string HoleID
        {
            get { return holeID; }
            set { holeID = value; this.RaisePropertyChanged(nameof(HoleID)); }
        }

        #endregion

        #region Par -- 标准杆

        private string par;
        /// <summary>
        /// 标准杆
        /// </summary>
        public string Par
        {
            get { return par; }
            set { par = value; this.RaisePropertyChanged(nameof(Par)); }
        }

        #endregion

        #region HolePicture -- 洞图片

        private string holePicture;
        /// <summary>
        /// 洞图片
        /// </summary>
        public string HolePicture
        {
            get { return holePicture; }
            set { holePicture = value; this.RaisePropertyChanged(nameof(HolePicture)); }
        }

        #endregion

        #region PresetHoleCommand -- 预设洞命令

        /// <summary>
        /// 预设洞命令
        /// </summary>
        public VCommand PresetHoleCommand { get; set; }

        /// <summary>
        /// 预设洞
        /// </summary>
        private void PresetHole()
        {
            if (this.SelectedHoleInfo == null)
            {
                this.HoleID = null;
                this.Par = null;
                this.HolePicture = null;
            }
            else
            {
                this.HoleID = this.SelectedHoleInfo.HoleID.ToString();
                this.Par = this.SelectedHoleInfo.Par.ToString();
                this.HolePicture = this.SelectedHoleInfo.Picture;
            }
        }

        #endregion

    }
}
