﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Service;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 真实数据视图模型
    /// </summary>
    public class RealDataViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(RealDataViewModel));

        public RealDataViewModel()
        {
            // 初始化命令
            this.InitCommnad();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommnad()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.RefreshCommand = new VCommand(this.Refresh);
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // ===================================================================================
        // Field
        // ===================================================================================

        /// <summary>
        /// 实时数据服务
        /// </summary>
        private IRealDataService realDataService = new RealDataService();

        // ===================================================================================
        // Property
        // ===================================================================================

        #region Files -- 文件集合

        private List<FileTempModel> files;
        /// <summary>
        /// 文件集合
        /// </summary>
        public List<FileTempModel> Files
        {
            get { return files; }
            set { files = value; this.RaisePropertyChanged(nameof(Files)); }
        }

        #endregion

        #region SelectedFile -- 选中的文件

        private FileTempModel selectedFile;
        /// <summary>
        /// 选中的文件
        /// </summary>
        public FileTempModel SelectedFile
        {
            get { return selectedFile; }
            set { selectedFile = value; this.RaisePropertyChanged(nameof(SelectedFile)); }
        }

        #endregion

        #region IsEnter -- 是否确定

        private bool isEnter;
        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            this.Refresh();
        }

        #endregion

        #region RefreshCommand -- 刷新命令

        /// <summary>
        /// 刷新命令
        /// </summary>
        public VCommand RefreshCommand { get; set; }

        /// <summary>
        /// 刷新
        /// </summary>
        private void Refresh()
        {
            List<string> files = this.realDataService.GetLocalDataFiles(ApplicationDomainEx.REMOTE_DATA_WORK_PATH);
            if (files == null)
                return;

            List<FileTempModel> list = new List<FileTempModel>();

            // yyyy_MM_dd__HH_mm_ss
            foreach (string file in files)
            {
                FileTempModel model = new FileTempModel();
                model.FullPath = file;
                model.FileName = Path.GetFileName(file);

                string[] parts = Path.GetFileNameWithoutExtension(file).Split(new string[] { "__" }, StringSplitOptions.RemoveEmptyEntries);
                if (parts.Length != 2)
                    continue;

                model.Time = $"{parts[0].Replace("_", "-")} {parts[1].Replace("_", ":")}";

                list.Add(model);
            }

            this.Files = list.OrderByDescending(p => p.Time).ToList();
        }

        #endregion

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            if (this.SelectedFile == null)
            {
                MessageBox.Show("请选择本地实时数据文件");
                return;
            }

            this.IsEnter = true;

            this.GetWindow()?.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            this.IsEnter = false;

            this.GetWindow()?.Close();
        }

        #endregion
    }
}
