﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.HtmlControls;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;

namespace VIZ.TVP.Golf.Module
{
    /// <summary>
    /// 队伍选择面板视图模型
    /// </summary>
    public class TeamPickerPanelModel : ModelBase
    {
        /// <summary>
        /// 组选择面板视图模型
        /// </summary>
        public TeamPickerPanelModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.PresetTeamCommand = new VCommand(this.PresetTeam);
        }

        // ===================================================================================
        // Property
        // ===================================================================================

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Logo -- Logo

        private string logo;
        /// <summary>
        /// 分组1 Logo
        /// </summary>
        public string Logo
        {
            get { return logo; }
            set { logo = value; this.RaisePropertyChanged(nameof(Logo)); }
        }

        #endregion

        #region SelectedTeamInfo -- 选中的队伍信息

        private TeamInfoModel selectedTeamInfo;
        /// <summary>
        /// 选中的队伍信息
        /// </summary>
        public TeamInfoModel SelectedTeamInfo
        {
            get { return selectedTeamInfo; }
            set { selectedTeamInfo = value; this.RaisePropertyChanged(nameof(SelectedTeamInfo)); }
        }

        #endregion

        #region PlayerTempModels -- 队员临时信息集合

        private ObservableCollection<PlayerTempModel> playerTempModels;
        /// <summary>
        /// 队员临时信息集合
        /// </summary>
        public ObservableCollection<PlayerTempModel> PlayerTempModels
        {
            get { return playerTempModels; }
            set { playerTempModels = value; this.RaisePropertyChanged(nameof(PlayerTempModels)); }
        }

        #endregion

        // ===================================================================================
        // Command
        // ===================================================================================

        #region PresetTeamCommand -- 预设队伍命令

        /// <summary>
        /// 预设队伍命令
        /// </summary>
        public VCommand PresetTeamCommand { get; set; }

        /// <summary>
        /// 预设队伍
        /// </summary>
        private void PresetTeam()
        {
            if (this.SelectedTeamInfo == null || ApplicationDomainEx.PlayerInfos == null)
                return;

            this.Name = this.SelectedTeamInfo.Name;
            this.Logo = this.SelectedTeamInfo.Logo;

            var query = ApplicationDomainEx.PlayerInfos.Where(p => p.TeamID == this.SelectedTeamInfo.TeamID);

            ObservableCollection<PlayerTempModel> models = new ObservableCollection<PlayerTempModel>();

            foreach (PlayerInfoModel item in query)
            {
                PlayerTempModel model = new PlayerTempModel();
                model.FromInfoModel(item);

                models.Add(model);
            }

            this.PlayerTempModels = models;
        }

        #endregion
    }
}
