﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Net.Http.Headers;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Service
{
    /// <summary>
    /// 真实数据服务
    /// </summary>
    public class RealDataService : IRealDataService
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(RealDataService));

        /// <summary>
        /// 文件锁对象
        /// </summary>
        private readonly object file_lock_object = new object();

        /// <summary>
        /// 加载球员数据
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns>球员实时数据</returns>
        public List<PlayerRealModel> LoadPlayerRealModelFormLocal(string fileName)
        {
            try
            {
                string path = Path.Combine(ApplicationDomainEx.REMOTE_DATA_WORK_PATH, fileName);

                if (!File.Exists(path))
                    return null;

                lock (this.file_lock_object)
                {
                    using (StreamReader sr = new StreamReader(path))
                    {
                        XElement root = XElement.Load(sr);

                        TournamentNode node = new TournamentNode();
                        node.FromXElement(root);

                        List<PlayerRealModel> list = new List<PlayerRealModel>();

                        foreach (PlayerNode player in node.Players)
                        {
                            PlayerRealModel model = new PlayerRealModel();
                            model.FromNode(player);
                            model.PlayerInfoModel = ApplicationDomainEx.PlayerInfos.FirstOrDefault(p => p.PlayerID == model.Node.id);
                            if (model.PlayerInfoModel != null)
                            {
                                model.TeamInfoModel = ApplicationDomainEx.TeamInfos.FirstOrDefault(p => p.TeamID == model.PlayerInfoModel.TeamID);
                            }

                            list.Add(model);
                        }

                        return list;
                    }
                }
            }
            catch (Exception ex)
            {
                log.Error(ex);

                return null;
            }
        }

        /// <summary>
        /// 下载数据
        /// </summary>
        /// <param name="url">接口地址</param>
        /// <returns>球员实时数据</returns>
        public string DownLoadData(string url)
        {
            try
            {
                if (!Directory.Exists(ApplicationDomainEx.REMOTE_DATA_WORK_PATH))
                {
                    Directory.CreateDirectory(ApplicationDomainEx.REMOTE_DATA_WORK_PATH);
                }

                string path = Path.Combine(ApplicationDomainEx.REMOTE_DATA_WORK_PATH, $"{DateTime.Now.ToString("yyyy_MM_dd__HH_mm_ss")}.xml");

                // 获取xml
                string xml = HttpHelper.Get(url, null);

                if (string.IsNullOrWhiteSpace(xml))
                    return null;

                // 保存文件
                lock (this.file_lock_object)
                {
                    using (FileStream fs = new FileStream(path, FileMode.Create, FileAccess.Write))
                    {
                        byte[] buffer = Encoding.UTF8.GetBytes(xml);
                        fs.Write(buffer, 0, buffer.Length);
                    }
                }

                return Path.GetFileName(path);
            }
            catch (Exception ex)
            {
                log.Error(ex);

                return null;
            }
        }

        /// <summary>
        /// 获取本地数据集合
        /// </summary>
        /// <param name="dir">工作文件夹</param>
        /// <returns>本地数据文件名</returns>
        public List<string> GetLocalDataFiles(string dir)
        {
            string[] files = Directory.GetFiles(dir, "*.xml");

            return files.ToList();
        }
    }
}
