﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.TVP.Golf.Domain;
using VIZ.TVP.Golf.Storage;

namespace VIZ.TVP.Golf.Service
{
    /// <summary>
    /// 真实数据服务
    /// </summary>
    public interface IRealDataService
    {

        /// <summary>
        /// 加载球员数据
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns>球员实时数据</returns>
        List<PlayerRealModel> LoadPlayerRealModelFormLocal(string fileName);

        /// <summary>
        /// 下载数据
        /// </summary>
        /// <param name="url">接口地址</param>
        /// <returns>最新的文件名</returns>
        string DownLoadData(string url);

        /// <summary>
        /// 获取本地数据集合
        /// </summary>
        /// <param name="dir">工作文件夹</param>
        /// <returns>本地数据文件名</returns>
        List<string> GetLocalDataFiles(string dir);
    }
}
