﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LiteDB;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// 球员信息
    /// </summary>
    public class PlayerInfo
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        [BsonId(autoId: true)]
        public int ID { get; set; }

        /// <summary>
        /// 球员编号
        /// </summary>
        public int PlayerID { get; set; }

        /// <summary>
        /// 所属队伍ID
        /// </summary>
        public int TeamID { get; set; }

        /// <summary>
        /// 球员名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public SexEnum Sex { get; set; }

        /// <summary>
        /// 分组
        /// </summary>
        public string Group { get; set; }

        /// <summary>
        /// 半身照路径（相对路径）
        /// </summary>
        public string HalfPicture { get; set; }

        /// <summary>
        /// 是否是队长
        /// </summary>
        public bool IsCaptain { get; set; }
    }
}
