﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LiteDB;
using log4net;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// LiteDB上下文
    /// </summary>
    public class LiteDBContext : IDisposable
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(LiteDBContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB 上下文
        /// </summary>
        /// <param name="path">数据库路径</param>
        public LiteDBContext(string path)
        {
            this.Path = path;
            this.Database = new LiteDatabase(path);

            this.HoleInfos = this.Database.GetCollection<HoleInfo>();
            this.PlayerInfos = this.Database.GetCollection<PlayerInfo>();
            this.RankingInfos = this.Database.GetCollection<RankingInfo>();
            this.TeamInfos = this.Database.GetCollection<TeamInfo>();
            this.TournamentInfos = this.Database.GetCollection<TournamentInfo>();
        }

        /// <summary>
        /// 路径
        /// </summary>
        public string Path { get; private set; }

        /// <summary>
        /// 洞信息
        /// </summary>
        public ILiteCollection<HoleInfo> HoleInfos { get; private set; }

        /// <summary>
        /// 球员信息
        /// </summary>
        public ILiteCollection<PlayerInfo> PlayerInfos { get; private set; }

        /// <summary>
        /// 排名信息
        /// </summary>
        public ILiteCollection<RankingInfo> RankingInfos { get; private set; }

        /// <summary>
        /// 队伍信息
        /// </summary>
        public ILiteCollection<TeamInfo> TeamInfos { get; private set; }

        /// <summary>
        /// 赛事信息
        /// </summary>
        public ILiteCollection<TournamentInfo> TournamentInfos { get; private set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.HoleInfos = null;
            this.PlayerInfos = null;
            this.RankingInfos = null;
            this.TeamInfos = null;
            this.TournamentInfos = null;

            this.Database?.Dispose();
            this.Database = null;
        }
    }
}
