﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// 球员节点
    /// </summary>
    [XmlNode("player")]
    public class PlayerNode : IXmlNode
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 全名
        /// </summary>
        public string pl_tvlname { get; set; }

        /// <summary>
        /// 名称缩写
        /// </summary>
        public string pl_tvsname { get; set; }

        /// <summary>
        /// 性别  1: 男 | 0: 女
        /// </summary>
        public int pl_sex { get; set; }

        /// <summary>
        /// 名字
        /// </summary>
        public string firstname { get; set; }

        /// <summary>
        /// 姓
        /// </summary>
        public string lastname { get; set; }

        /// <summary>
        /// 英文名
        /// </summary>
        [XmlAttribute("en-name")]
        public string en_name { get; set; }

        /// <summary>
        /// 中文名
        /// </summary>
        [XmlAttribute("cn-name")]
        public string cn_name { get; set; }

        /// <summary>
        /// 国家缩写
        /// </summary>
        public string country { get; set; }

        /// <summary>
        /// 职业球员或业余球员 PRO: 职业球员 | AMA: 业余球员
        /// </summary>
        [XmlAttribute("pro-am")]
        public string pro_am { get; set; }

        /// <summary>
        /// 状态，目前固定值 competing
        /// </summary>
        public string status { get; set; }

        /// <summary>
        /// 排名，T表示并列
        /// </summary>
        public string position { get; set; }

        /// <summary>
        /// 得分
        /// </summary>
        public int score { get; set; }

        /// <summary>
        /// 总杆数
        /// </summary>
        public int strokes { get; set; }

        /// <summary>
        /// 轮次节点集合
        /// </summary>
        public List<RoundNode> Rounds { get; set; } = new List<RoundNode>();

        /// <summary>
        /// 将当前节点转化为XElement节点
        /// </summary>
        /// <returns>XElement节点</returns>
        public XElement ToXElement()
        {
            XElement player = new XElement("player");

            // Attribute
            player.SetAttributeValue("id", this.id);
            player.SetAttributeValue("pl_tvlname", this.pl_tvlname);
            player.SetAttributeValue("pl_tvsname", this.pl_tvsname);
            player.SetAttributeValue("pl_sex", this.pl_sex);
            player.SetAttributeValue("firstname", this.firstname);
            player.SetAttributeValue("lastname", this.lastname);
            player.SetAttributeValue("en-name", this.en_name);
            player.SetAttributeValue("cn-name", this.cn_name);
            player.SetAttributeValue("country", this.country);
            player.SetAttributeValue("pro-am", this.pro_am);
            player.SetAttributeValue("status", this.status);
            player.SetAttributeValue("position", this.position);
            player.SetAttributeValue("score", this.score);
            player.SetAttributeValue("strokes", this.strokes);

            // Round
            if (this.Rounds == null)
                return player;

            foreach (RoundNode round_node in this.Rounds)
            {
                player.Add(round_node.ToXElement());
            }

            return player;
        }

        /// <summary>
        /// 从XElement节点中加载数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXElement(XElement element)
        {
            this.id = element.GetAttributeValue<int>("id");
            this.pl_tvlname = element.GetAttributeValue("pl_tvlname");
            this.pl_tvsname = element.GetAttributeValue("pl_tvsname");
            this.pl_sex = element.GetAttributeValue<int>("pl_sex");
            this.firstname = element.GetAttributeValue("firstname");
            this.lastname = element.GetAttributeValue("lastname");
            this.en_name = element.GetAttributeValue("en-name");
            this.cn_name = element.GetAttributeValue("cn-name");
            this.country = element.GetAttributeValue("country");
            this.pro_am = element.GetAttributeValue("pro-am");
            this.status = element.GetAttributeValue("status");
            this.position = element.GetAttributeValue("position");
            this.score = element.GetAttributeValue<int>("score");
            this.strokes = element.GetAttributeValue<int>("strokes");

            // Round

            var rounds = element.Elements("round");
            if (rounds == null)
                return;

            foreach (XElement round in rounds)
            {
                RoundNode round_node = new RoundNode();
                round_node.FromXElement(round);

                this.Rounds.Add(round_node);
            }
        }
    }
}
