﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Routing;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// 轮次 节点
    /// </summary>
    public class RoundNode : IXmlNode
    {
        /// <summary>
        /// 轮次序号
        /// </summary>
        public int no { get; set; }

        /// <summary>
        /// 比赛序号
        /// </summary>
        public int matchnumber { get; set; }

        /// <summary>
        /// 比赛顺序
        /// </summary>
        public int matchnumberindex { get; set; }

        /// <summary>
        /// 开球时间
        /// </summary>
        public TimeSpan teetime { get; set; }

        /// <summary>
        /// 开球台，从哪一洞开始的比赛
        /// </summary>
        public int startingtee { get; set; }

        /// <summary>
        /// 已经完成的洞数
        /// </summary>
        public int thru { get; set; }

        /// <summary>
        /// 本轮（今日）杆数与标准杆的差值
        /// </summary>
        public int today { get; set; }

        /// <summary>
        /// 本轮（进入）总杆数
        /// </summary>
        public int total { get; set; }

        /// <summary>
        /// 本轮状态 固定值：finished
        /// </summary>
        [JsonProperty(PropertyName = "round-status")]
        public string round_status { get; set; }

        /// <summary>
        /// 球员状态 固定值：competing
        /// </summary>
        [JsonProperty(PropertyName = "player-status")]
        public string player_status { get; set; }

        /// <summary>
        /// 得分集合
        /// </summary>
        public List<ScoreNode> Scores { get; set; } = new List<ScoreNode>();

        /// <summary>
        /// 将当前节点转化为XElement节点
        /// </summary>
        /// <returns>XElement节点</returns>
        public XElement ToXElement()
        {
            XElement round = new XElement("round");

            // Attribute
            round.SetAttributeValue("no", this.no);
            round.SetAttributeValue("matchnumber", this.matchnumber);
            round.SetAttributeValue("matchnumberindex", this.matchnumberindex);
            round.SetAttributeValue("teetime", this.teetime.ToString(@"hh\:mm\:ss"));
            round.SetAttributeValue("startingtee", this.startingtee);
            round.SetAttributeValue("thru", this.thru);
            round.SetAttributeValue("today", this.today);
            round.SetAttributeValue("total", this.total);
            round.SetAttributeValue("round-status", this.round_status);
            round.SetAttributeValue("player-status", this.player_status);

            // Score
            if (this.Scores == null)
                return round;

            foreach (ScoreNode score in this.Scores)
            {
                round.Add(score.ToXElement());
            }

            return round;
        }

        /// <summary>
        /// 从XElement节点中加载数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXElement(XElement element)
        {
            this.no = element.GetAttributeValue<int>("no");
            this.matchnumber = element.GetAttributeValue<int>("matchnumber");
            this.matchnumberindex = element.GetAttributeValue<int>("matchnumberindex");
            this.teetime = element.GetAttributeValue<TimeSpan>("teetime");
            this.startingtee = element.GetAttributeValue<int>("startingtee");
            this.thru = element.GetAttributeValue<int>("thru");
            this.today = element.GetAttributeValue<int>("today");
            this.total = element.GetAttributeValue<int>("total");
            this.round_status = element.GetAttributeValue("round-status");
            this.player_status = element.GetAttributeValue("player-status");

            var scores = element.Elements("score");
            if (scores == null)
                return;

            foreach (XElement score in scores)
            {
                ScoreNode score_node = new ScoreNode();
                score_node.FromXElement(score);

                this.Scores.Add(score_node);
            }
        }
    }
}
