﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// 得分 节点
    /// </summary>
    public class ScoreNode : IXmlNode
    {
        /// <summary>
        /// 洞号
        /// </summary>
        public int hole { get; set; }

        /// <summary>
        /// 杆数
        /// </summary>
        public int strokes { get; set; }

        /// <summary>
        /// 标准杆
        /// </summary>
        public int par { get; set; }

        /// <summary>
        /// 沙坑救球数
        /// </summary>
        public int bunkers { get; set; }

        /// <summary>
        /// 推杆数
        /// </summary>
        public int putts { get; set; }

        /// <summary>
        /// 开球距离
        /// </summary>
        public double drive { get; set; }

        /// <summary>
        /// 是否发球上球道 1: 是 | 0: 否 | 空: 未记录
        /// </summary>
        public int fairway { get; set; }

        /// <summary>
        /// 将当前节点转化为XElement节点
        /// </summary>
        /// <returns>XElement节点</returns>
        public XElement ToXElement()
        {
            XElement score = new XElement("score");

            score.SetAttributeValue("hole", this.hole);
            score.SetAttributeValue("strokes", this.strokes);
            score.SetAttributeValue("par", this.par);
            score.SetAttributeValue("bunkers", this.bunkers);
            score.SetAttributeValue("putts", this.putts);
            score.SetAttributeValue("drive", this.drive);
            score.SetAttributeValue("fairway", this.fairway);

            return score;
        }

        /// <summary>
        /// 从XElement节点中加载数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXElement(XElement element)
        {
            this.hole = element.GetAttributeValue<int>("hole");
            this.strokes = element.GetAttributeValue<int>("strokes");
            this.par = element.GetAttributeValue<int>("par");
            this.bunkers = element.GetAttributeValue<int>("bunkers");
            this.putts = element.GetAttributeValue<int>("putts");
            this.drive = element.GetAttributeValue<int>("drive");
            this.fairway = element.GetAttributeValue<int>("fairway");
        }
    }
}
