﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;

namespace VIZ.TVP.Golf.Storage
{
    /// <summary>
    /// 锦标赛 节点 
    /// </summary>
    [XmlNode("tournament")]
    public class TournamentNode : IXmlNode
    {
        /// <summary>
        /// 赛事中文名
        /// </summary>
        [XmlAttribute("cn-name")]
        public string cn_name { get; set; }

        /// <summary>
        /// 英文名
        /// </summary>
        [XmlAttribute("en-name")]
        public string en_name { get; set; }

        /// <summary>
        /// 中文场所
        /// </summary>
        [XmlAttribute("cn-course")]
        public string cn_course { get; set; }

        /// <summary>
        /// 英文场所
        /// </summary>
        [XmlAttribute("en-course")]
        public string en_course { get; set; }

        /// <summary>
        /// 开始日期
        /// </summary>
        public DateTime begindate { get; set; }

        /// <summary>
        /// 结束日期
        /// </summary>
        public DateTime enddate { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public string status { get; set; }

        /// <summary>
        /// 当前轮次
        /// </summary>
        [XmlAttribute("current-round")]
        public int current_round { get; set; }

        /// <summary>
        /// 总轮次
        /// </summary>
        public int maxRound { get; set; }

        /// <summary>
        /// 球员信息
        /// </summary>
        public List<PlayerNode> Players { get; set; } = new List<PlayerNode>();

        /// <summary>
        /// 将当前节点转化为XElement节点
        /// </summary>
        /// <returns>XElement节点</returns>
        public XElement ToXElement()
        {
            XElement tournament = new XElement("tournament");

            // Attribute
            tournament.SetAttributeValue("cn-name", this.cn_name);
            tournament.SetAttributeValue("en-name", this.en_name);
            tournament.SetAttributeValue("begindate", this.begindate.ToString("yyyy-MM-dd"));
            tournament.SetAttributeValue("enddate", this.enddate.ToString("yyyy-MM-dd"));
            tournament.SetAttributeValue("status", this.status);
            tournament.SetAttributeValue("current-round", this.current_round);
            tournament.SetAttributeValue("maxRound", this.maxRound);

            // Players 
            XElement players = new XElement("players");
            tournament.Add(players);

            if (this.Players == null)
                return tournament;

            // Player
            foreach (PlayerNode player in this.Players)
            {
                players.Add(player.ToXElement());
            }

            return tournament;
        }

        /// <summary>
        /// 从XElement节点中加载数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXElement(XElement element)
        {
            this.cn_name = element.GetAttributeValue("cn-name");
            this.en_name = element.GetAttributeValue("en-name");
            this.begindate = element.GetAttributeValue<DateTime>("begindate");
            this.enddate = element.GetAttributeValue<DateTime>("enddate");
            this.status = element.GetAttributeValue("status");
            this.current_round = element.GetAttributeValue<int>("current-round");
            this.maxRound = element.GetAttributeValue<int>("maxRound");

            XElement players = element.Element("players");
            if (players == null)
                return;

            var player_list = players.Elements("player");
            if (player_list == null)
                return;

            foreach (XElement player in player_list)
            {
                PlayerNode playerNode = new PlayerNode();
                playerNode.FromXElement(player);

                this.Players.Add(playerNode);
            }
        }
    }
}
